/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.rotation;

import java.util.EnumSet;
import java.util.Set;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class Node {
    public static final int NO_NETWORK = -1;
    private final BlockPos pos;
    private final long posKey;
    private final EnumSet<Direction> connections;
    @Nullable
    private Direction sourceDirection;
    @Nullable
    private Rotation sourceRotation;
    protected long networkId;

    public static EnumSet<Direction> ofAxis(Direction.Axis axis) {
        return EnumSet.of(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
    }

    protected Node(BlockPos pos, EnumSet<Direction> connections) {
        this.pos = pos.immutable();
        this.posKey = pos.asLong();
        this.connections = connections;
        this.sourceDirection = null;
        this.sourceRotation = null;
        this.networkId = -1L;
    }

    public final Set<Direction> connections() {
        return this.connections;
    }

    public final BlockPos pos() {
        return this.pos;
    }

    @Nullable
    @Contract(pure=true)
    public Direction source() {
        return this.sourceDirection;
    }

    @Nullable
    @Contract(pure=true)
    public Rotation rotation() {
        return this.sourceRotation;
    }

    @Nullable
    @Contract(pure=true)
    public Rotation rotation(Direction exitDirection) {
        if (this.sourceRotation != null) {
            assert (this.sourceDirection != null);
            return this.rotation(this.sourceRotation, this.sourceDirection, exitDirection);
        }
        return null;
    }

    public abstract Rotation rotation(Rotation var1, Direction var2, Direction var3);

    public final long network() {
        return this.networkId;
    }

    public final boolean isConnectedToNetwork() {
        return this.networkId != -1L;
    }

    @CheckReturnValue
    public boolean update(long networkId, Direction sourceDirection, Rotation sourceRotation) {
        this.networkId = networkId;
        this.sourceDirection = sourceDirection;
        this.sourceRotation = sourceRotation;
        return true;
    }

    public void setRotationFromOutsideWorld() {
        this.sourceRotation = Rotation.ofFake();
    }

    final void remove() {
        this.networkId = -1L;
        this.sourceDirection = null;
        this.sourceRotation = null;
    }

    final long posKey() {
        return this.posKey;
    }

    public String toString() {
        return "Node[connections=%s, pos=[%d, %d, %d], network=%d, rotation=%s]".formatted(this.connections(), this.pos().getX(), this.pos().getY(), this.pos().getZ(), this.network(), this.sourceRotation == null ? "null" : "[%s, Rotation[direction=%s, speed=%s]]".formatted(this.sourceDirection, this.sourceRotation.direction(), Float.valueOf(this.sourceRotation.speed())));
    }
}

