/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.Random;
import net.dries007.tfc.common.TFCAttachments;
import net.dries007.tfc.network.ChunkWatchPacket;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.chunkdata.RockData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import org.jetbrains.annotations.Nullable;

public sealed class ChunkData {
    public static final ChunkData EMPTY = new Immutable();
    private static final float UNKNOWN_RAINFALL = 250.0f;
    private static final float UNKNOWN_TEMPERATURE = 10.0f;
    private static final float UNKNOWN_RAIN_VARIANCE = 0.0f;
    private static final float UNKNOWN_BASE_GROUNDWATER = 0.0f;
    public static float MAX_RAINFALL_CONTRIBUTION = 60.0f;
    @Nullable
    private final ChunkDataGenerator generator;
    private final ChunkPos pos;
    private Status status;
    private final RockData rockData;
    @Nullable
    private LerpFloatLayer rainfallLayer;
    @Nullable
    private LerpFloatLayer rainVarianceLayer;
    @Nullable
    private LerpFloatLayer baseGroundwaterLayer;
    @Nullable
    private LerpFloatLayer temperatureLayer;
    private int @Nullable [] aquiferSurfaceHeight;
    private ForestType forestType;
    private final byte[] shuffledBlockPositions = this.getShuffledByteArray();
    private long lastRandomTick;
    private byte nextSnowPosition;

    public static ChunkData get(LevelReader level, BlockPos pos) {
        return ChunkData.get(level.getChunk(pos));
    }

    public static ChunkData get(LevelReader level, ChunkPos pos) {
        return ChunkData.get(level.getChunk(pos.x, pos.z));
    }

    public static ChunkData get(ChunkAccess chunk) {
        ChunkData chunkData;
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk impostor = (ImposterProtoChunk)chunk;
            chunkData = ChunkData.get((ChunkAccess)impostor.getWrapped());
        } else {
            chunkData = chunk instanceof EmptyLevelChunk ? EMPTY : (ChunkData)chunk.getData(TFCAttachments.CHUNK_DATA);
        }
        return chunkData;
    }

    public ChunkData(ChunkPos pos) {
        this(null, pos);
    }

    public ChunkData(@Nullable ChunkDataGenerator generator, ChunkPos pos) {
        this.generator = generator;
        this.pos = pos;
        this.status = Status.EMPTY;
        this.rockData = new RockData(generator);
        this.forestType = ForestType.GRASSLAND;
        this.lastRandomTick = Integer.MIN_VALUE;
        this.nextSnowPosition = 0;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public RockData getRockData() {
        return this.rockData;
    }

    public int[] getAquiferSurfaceHeight() {
        assert (this.aquiferSurfaceHeight != null);
        return this.aquiferSurfaceHeight;
    }

    public float getMinRainfallHydration(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        float rainfall = this.getRainfall(x, y);
        float rainVar = Math.abs(this.getRainVariance(x, y));
        return rainfall * (1.0f - rainVar) * (MAX_RAINFALL_CONTRIBUTION / 600.0f);
    }

    public float getMaxRainfallHydration(BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        float rainfall = this.getRainfall(x, y);
        float rainVar = Math.abs(this.getRainVariance(x, y));
        return Math.min(rainfall * (1.0f + rainVar) * (MAX_RAINFALL_CONTRIBUTION / 600.0f), MAX_RAINFALL_CONTRIBUTION);
    }

    public float getRainfall(BlockPos pos) {
        return this.getRainfall(pos.getX(), pos.getZ());
    }

    public float getRainfall(int x, int z) {
        return this.rainfallLayer == null ? 250.0f : this.rainfallLayer.getValue((float)(x & 0xF) / 16.0f, (float)(z & 0xF) / 16.0f);
    }

    public float getRainVariance(BlockPos pos) {
        return this.getRainVariance(pos.getX(), pos.getZ());
    }

    public float getRainVariance(int x, int z) {
        return this.rainVarianceLayer == null ? 0.0f : this.rainVarianceLayer.getValue((float)(x & 0xF) / 16.0f, (float)(z & 0xF) / 16.0f);
    }

    public float getBaseGroundwater(BlockPos pos) {
        return this.getBaseGroundwater(pos.getX(), pos.getZ());
    }

    public float getBaseGroundwater(int x, int z) {
        return this.baseGroundwaterLayer == null ? 0.0f : this.baseGroundwaterLayer.getValue((float)(x & 0xF) / 16.0f, (float)(z & 0xF) / 16.0f);
    }

    public float getGroundwater(BlockPos pos) {
        return this.getGroundwater(pos.getX(), pos.getZ());
    }

    public float getGroundwater(int x, int z) {
        return Math.min(this.getBaseGroundwater(x, z) + this.getRainfall(x, z), 500.0f);
    }

    public float getAverageSeaLevelTemp(BlockPos pos) {
        return this.getAverageSeaLevelTemp(pos.getX(), pos.getZ());
    }

    public float getAverageSeaLevelTemp(int x, int z) {
        return this.temperatureLayer == null ? 10.0f : this.temperatureLayer.getValue((float)(x & 0xF) / 16.0f, (float)(z & 0xF) / 16.0f);
    }

    public ForestType getForestType() {
        return this.forestType;
    }

    public Status status() {
        return this.status;
    }

    public long getLastRandomTick() {
        return this.lastRandomTick;
    }

    public void setLastRandomTick(ChunkAccess chunk, long lastRandomTick) {
        this.lastRandomTick = lastRandomTick;
        chunk.setUnsaved(true);
    }

    public BlockPos getNextSnowPos(ChunkPos chunkPos) {
        byte b = this.shuffledBlockPositions[this.nextSnowPosition - -128];
        int mask = 15;
        int x = b & 0xF;
        int z = b >> 4 & 0xF;
        return new BlockPos(chunkPos.getMinBlockX() + x, 0, chunkPos.getMinBlockZ() + z);
    }

    public void iterateSnowPos(ChunkAccess chunk) {
        this.nextSnowPosition = (byte)(this.nextSnowPosition + 1);
        chunk.setUnsaved(true);
    }

    public void generatePartial(LerpFloatLayer rainfallLayer, LerpFloatLayer rainVarianceLayer, LerpFloatLayer baseGroundwaterLayer, LerpFloatLayer temperatureLayer, ForestType forestType) {
        assert (this.status == Status.EMPTY);
        this.rainfallLayer = rainfallLayer;
        this.rainVarianceLayer = rainVarianceLayer;
        this.baseGroundwaterLayer = baseGroundwaterLayer;
        this.temperatureLayer = temperatureLayer;
        this.forestType = forestType;
        this.status = Status.PARTIAL;
    }

    public void generateFull(int[] surfaceHeight, int[] aquiferSurfaceHeight) {
        assert (this.status == Status.PARTIAL);
        this.rockData.setSurfaceHeight(surfaceHeight);
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        this.status = Status.FULL;
    }

    public void modifyBaseGroundwater(int[] surfaceHeight) {
        assert (this.baseGroundwaterLayer != null);
        float groundwater00 = this.modifyBaseGroundwaterPoint(surfaceHeight[0], this.baseGroundwaterLayer.value00());
        float groundwater10 = this.modifyBaseGroundwaterPoint(surfaceHeight[15], this.baseGroundwaterLayer.value10());
        float groundwater01 = this.modifyBaseGroundwaterPoint(surfaceHeight[240], this.baseGroundwaterLayer.value01());
        float groundwater11 = this.modifyBaseGroundwaterPoint(surfaceHeight[255], this.baseGroundwaterLayer.value11());
        this.baseGroundwaterLayer = new LerpFloatLayer(groundwater00, groundwater01, groundwater10, groundwater11);
    }

    public float modifyBaseGroundwaterPoint(int height, float startingWater) {
        return startingWater * Mth.clampedMap((float)height, (float)73.0f, (float)88.0f, (float)1.0f, (float)0.0f);
    }

    public ChunkWatchPacket getUpdatePacket() {
        assert (this.status == Status.FULL);
        assert (this.rainfallLayer != null && this.temperatureLayer != null && this.rainVarianceLayer != null && this.baseGroundwaterLayer != null);
        return new ChunkWatchPacket(this.pos, this.rainfallLayer, this.rainVarianceLayer, this.baseGroundwaterLayer, this.temperatureLayer, this.forestType);
    }

    public void onUpdatePacket(LerpFloatLayer rainfallLayer, LerpFloatLayer rainVarianceLayer, LerpFloatLayer baseGroundwaterLayer, LerpFloatLayer temperatureLayer, ForestType forestType) {
        assert (this.status == Status.EMPTY || this.status == Status.CLIENT);
        this.rainfallLayer = rainfallLayer;
        this.rainVarianceLayer = rainVarianceLayer;
        this.baseGroundwaterLayer = baseGroundwaterLayer;
        this.temperatureLayer = temperatureLayer;
        this.forestType = forestType;
        this.status = Status.CLIENT;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putByte("status", (byte)this.status.ordinal());
        if (this.status == Status.FULL) {
            assert (this.aquiferSurfaceHeight != null);
            nbt.putIntArray("surfaceHeight", this.rockData.getSurfaceHeight());
            nbt.putIntArray("aquiferSurfaceHeight", this.aquiferSurfaceHeight);
        }
        if (this.status == Status.FULL || this.status == Status.PARTIAL) {
            assert (this.rainfallLayer != null);
            assert (this.rainVarianceLayer != null);
            assert (this.baseGroundwaterLayer != null);
            assert (this.temperatureLayer != null);
            nbt.put("rainfall", (Tag)this.rainfallLayer.write());
            nbt.put("rainVariance", (Tag)this.rainVarianceLayer.write());
            nbt.put("baseGroundwater", (Tag)this.baseGroundwaterLayer.write());
            nbt.put("temperature", (Tag)this.temperatureLayer.write());
            nbt.putByte("forestType", (byte)this.forestType.ordinal());
            nbt.putLong("lastRandomTick", this.lastRandomTick);
            nbt.putByte("nextSnowPosition", this.nextSnowPosition);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.status = Status.valueOf(nbt.getByte("status"));
        if (this.status == Status.FULL) {
            assert (this.generator != null);
            this.rockData.setSurfaceHeight(nbt.getIntArray("surfaceHeight"));
            this.aquiferSurfaceHeight = nbt.getIntArray("aquiferSurfaceHeight");
        }
        if (this.status == Status.FULL || this.status == Status.PARTIAL) {
            this.rainfallLayer = new LerpFloatLayer(nbt.getCompound("rainfall"));
            this.rainVarianceLayer = new LerpFloatLayer(nbt.getCompound("rainVariance"));
            this.baseGroundwaterLayer = new LerpFloatLayer(nbt.getCompound("baseGroundwater"));
            this.temperatureLayer = new LerpFloatLayer(nbt.getCompound("temperature"));
            this.forestType = ForestType.valueOf(nbt.getByte("forestType"));
            this.lastRandomTick = nbt.getLong("lastRandomTick");
            this.nextSnowPosition = nbt.getByte("nextSnowPosition");
        }
    }

    public String toString() {
        return "ChunkData{pos=" + String.valueOf(this.pos) + ", status=" + String.valueOf((Object)this.status) + ", hashCode=" + Integer.toHexString(this.hashCode()) + "}";
    }

    private byte[] getShuffledByteArray() {
        byte[] arr = new byte[256];
        for (int i = 0; i < 256; ++i) {
            arr[i] = (byte)(i - 128);
        }
        Random rand = new Random();
        for (int i = arr.length - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            byte tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }
        return arr;
    }

    public static enum Status {
        EMPTY,
        CLIENT,
        PARTIAL,
        FULL,
        INVALID;

        private static final Status[] VALUES;

        public static Status valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : EMPTY;
        }

        static {
            VALUES = Status.values();
        }
    }

    private static final class Immutable
    extends ChunkData {
        private Immutable() {
            super(new ChunkPos(ChunkPos.INVALID_CHUNK_POS));
        }

        @Override
        public void generatePartial(LerpFloatLayer rainfallLayer, LerpFloatLayer rainVarianceLayer, LerpFloatLayer baseGroundwaterLayer, LerpFloatLayer temperatureLayer, ForestType forestType) {
            this.error();
        }

        @Override
        public void generateFull(int[] surfaceHeight, int[] aquiferSurfaceHeight) {
            this.error();
        }

        @Override
        public void onUpdatePacket(LerpFloatLayer rainfallLayer, LerpFloatLayer rainVarianceLayer, LerpFloatLayer baseGroundwaterLayer, LerpFloatLayer temperatureLayer, ForestType forestType) {
            this.error();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.error();
        }

        @Override
        public Status status() {
            return Status.INVALID;
        }

        @Override
        public String toString() {
            return "ImmutableChunkData";
        }

        private void error() {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }
    }
}

