/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record LerpFloatLayer(float value00, float value01, float value10, float value11) {
    public static final StreamCodec<ByteBuf, LerpFloatLayer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.value00), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.value01), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.value10), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.value11), LerpFloatLayer::new);

    public LerpFloatLayer(CompoundTag nbt) {
        this(nbt.getFloat("00"), nbt.getFloat("01"), nbt.getFloat("10"), nbt.getFloat("11"));
    }

    public float getValue(float deltaX, float deltaZ) {
        return Helpers.lerp4(this.value00, this.value01, this.value10, this.value11, deltaX, deltaZ);
    }

    public LerpFloatLayer scaled(float originX, float originZ, float width) {
        return new LerpFloatLayer(Helpers.lerp4(this.value00, this.value01, this.value10, this.value11, originX, originZ), Helpers.lerp4(this.value00, this.value01, this.value10, this.value11, originX, originZ + width), Helpers.lerp4(this.value00, this.value01, this.value10, this.value11, originX + width, originZ), Helpers.lerp4(this.value00, this.value01, this.value10, this.value11, originX + width, originZ + width));
    }

    public LerpFloatLayer apply(FloatUnaryOperator point) {
        return new LerpFloatLayer(point.apply(this.value00), point.apply(this.value01), point.apply(this.value10), point.apply(this.value11));
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("00", this.value00);
        nbt.putFloat("01", this.value01);
        nbt.putFloat("10", this.value10);
        nbt.putFloat("11", this.value11);
        return nbt;
    }
}

