/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.feature.BoulderConfig;
import net.dries007.tfc.world.noise.Metaballs3D;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BouldersFeature
extends Feature<BoulderConfig> {
    public BouldersFeature(Codec<BoulderConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BoulderConfig> context) {
        ChunkData data;
        RockSettings rock;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BoulderConfig config = (BoulderConfig)context.config();
        List<BlockState> states = config.getStates((rock = (data = ChunkData.get((LevelReader)context.level(), pos)).getRockData().getRock(pos)).raw());
        if (states != null) {
            Supplier<BlockState> stateSupplier;
            if (states.size() == 1) {
                BlockState onlyState = states.getFirst();
                stateSupplier = () -> onlyState;
            } else {
                stateSupplier = () -> (BlockState)states.get(random.nextInt(states.size()));
            }
            this.place(level, pos, stateSupplier, random);
            return true;
        }
        return false;
    }

    protected void place(WorldGenLevel level, BlockPos pos, Supplier<BlockState> state, RandomSource random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int size = 6 + random.nextInt(4);
        Metaballs3D noise = new Metaballs3D(Helpers.fork(random), 6, 8, -0.12f * (float)size, 0.3f * (float)size, 0.3f * (float)size);
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    if (!noise.inside(x, y, z)) continue;
                    mutablePos.setWithOffset((Vec3i)pos, x, y, z);
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, state.get());
                }
            }
        }
    }
}

