/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.world.TFCChunkGenerator;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class DynamicDensityRandomPatchFeature
extends Feature<RandomPatchConfiguration> {
    public DynamicDensityRandomPatchFeature(Codec<RandomPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RandomPatchConfiguration> context) {
        RandomPatchConfiguration config = (RandomPatchConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        int placed = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int width = config.xzSpread() + 1;
        int height = config.ySpread() + 1;
        int tries = this.getTries(context, level, pos, config.tries());
        for (int i = 0; i < tries; ++i) {
            mutablePos.setWithOffset((Vec3i)pos, random.nextInt(width) - random.nextInt(width), random.nextInt(height) - random.nextInt(height), random.nextInt(width) - random.nextInt(width));
            if (!((PlacedFeature)config.feature().value()).place(level, context.chunkGenerator(), random, (BlockPos)mutablePos)) continue;
            ++placed;
        }
        return placed > 0;
    }

    private int getTries(FeaturePlaceContext<RandomPatchConfiguration> context, WorldGenLevel level, BlockPos pos, int tries) {
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        ForestType forestType = data.getForestType();
        int density = forestType.getDensity();
        int seaLevel = context.chunkGenerator().getSeaLevel();
        if (pos.getY() > seaLevel + 25) {
            tries = (int)((float)tries * (1.0f - Mth.clampedMap((float)pos.getY(), (float)(seaLevel + 25), (float)(seaLevel + 100), (float)0.0f, (float)0.8f)));
        }
        switch (density) {
            case 4: {
                tries = Math.min(tries, 8);
                break;
            }
            case 3: {
                tries = Math.min(tries, 14);
                break;
            }
            case 2: {
                tries = Math.min(tries, 40);
                break;
            }
            default: {
                ChunkGenerator chunkGenerator = context.chunkGenerator();
                if (!(chunkGenerator instanceof TFCChunkGenerator)) break;
                TFCChunkGenerator generator = (TFCChunkGenerator)chunkGenerator;
                tries = (int)((float)tries * (generator.settings().grassDensity() * 2.0f));
            }
        }
        return tries;
    }
}

