/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.feature.FissureFeature;
import net.dries007.tfc.world.feature.HotSpringConfig;
import net.dries007.tfc.world.noise.Metaballs2D;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class HotSpringFeature
extends Feature<HotSpringConfig> {
    public HotSpringFeature(Codec<HotSpringConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HotSpringConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        HotSpringConfig config = (HotSpringConfig)context.config();
        Metaballs2D noise = Metaballs2D.simple(Helpers.fork(random), config.radius());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ChunkData data = ChunkData.get((LevelReader)context.level(), pos);
        RockSettings rock = data.getRockData().getRock(pos.getX(), 0, pos.getZ());
        Block rawBlock = rock.hardened();
        BlockState rockState = rawBlock.defaultBlockState();
        BlockState gravelState = rock.gravel().defaultBlockState();
        Fluid fluid = config.fluidState().getFluidState().getType();
        boolean useFilledEmptyCheck = config.fluidState().isAir();
        HashSet<BlockPos> filledEmptyPositions = new HashSet<BlockPos>();
        ArrayList<BlockPos> fissureStartPositions = new ArrayList<BlockPos>();
        Optional<Map<Block, IWeighted<BlockState>>> replacers = config.replacesOnFluidContact();
        IWeighted magma = replacers.map(map -> map.getOrDefault(rawBlock, (IWeighted)Helpers.getRandomValue(map, random))).orElse(null);
        boolean touchedWater = false;
        for (int x = -config.radius(); x <= config.radius(); ++x) {
            block1: for (int z = -config.radius(); z <= config.radius(); ++z) {
                int dy;
                int localX = pos.getX() + x;
                int localZ = pos.getZ() + z;
                int y = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ) - 1;
                if (!config.allowUnderwater() && y <= 63 || !noise.inside(x, z)) continue;
                mutablePos.set(localX, y, localZ);
                if (Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), TFCTags.Blocks.COLD_OCEAN_BLOCKS)) {
                    if (!config.allowUnderwater()) continue;
                    mutablePos.setY(50);
                    while (FluidHelpers.isAirOrEmptyFluid(level.getBlockState((BlockPos)mutablePos))) {
                        mutablePos.move(Direction.DOWN);
                    }
                    y = mutablePos.getY();
                }
                mutablePos.move(Direction.UP);
                BlockState stateAbove = level.getBlockState((BlockPos)mutablePos);
                if (!HotSpringFeature.isEmptyBlock(config, stateAbove)) {
                    if (!stateAbove.canBeReplaced()) continue;
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, stateAbove.getFluidState().createLegacyBlock());
                    mutablePos.move(0, 1, 0);
                    level.scheduleTick((BlockPos)mutablePos, level.getBlockState((BlockPos)mutablePos).getBlock(), 1);
                }
                boolean edge = false;
                if (level.getBlockState((BlockPos)mutablePos.set(localX, y, localZ).move(Direction.UP)).liquid()) {
                    touchedWater = true;
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutablePos.set(localX, y, localZ).move(direction);
                    BlockState stateAt = level.getBlockState((BlockPos)mutablePos);
                    if (stateAt.liquid()) {
                        touchedWater = true;
                    }
                    if (!HotSpringFeature.isEmptyBlock(config, stateAt) || useFilledEmptyCheck && filledEmptyPositions.contains(mutablePos)) continue;
                    edge = true;
                    break;
                }
                float centerFactor = 1.0f - 0.7f * Mth.clamp((float)((float)(2 * (x * x + z * z)) / (float)(config.radius() * config.radius())), (float)0.0f, (float)1.0f);
                int surfaceDepth = (int)((float)(8 + random.nextInt(3)) * centerFactor);
                if (edge) {
                    int startY;
                    int n = startY = random.nextInt(12) == 0 ? -1 : 0;
                    if (startY == -1) {
                        mutablePos.set(localX, y, localZ);
                        this.setBlock((LevelWriter)level, (BlockPos)mutablePos, Blocks.AIR.defaultBlockState());
                    }
                } else {
                    mutablePos.set(localX, y, localZ);
                    BlockPos posAt = mutablePos.immutable();
                    fissureStartPositions.add(posAt);
                    BlockState toPlace = touchedWater && config.allowUnderwater() && magma != null ? (BlockState)magma.get(random) : config.fluidState();
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, toPlace);
                    if (fluid != Fluids.EMPTY) {
                        level.scheduleTick((BlockPos)mutablePos, fluid, 0);
                    }
                    if (touchedWater) {
                        level.scheduleTick((BlockPos)mutablePos, toPlace.getBlock(), 20);
                    }
                    if (useFilledEmptyCheck) {
                        filledEmptyPositions.add(posAt);
                    }
                    mutablePos.set(localX, y - 1, localZ);
                    this.setFissureBaseBlock(config, level, (BlockPos)mutablePos, gravelState);
                }
                int n = dy = edge ? 0 : -2;
                while (dy >= -surfaceDepth) {
                    mutablePos.set(localX, y + dy, localZ);
                    if (!this.setFissureBaseBlock(config, level, (BlockPos)mutablePos, rockState)) continue block1;
                    --dy;
                }
            }
        }
        if (fissureStartPositions.isEmpty()) {
            return false;
        }
        int fissureStarts = 1 + random.nextInt(1 + random.nextInt(Mth.clamp((int)fissureStartPositions.size(), (int)1, (int)7)));
        List<BlockPos> selected = Helpers.uniqueRandomSample(fissureStartPositions, fissureStarts, random);
        for (BlockPos start : selected) {
            FissureFeature.placeFissure(level, start, pos, mutablePos, random, config.fluidState(), rockState, 10, 22, 6, 16, 12, config.decoration().orElse(null));
        }
        return true;
    }

    private boolean setFissureBaseBlock(HotSpringConfig config, WorldGenLevel level, BlockPos pos, BlockState state) {
        BlockState stateAt = level.getBlockState(pos);
        if (HotSpringFeature.isEmptyBlock(config, stateAt)) {
            return false;
        }
        level.setBlock(pos, state, 2);
        return true;
    }

    private static boolean isEmptyBlock(HotSpringConfig config, BlockState state) {
        return config.allowUnderwater() ? FluidHelpers.isAirOrEmptyFluid(state) : state.isAir();
    }
}

