/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class NoisyMultipleFeature
extends Feature<SimpleRandomFeatureConfiguration> {
    public NoisyMultipleFeature(Codec<SimpleRandomFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleRandomFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        ChunkData data = ChunkData.get((LevelReader)context.level(), pos);
        int rotation = (int)Math.ceil(data.getAverageSeaLevelTemp(pos) * 10.0f * (float)((SimpleRandomFeatureConfiguration)context.config()).features.size());
        List features = ((SimpleRandomFeatureConfiguration)context.config()).features.stream().collect(Collectors.toList());
        Collections.rotate(features, rotation);
        int placed = 0;
        for (Holder feature : features) {
            if (!((PlacedFeature)feature.value()).placeWithBiomeCheck(context.level(), context.chunkGenerator(), context.random(), pos) || ++placed <= 1) continue;
            return true;
        }
        return placed > 0;
    }
}

