/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;

public class TidePoolFeature
extends Feature<NoneFeatureConfiguration> {
    public TidePoolFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        boolean placedAny = false;
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        if (origin.getY() > 67 || origin.getY() < 62) {
            return false;
        }
        boolean hasRim = random.nextDouble() < 0.9;
        int rimOffsetX = hasRim ? Mth.nextInt((RandomSource)random, (int)0, (int)2) : 0;
        int rimOffsetZ = hasRim ? Mth.nextInt((RandomSource)random, (int)0, (int)2) : 0;
        boolean willPlaceRim = hasRim && rimOffsetX != 0 && rimOffsetZ != 0;
        int xSize = Mth.nextInt((RandomSource)random, (int)3, (int)7);
        int zSize = Mth.nextInt((RandomSource)random, (int)3, (int)7);
        int maxLength = Math.max(xSize, zSize);
        RockSettings rock = ChunkData.get((LevelReader)context.level(), origin).getRockData().getRock(origin);
        BlockState cobble = rock.cobble().defaultBlockState();
        BlockState raw = rock.raw().defaultBlockState();
        BlockState water = ((LiquidBlock)TFCBlocks.SALT_WATER.get()).defaultBlockState();
        Predicate<BlockState> test = state -> state.getBlock() == cobble.getBlock() || !state.getFluidState().isEmpty();
        Iterator iterator = BlockPos.withinManhattan((BlockPos)origin, (int)xSize, (int)0, (int)zSize).iterator();
        while (iterator.hasNext() && (pos = (BlockPos)iterator.next()).distManhattan((Vec3i)origin) <= maxLength) {
            BlockPos offsetPos;
            if (!TidePoolFeature.isClear((LevelAccessor)level, pos, test)) continue;
            if (willPlaceRim) {
                placedAny = true;
                this.setBlock((LevelWriter)level, pos, raw);
                if (random.nextFloat() < 0.01f && level.getBlockState(pos.above()).isAir()) {
                    this.setBlock((LevelWriter)level, pos.above(), ((Block)TFCBlocks.GROUNDCOVER.get((Object)GroundcoverBlockType.GUANO).get()).defaultBlockState());
                }
            }
            if (!TidePoolFeature.isClear((LevelAccessor)level, offsetPos = pos.offset(rimOffsetX, 0, rimOffsetZ), test)) continue;
            placedAny = true;
            BlockState toPlace = cobble;
            if (random.nextBoolean()) {
                toPlace = water;
                if (random.nextFloat() < 0.15f) {
                    BlockState groundcover = Helpers.randomBlock(TFCTags.Blocks.TIDE_POOL_BLOCKS, random).map(Block::defaultBlockState).orElse(water);
                    if ((groundcover = FluidHelpers.fillWithFluid(groundcover, (Fluid)TFCFluids.SALT_WATER.getSource())) != null) {
                        toPlace = groundcover;
                    }
                }
            }
            this.setBlock((LevelWriter)level, offsetPos, toPlace);
        }
        return placedAny;
    }

    private static boolean isClear(LevelAccessor level, BlockPos pos, Predicate<BlockState> contentsTest) {
        if (contentsTest.test(level.getBlockState(pos))) {
            return false;
        }
        for (Direction direction : Helpers.DIRECTIONS) {
            boolean airAbove = level.getBlockState(pos.relative(direction)).isAir();
            if ((!airAbove || direction == Direction.UP) && (airAbove || direction != Direction.UP)) continue;
            return false;
        }
        return true;
    }
}

