/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.RockSpikeBlock;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CaveSpikesFeature
extends Feature<NoneFeatureConfiguration> {
    public CaveSpikesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Direction direction;
        BlockState wallState;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        RockLayerSettings rockSettings = ((ChunkGeneratorExtension)context.chunkGenerator()).rockLayerSettings();
        RockSettings wallRock = rockSettings.getRock((wallState = level.getBlockState(pos.relative((direction = random.nextBoolean() ? Direction.UP : Direction.DOWN).getOpposite()))).getBlock());
        if (wallRock != null && wallRock.isRawOrHardened(wallState)) {
            this.placeIfPresent(level, pos, direction, random, wallRock);
        } else {
            wallState = level.getBlockState(pos.relative(direction = direction.getOpposite()));
            wallRock = rockSettings.getRock(wallState.getBlock());
            if (wallRock != null && wallRock.isRawOrHardened(wallState)) {
                this.placeIfPresent(level, pos, direction, random, wallRock);
            }
        }
        return true;
    }

    protected void place(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, RandomSource random) {
        this.placeSmallSpike(level, pos, spike, raw, direction, random);
    }

    protected void placeSmallSpike(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, RandomSource random) {
        this.placeSmallSpike(level, pos, spike, raw, direction, random.nextFloat());
    }

    protected void placeSmallSpike(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, float sizeWeight) {
        BlockPos above = pos.above();
        BlockState stateAbove = level.getBlockState(pos.above());
        if (Helpers.isBlock(stateAbove, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD)) {
            level.setBlock(above, raw, 2);
        }
        if (sizeWeight < 0.2f) {
            this.replaceBlock(level, pos, (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.MIDDLE)));
            this.replaceBlock(level, pos.relative(direction, 1), (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.TIP)));
        } else if (sizeWeight < 0.7f) {
            this.replaceBlock(level, pos, (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.BASE)));
            this.replaceBlock(level, pos.relative(direction, 1), (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.MIDDLE)));
            this.replaceBlock(level, pos.relative(direction, 2), (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.TIP)));
        } else {
            this.replaceBlockWithoutFluid(level, pos, raw);
            this.replaceBlock(level, pos.relative(direction, 1), (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.BASE)));
            this.replaceBlock(level, pos.relative(direction, 2), (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.MIDDLE)));
            this.replaceBlock(level, pos.relative(direction, 3), (BlockState)spike.setValue(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.TIP)));
        }
    }

    protected void replaceBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        Block block = level.getBlockState(pos).getBlock();
        if (block == Blocks.CAVE_AIR) {
            this.setBlock((LevelWriter)level, pos, state);
        } else if (block == Blocks.WATER || block == TFCBlocks.RIVER_WATER.get()) {
            this.setBlock((LevelWriter)level, pos, (BlockState)state.setValue((Property)RockSpikeBlock.FLUID, (Comparable)RockSpikeBlock.FLUID.keyFor((Fluid)Fluids.WATER)));
        } else if (block == TFCBlocks.SALT_WATER.get()) {
            this.setBlock((LevelWriter)level, pos, (BlockState)state.setValue((Property)RockSpikeBlock.FLUID, (Comparable)RockSpikeBlock.FLUID.keyFor((Fluid)TFCFluids.SALT_WATER.getSource())));
        } else if (block == Blocks.LAVA) {
            this.setBlock((LevelWriter)level, pos, (BlockState)state.setValue((Property)RockSpikeBlock.FLUID, (Comparable)RockSpikeBlock.FLUID.keyFor((Fluid)Fluids.LAVA)));
        }
    }

    protected void replaceBlockWithoutFluid(WorldGenLevel level, BlockPos pos, BlockState state) {
        Block block = level.getBlockState(pos).getBlock();
        if (block == Blocks.CAVE_AIR || block == Blocks.WATER || block == TFCBlocks.SALT_WATER.get() || block == TFCBlocks.RIVER_WATER.get() || block == Blocks.LAVA) {
            this.setBlock((LevelWriter)level, pos, state);
        }
    }

    private void placeIfPresent(WorldGenLevel level, BlockPos pos, Direction direction, RandomSource random, RockSettings wallRock) {
        wallRock.spike().ifPresent(spike -> this.place(level, pos, spike.defaultBlockState(), wallRock.hardened().defaultBlockState(), direction, random));
    }
}

