/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class IceCaveFeature
extends Feature<NoneFeatureConfiguration> {
    public IceCaveFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        OverworldClimateModel model = OverworldClimateModel.getIfPresent(level);
        if (model == null) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkData chunkData = ChunkData.get((LevelReader)level, chunkPos);
        for (int i = 0; i < 72; ++i) {
            mutablePos.setWithOffset((Vec3i)pos, random.nextInt(15) - random.nextInt(15), -3, random.nextInt(15) - random.nextInt(15));
            float maxTemperature = model.getAverageMonthlyTemperature(mutablePos.getZ(), mutablePos.getY(), chunkData.getAverageSeaLevelTemp((BlockPos)mutablePos), 1.0f, true);
            if (maxTemperature > -4.0f) {
                return false;
            }
            if (level.getBlockState((BlockPos)mutablePos).getBlock() == Blocks.CAVE_AIR) {
                for (int j = 0; j < 7; ++j) {
                    mutablePos.move(0, -1, 0);
                    if (!level.isEmptyBlock((BlockPos)mutablePos)) break;
                }
                BlockState finalState = level.getBlockState((BlockPos)mutablePos);
                mutablePos.move(Direction.UP);
                if (Helpers.isBlock(finalState, (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD)) {
                    this.placeDisc(level, mutablePos, random);
                } else if (Helpers.isBlock(finalState, (TagKey<Block>)BlockTags.ICE) && random.nextFloat() < 0.03f) {
                    this.placeDisc(level, mutablePos, random);
                }
            } else if (mutablePos.getY() < 96 && random.nextFloat() < 0.1f) {
                mutablePos.move(Direction.UP, 5);
                if (!level.isEmptyBlock((BlockPos)mutablePos)) {
                    mutablePos.move(Direction.DOWN, 3);
                    if (level.isEmptyBlock((BlockPos)mutablePos)) {
                        this.placeSphere(level, mutablePos, random);
                    }
                }
            }
            if (random.nextFloat() < 0.002f) {
                mutablePos.setY(4 + random.nextInt(7));
                if (level.isEmptyBlock((BlockPos)mutablePos)) {
                    mutablePos.move(Direction.UP);
                    if (Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD)) {
                        this.setBlock((LevelWriter)level, (BlockPos)mutablePos, Fluids.WATER.defaultFluidState().createLegacyBlock());
                        level.scheduleTick((BlockPos)mutablePos, (Fluid)Fluids.WATER, 0);
                    }
                }
            }
            if (!(random.nextFloat() < 0.03f) || mutablePos.getY() >= 96 || !Helpers.isBlock(level.getBlockState((BlockPos)mutablePos), (TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD)) continue;
            mutablePos.move(Direction.DOWN);
            if (level.isEmptyBlock((BlockPos)mutablePos)) {
                this.placeSpike(level, mutablePos, random, Direction.DOWN);
                continue;
            }
            mutablePos.move(Direction.UP, 2);
            if (!level.isEmptyBlock((BlockPos)mutablePos)) continue;
            this.placeSpike(level, mutablePos, random, Direction.UP);
        }
        return true;
    }

    private void placeSpike(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, RandomSource rand, Direction direction) {
        BlockState state = this.getState(rand);
        BlockPos pos = mutablePos.immutable();
        int height = 6 + rand.nextInt(11);
        int radius = 2 + rand.nextInt(1);
        int maxHeightReached = 0;
        for (int y = -3; y <= height; ++y) {
            float radiusSquared = (float)radius * (1.0f - 1.5f * (float)Math.abs(y) / (float)height);
            if (radiusSquared < 0.0f) continue;
            radiusSquared *= radiusSquared;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.set((Vec3i)pos).move(x, y * direction.getStepY(), z);
                    float actualRadius = (float)(x * x + z * z) / radiusSquared;
                    if ((double)actualRadius < 0.7) {
                        this.setBlock((LevelWriter)world, (BlockPos)mutablePos, state);
                        if (x != 0 || z != 0) continue;
                        maxHeightReached = y;
                        continue;
                    }
                    if (!((double)actualRadius < 0.85) || !rand.nextBoolean() || world.getBlockState(mutablePos.offset(0, -direction.getStepY(), 0)) != state) continue;
                    this.setBlock((LevelWriter)world, (BlockPos)mutablePos, state);
                }
            }
        }
        mutablePos.set((Vec3i)pos).move(direction, maxHeightReached - 1);
    }

    private void placeDisc(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, RandomSource random) {
        float radius = 1.0f + random.nextFloat() * random.nextFloat() * 3.5f;
        float radiusSquared = radius * radius;
        int size = Mth.ceil((float)radius);
        BlockPos pos = mutablePos.immutable();
        BlockState ice = this.getState(random);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutablePos.move(d);
            mutablePos.move(Direction.DOWN, 2);
            if (world.isEmptyBlock((BlockPos)mutablePos)) {
                return;
            }
            mutablePos.move(d.getOpposite());
            mutablePos.move(Direction.UP, 2);
        }
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!((float)(x * x + z * z) <= radiusSquared)) continue;
                mutablePos.set((Vec3i)pos).move(x, -1, z);
                if (!world.isEmptyBlock((BlockPos)mutablePos)) {
                    mutablePos.move(Direction.UP);
                }
                this.setBlock((LevelWriter)world, (BlockPos)mutablePos, ice);
            }
        }
    }

    private void placeSphere(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, RandomSource rand) {
        float radius = 1.0f + rand.nextFloat() * rand.nextFloat() * 3.0f;
        float radiusSquared = radius * radius;
        int size = Mth.ceil((float)radius);
        BlockPos pos = mutablePos.immutable();
        BlockState ice = Blocks.ICE.defaultBlockState();
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    if (!((float)(x * x + y * y + z * z) <= radiusSquared)) continue;
                    mutablePos.set((Vec3i)pos).move(x, y, z);
                    if (!world.isEmptyBlock((BlockPos)mutablePos)) continue;
                    this.setBlock((LevelWriter)world, (BlockPos)mutablePos, ice);
                }
            }
        }
    }

    private BlockState getState(RandomSource rand) {
        if (rand.nextFloat() < 0.4f) {
            return Blocks.PACKED_ICE.defaultBlockState();
        }
        return Blocks.BLUE_ICE.defaultBlockState();
    }
}

