/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.plant.CreepingPlantBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.feature.plant.CreepingPlantConfig;
import net.dries007.tfc.world.noise.Noise2D;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CreepingPlantFeature
extends Feature<CreepingPlantConfig> {
    public CreepingPlantFeature(Codec<CreepingPlantConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CreepingPlantConfig> context) {
        WorldGenLevel level = context.level();
        Seed seed = Seed.of(level.getSeed());
        Noise2D maxTideHeight = BiomeNoise.shoreTideLevelNoise(seed);
        BlockPos pos = context.origin();
        BlockState state = ((CreepingPlantConfig)context.config()).block().defaultBlockState();
        int radius = ((CreepingPlantConfig)context.config()).radius();
        int height = ((CreepingPlantConfig)context.config()).height();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < height; ++y) {
                    BlockState newState;
                    if (x * x + z + z >= radius * radius || !(context.random().nextFloat() < ((CreepingPlantConfig)context.config()).integrity())) continue;
                    cursor.setWithOffset((Vec3i)pos, x, y, z);
                    if (!EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor) || !((double)cursor.getY() > (double)((CreepingPlantConfig)context.config()).heightAboveTide() + 0.5 + maxTideHeight.noise(cursor.getX(), cursor.getZ())) || (newState = CreepingPlantBlock.updateStateFromSides((LevelAccessor)level, (BlockPos)cursor, state)).isAir()) continue;
                    this.setBlock((LevelWriter)level, (BlockPos)cursor, newState);
                }
            }
        }
        return false;
    }
}

