/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.plant.KelpTreeFlowerBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SpreadingBushFeature
extends Feature<BlockConfig<SpreadingBushBlock>> {
    public static final Codec<BlockConfig<SpreadingBushBlock>> CODEC = BlockConfig.codec(b -> {
        SpreadingBushBlock t;
        return b instanceof SpreadingBushBlock ? (t = (SpreadingBushBlock)b) : null;
    }, "Must be a " + KelpTreeFlowerBlock.class.getSimpleName());

    public SpreadingBushFeature(Codec<BlockConfig<SpreadingBushBlock>> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockConfig<SpreadingBushBlock>> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        SpreadingBushBlock block = (SpreadingBushBlock)((BlockConfig)context.config()).block();
        boolean any = false;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int tries = 0; tries < 5; ++tries) {
            cursor.setWithOffset((Vec3i)pos, random.nextInt(3) - random.nextInt(3), random.nextInt(2) - random.nextInt(2), random.nextInt(3) - random.nextInt(3));
            BlockState stateToPlace = block.defaultBlockState();
            if (!block.canSurvive(stateToPlace, (LevelReader)level, (BlockPos)cursor) || level.getBlockState(cursor.below()).getBlock() == block) continue;
            int height = 1 + random.nextInt(3);
            for (int i = 0; i < height && EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor); ++i) {
                any = true;
                int stage = height - i - 1;
                level.setBlock((BlockPos)cursor, (BlockState)stateToPlace.setValue((Property)SpreadingBushBlock.STAGE, (Comparable)Integer.valueOf(stage)), 2);
                Direction offset = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                cursor.move(offset);
                if (stage > 0 && EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor)) {
                    level.setBlock((BlockPos)cursor, (BlockState)block.getCane().defaultBlockState().setValue((Property)SpreadingCaneBlock.FACING, (Comparable)offset), 2);
                }
                cursor.move(offset.getOpposite());
                cursor.move(Direction.UP);
            }
        }
        return any;
    }
}

