/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blocks.crop.WildSpreadingCropBlock;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SpreadingCropFeature
extends Feature<BlockConfig<WildSpreadingCropBlock>> {
    public static final Codec<BlockConfig<WildSpreadingCropBlock>> CODEC = BlockConfig.codec(b -> {
        WildSpreadingCropBlock t;
        return b instanceof WildSpreadingCropBlock ? (t = (WildSpreadingCropBlock)b) : null;
    }, "Must be a " + WildSpreadingCropBlock.class.getSimpleName());

    public SpreadingCropFeature(Codec<BlockConfig<WildSpreadingCropBlock>> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockConfig<WildSpreadingCropBlock>> context) {
        Direction direction;
        BlockPos origin;
        BlockPos offsetPos;
        BlockPos below;
        WildSpreadingCropBlock block = (WildSpreadingCropBlock)((BlockConfig)context.config()).block();
        WorldGenLevel level = context.level();
        if (Helpers.isBlock(level.getBlockState(below = (offsetPos = (origin = context.origin()).relative(direction = Direction.Plane.HORIZONTAL.getRandomDirection(context.random()))).below()), TFCTags.Blocks.SPREADING_FRUIT_GROWS_ON) && EnvironmentHelpers.isWorldgenReplaceable(level, offsetPos)) {
            this.setBlock((LevelWriter)level, offsetPos, block.getFruit().defaultBlockState());
            BlockEntity blockEntity = level.getBlockEntity(offsetPos);
            if (blockEntity instanceof DecayingBlockEntity) {
                DecayingBlockEntity decaying = (DecayingBlockEntity)blockEntity;
                ItemStack food = new ItemStack((ItemLike)block.getFruit());
                FoodCapability.applyTrait(food, FoodTraits.WILD);
                decaying.setStack(food);
            }
            this.setBlock((LevelWriter)level, origin, (BlockState)block.defaultBlockState().setValue((Property)WildSpreadingCropBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true)));
        }
        return true;
    }
}

