/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class TFCVinesFeature
extends Feature<BlockStateConfiguration> {
    public TFCVinesFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        if (level.isEmptyBlock(pos)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!VineBlock.isAcceptableNeighbour((BlockGetter)level, (BlockPos)pos.relative(direction), (Direction)direction)) continue;
                state = (BlockState)state.setValue((Property)VineBlock.getPropertyForFace((Direction)direction), (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 2);
                this.placeColumnBelow(level, pos, state, context.random().nextInt(14));
                return true;
            }
        }
        return false;
    }

    private void placeColumnBelow(WorldGenLevel level, BlockPos pos, BlockState state, int maxLength) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int i = 0; i < maxLength; ++i) {
            cursor.move(0, -1, 0);
            if (!level.getBlockState((BlockPos)cursor).isAir()) {
                return;
            }
            level.setBlock((BlockPos)cursor, state, 2);
        }
    }
}

