/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.feature.tree.ForestConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.Nullable;

public class ForestFeature
extends Feature<ForestConfig> {
    public ForestFeature(Codec<ForestConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ForestConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        ForestConfig config = (ForestConfig)context.config();
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ForestType forestType = data.getForestType();
        if (random.nextFloat() > forestType.getPerChunkChance()) {
            return false;
        }
        int treeCount = forestType.sampleTrees(random);
        int bushCount = forestType.sampleBushes(random);
        boolean placedTrees = false;
        boolean placedBushes = false;
        for (int i = 0; i < treeCount; ++i) {
            placedTrees |= this.placeTree(level, context.chunkGenerator(), random, pos, config, data, mutablePos, forestType);
        }
        for (int j = 0; j < bushCount; ++j) {
            placedBushes |= this.placeBush(level, random, pos, config, data, mutablePos, forestType);
        }
        if (placedTrees) {
            this.placeGroundcover(level, random, pos, config, data, mutablePos, forestType.sampleGroundcover(random), forestType);
            this.placeLeafPile(level, random, pos, config, data, mutablePos, forestType.sampleLeafPiles(random), forestType);
            this.placeFallenTree(level, random, pos, config, data, mutablePos, forestType);
        }
        return placedTrees || placedBushes;
    }

    private boolean placeTree(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, ForestType typeConfig) {
        int chunkX = chunkBlockPos.getX();
        int chunkZ = chunkBlockPos.getZ();
        mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, mutablePos.getX(), mutablePos.getZ()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos, typeConfig, level);
        if (entry != null) {
            int spoilerChance;
            float treeMinTemp;
            float krumChance;
            if (entry.floating()) {
                mutablePos.setY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.getX(), mutablePos.getZ()) + random.nextInt(2));
            }
            int oldChance = entry.oldGrowthChance();
            int deadChance = entry.deadChance();
            float blockTemp = EnvironmentHelpers.adjustAvgTempForElev(mutablePos.getY(), data.getAverageSeaLevelTemp((BlockPos)mutablePos));
            float f = krumChance = blockTemp > (treeMinTemp = entry.getClimatePlacement().getMinTemp()) + 5.0f ? 0.0f : Mth.clampedMap((float)blockTemp, (float)(treeMinTemp + 2.5f), (float)(treeMinTemp + 5.0f), (float)1.0f, (float)0.0f);
            ConfiguredFeature<?, ?> feature = entry.krummholz().isPresent() && random.nextFloat() < krumChance ? (ConfiguredFeature<?, ?>)entry.krummholz().get().value() : (typeConfig.isPrimary() && oldChance > 0 && random.nextInt(oldChance) == 0 ? entry.getOldGrowthFeature() : (deadChance > 0 && (random.nextInt(deadChance) == 0 || typeConfig.isDead()) ? entry.getDeadFeature() : ((spoilerChance = entry.spoilerOldGrowthChance()) > 0 && random.nextInt(spoilerChance) == 0 ? entry.getOldGrowthFeature() : entry.getFeature())));
            if (typeConfig.getDensity() >= 3) {
                this.placeSoilDisc(level, generator, random, mutablePos, entry);
            }
            return feature.place(level, generator, random, (BlockPos)mutablePos);
        }
        return false;
    }

    private boolean placeBush(WorldGenLevel level, RandomSource random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, ForestType type) {
        int chunkX = chunkBlockPos.getX();
        int chunkZ = chunkBlockPos.getZ();
        mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.setY(level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.getX(), mutablePos.getZ()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos, type, level);
        if (entry != null && EnvironmentHelpers.canPlaceBushOn(level, (BlockPos)mutablePos)) {
            entry.bushLog().ifPresent(log -> entry.bushLeaves().ifPresent(leaves -> {
                this.placeBushPart(level, mutablePos, (BlockState)log, (BlockState)leaves, 1.0f, random, true);
                for (int i = 0; i < 5; ++i) {
                    if (random.nextInt(4) != 0) continue;
                    mutablePos.move(Direction.Plane.HORIZONTAL.getRandomDirection(random));
                    this.placeBushPart(level, mutablePos, (BlockState)leaves, (BlockState)leaves, 0.7f, random, false);
                    if (random.nextInt(6) != 0) continue;
                    mutablePos.move(Direction.UP);
                    this.placeBushPart(level, mutablePos, (BlockState)leaves, (BlockState)leaves, 0.6f, random, false);
                    break;
                }
            }));
            return true;
        }
        return false;
    }

    private void placeBushPart(WorldGenLevel level, BlockPos.MutableBlockPos mutablePos, BlockState log, BlockState leaves, float decay, RandomSource rand, boolean needsEmptyCenter) {
        if (EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)mutablePos)) {
            this.setBlock((LevelWriter)level, (BlockPos)mutablePos, log);
        } else if (needsEmptyCenter) {
            return;
        }
        for (Direction facing : Helpers.DIRECTIONS) {
            BlockPos offsetPos;
            if (facing == Direction.DOWN || !EnvironmentHelpers.isWorldgenReplaceable(level, offsetPos = mutablePos.offset(facing.getStepX(), facing.getStepY(), facing.getStepZ())) || !(rand.nextFloat() < decay)) continue;
            this.setBlock((LevelWriter)level, offsetPos, leaves);
        }
    }

    private void placeGroundcover(WorldGenLevel level, RandomSource random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, int tries, ForestType type) {
        if (tries == 0) {
            return;
        }
        int chunkX = chunkBlockPos.getX();
        int chunkZ = chunkBlockPos.getZ();
        mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR, mutablePos.getX(), mutablePos.getZ()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos, type, level);
        if (entry != null) {
            entry.groundcover().ifPresent(groundcover -> {
                for (int j = 0; j < tries; ++j) {
                    BlockState placementState = (BlockState)groundcover.get(random);
                    mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
                    mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR, mutablePos.getX(), mutablePos.getZ()));
                    placementState = FluidHelpers.fillWithFluid(placementState, level.getFluidState((BlockPos)mutablePos).getType());
                    if (placementState == null || !EnvironmentHelpers.isWorldgenReplaceable(level.getBlockState((BlockPos)mutablePos)) || !EnvironmentHelpers.isOnSturdyFace(level, (BlockPos)mutablePos)) continue;
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, placementState);
                }
            });
        }
    }

    private void placeLeafPile(WorldGenLevel level, RandomSource random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, int tries, ForestType type) {
        int chunkX = chunkBlockPos.getX();
        int chunkZ = chunkBlockPos.getZ();
        mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR, mutablePos.getX(), mutablePos.getZ()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos, type, level);
        if (entry != null) {
            entry.fallenLeaves().ifPresent(placementState -> {
                for (int i = 0; i < tries; ++i) {
                    mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
                    mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR, mutablePos.getX(), mutablePos.getZ()));
                    BlockPos origin = mutablePos.immutable();
                    for (int j = 0; j < 8; ++j) {
                        mutablePos.setWithOffset((Vec3i)origin, Mth.nextInt((RandomSource)random, (int)-2, (int)2), 0, Mth.nextInt((RandomSource)random, (int)-2, (int)2));
                        if (!level.getFluidState((BlockPos)mutablePos).isEmpty() || !EnvironmentHelpers.isOnSturdyFace(level, (BlockPos)mutablePos) || !EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)mutablePos)) continue;
                        placementState = (BlockState)placementState.setValue((Property)FallenLeavesBlock.LAYERS, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)1, (int)5)));
                        level.setBlock((BlockPos)mutablePos, placementState, 3);
                    }
                }
            });
        }
    }

    private void placeFallenTree(WorldGenLevel level, RandomSource random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, ForestType type) {
        BlockState log;
        int fallChance;
        ForestConfig.Entry entry;
        int chunkX = chunkBlockPos.getX();
        int chunkZ = chunkBlockPos.getZ();
        mutablePos.set(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR, mutablePos.getX(), mutablePos.getZ()));
        mutablePos.move(Direction.DOWN);
        BlockState downState = level.getBlockState((BlockPos)mutablePos);
        mutablePos.move(Direction.UP);
        if ((Helpers.isBlock(downState, TFCTags.Blocks.BUSH_PLANTABLE_ON) || Helpers.isBlock(downState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) && (entry = this.getTree(data, random, config, (BlockPos)mutablePos, type, level)) != null && (fallChance = entry.fallenChance()) > 0 && level.getRandom().nextInt(fallChance) == 0 && (log = (BlockState)entry.fallenLog().orElse(null)) != null) {
            int left;
            BlockState replaceState;
            int valid;
            Direction axis = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            log = Helpers.setProperty(log, TFCBlockStateProperties.NATURAL, false);
            log = Helpers.setProperty(log, BlockStateProperties.AXIS, axis.getAxis());
            int length = 4 + random.nextInt(10);
            BlockPos start = mutablePos.immutable();
            boolean[] moment = new boolean[length];
            mutablePos.set((Vec3i)start);
            for (valid = 0; valid < length && (EnvironmentHelpers.isWorldgenReplaceable(replaceState = level.getBlockState((BlockPos)mutablePos)) || replaceState.getBlock() instanceof ILeavesBlock); ++valid) {
                mutablePos.move(Direction.DOWN);
                moment[valid] = level.getBlockState((BlockPos)mutablePos).isFaceSturdy((BlockGetter)level, (BlockPos)mutablePos, Direction.UP);
                mutablePos.move(Direction.UP);
                mutablePos.move(axis);
            }
            int right = valid - 1;
            for (left = 0; left < moment.length && !moment[left]; ++left) {
            }
            while (right >= 0 && !moment[right]) {
                --right;
            }
            if (left <= valid / 2 && right >= valid / 2 && valid >= 3) {
                mutablePos.set((Vec3i)start);
                for (int i = 0; i < length; ++i) {
                    level.setBlock((BlockPos)mutablePos, log, 2);
                    mutablePos.move(axis);
                }
            }
        }
    }

    private void placeSoilDisc(WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos.MutableBlockPos mutablePos, ForestConfig.Entry entry) {
        mutablePos.move(random.nextInt(4) - 2, 0, random.nextInt(4) - 2);
        mutablePos.setY(level.getHeight(Heightmap.Types.OCEAN_FLOOR, mutablePos.getX(), mutablePos.getZ()));
        if (entry.soilDiscFeature().isPresent()) {
            ((ConfiguredFeature)entry.soilDiscFeature().get().value()).place(level, generator, random, (BlockPos)mutablePos);
        }
    }

    @Nullable
    private ForestConfig.Entry getTree(ChunkData chunkData, RandomSource random, ForestConfig config, BlockPos pos, ForestType type, WorldGenLevel level) {
        int index;
        float rainVariance = chunkData.getRainVariance(pos) * (SolarCalculator.getInNorthernHemisphere(pos, (Level)level.getLevel()) ? 1.0f : -1.0f);
        float groundwater = chunkData.getGroundwater(pos);
        int elevation = pos.getY();
        float averageTemperature = EnvironmentHelpers.adjustAvgTempForElev(elevation, chunkData.getAverageSeaLevelTemp(pos));
        List entries = config.entries().stream().map(configuredFeature -> ((ConfiguredFeature)configuredFeature.value()).config()).map(cfg -> (ForestConfig.Entry)cfg).filter(entry -> entry.isValid(averageTemperature, groundwater, rainVariance, elevation)).sorted(Comparator.comparingDouble(entry -> entry.distanceFromMean(averageTemperature, groundwater, rainVariance, elevation))).collect(Collectors.toList());
        if (entries.isEmpty()) {
            return null;
        }
        if (entries.size() == 1) {
            return (ForestConfig.Entry)entries.getFirst();
        }
        int maxSize = type.getMaxTreeTypes();
        int originalSize = entries.size();
        for (int i = maxSize; i < originalSize; ++i) {
            entries.removeLast();
        }
        for (int alternate = type.getAlternateSize(); entries.size() > 1 && alternate > 0; --alternate) {
            entries.remove(0);
        }
        for (index = 0; index < entries.size() - 1 && random.nextFloat() < 0.6f; ++index) {
        }
        return (ForestConfig.Entry)entries.get(index);
    }

    public static class Entry
    extends Feature<ForestConfig.Entry> {
        public Entry(Codec<ForestConfig.Entry> codec) {
            super(codec);
        }

        public boolean place(FeaturePlaceContext<ForestConfig.Entry> context) {
            throw new IllegalArgumentException("This is not a real feature and should never be placed!");
        }
    }
}

