/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.density.TFCDensityFunctions;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class NoiseSampler {
    public final DensityFunction noiseCaves;
    public final DensityFunction noodleToggle;
    public final DensityFunction noodleThickness;
    public final DensityFunction noodleRidgeA;
    public final DensityFunction noodleRidgeB;
    public final NormalNoise barrierNoise;
    public final PositionalRandomFactory positionalRandomFactory;

    public NoiseSampler(long seed, HolderGetter<NormalNoise.NoiseParameters> parameters, HolderGetter<DensityFunction> functions) {
        this.positionalRandomFactory = new XoroshiroRandomSource(seed).forkPositional();
        this.noiseCaves = this.create(functions, TFCDensityFunctions.NOISE_CAVES);
        this.noodleToggle = this.create(functions, TFCDensityFunctions.NOODLE_TOGGLE);
        this.noodleThickness = this.create(functions, TFCDensityFunctions.NOODLE_THICKNESS);
        this.noodleRidgeA = this.create(functions, TFCDensityFunctions.NOODLE_RIDGE_A);
        this.noodleRidgeB = this.create(functions, TFCDensityFunctions.NOODLE_RIDGE_B);
        this.barrierNoise = Noises.instantiate(parameters, (PositionalRandomFactory)this.positionalRandomFactory, (ResourceKey)Noises.AQUIFER_BARRIER);
    }

    private DensityFunction create(HolderGetter<DensityFunction> functions, ResourceKey<DensityFunction> key) {
        return ((DensityFunction)functions.getOrThrow(key).value()).mapAll((DensityFunction.Visitor)new NoiseWiringVisitor());
    }

    class NoiseWiringVisitor
    implements DensityFunction.Visitor {
        NoiseWiringVisitor() {
        }

        public DensityFunction apply(DensityFunction f) {
            return f;
        }

        public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder holder) {
            NormalNoise noise = NormalNoise.create((RandomSource)NoiseSampler.this.positionalRandomFactory.fromHashOf(((ResourceKey)holder.noiseData().unwrapKey().orElseThrow()).location()), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)holder.noiseData().value()));
            return new DensityFunction.NoiseHolder(holder.noiseData(), noise);
        }
    }
}

