/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class BoundedCarvingMaskPlacement
extends PlacementModifier {
    public static final MapCodec<BoundedCarvingMaskPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VerticalAnchor.CODEC.optionalFieldOf("min_y", (Object)VerticalAnchor.bottom()).forGetter(c -> c.minY), (App)VerticalAnchor.CODEC.optionalFieldOf("max_y", (Object)VerticalAnchor.top()).forGetter(c -> c.maxY), (App)GenerationStep.Carving.CODEC.fieldOf("step").forGetter(c -> c.step)).apply((Applicative)instance, BoundedCarvingMaskPlacement::new));
    private final VerticalAnchor minY;
    private final VerticalAnchor maxY;
    private final GenerationStep.Carving step;

    public BoundedCarvingMaskPlacement(VerticalAnchor minY, VerticalAnchor maxY, GenerationStep.Carving step) {
        this.minY = minY;
        this.maxY = maxY;
        this.step = step;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFCPlacements.CARVING_MASK.get();
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CarvingMask carvingMask = context.getCarvingMask(chunkPos, this.step);
        int minY = this.minY.resolveY((WorldGenerationContext)context);
        int maxY = this.maxY.resolveY((WorldGenerationContext)context);
        return carvingMask.stream(chunkPos).filter(p -> p.getY() >= minY && p.getY() <= maxY);
    }
}

