/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ClimatePlacement
extends PlacementModifier {
    public static final MapCodec<ClimatePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("min_temperature", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(c -> Float.valueOf(c.minTemp)), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(c -> Float.valueOf(c.maxTemp)), (App)Codec.FLOAT.optionalFieldOf("min_groundwater", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(c -> Float.valueOf(c.minGroundwater)), (App)Codec.FLOAT.optionalFieldOf("max_groundwater", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(c -> Float.valueOf(c.maxGroundwater)), (App)Codec.FLOAT.optionalFieldOf("min_rain_variance", (Object)Float.valueOf(-1.0f)).forGetter(c -> Float.valueOf(c.minRainVariance)), (App)Codec.FLOAT.optionalFieldOf("max_rain_variance", (Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.maxRainVariance)), (App)Codec.BOOL.optionalFieldOf("rain_variance_absolute", (Object)false).forGetter(c -> c.rainVarianceAbsolute), (App)Codecs.NON_NEGATIVE_INT.optionalFieldOf("min_forest", (Object)0).forGetter(c -> c.minForest), (App)Codecs.NON_NEGATIVE_INT.optionalFieldOf("max_forest", (Object)4).forGetter(c -> c.maxForest), (App)ForestType.CODEC.listOf().optionalFieldOf("forest_types", Collections.emptyList()).forGetter(c -> c.types), (App)Codec.INT.optionalFieldOf("min_elevation", (Object)-64).forGetter(c -> c.minElevation), (App)Codec.INT.optionalFieldOf("max_elevation", (Object)320).forGetter(c -> c.maxElevation), (App)Codec.BOOL.optionalFieldOf("fuzzy", (Object)false).forGetter(c -> c.fuzzy), (App)Codec.BOOL.optionalFieldOf("ignore_rivers", (Object)false).forGetter(c -> c.ignoreRivers)).apply((Applicative)instance, ClimatePlacement::new));
    private final float minTemp;
    private final float maxTemp;
    private final List<ForestType> types;
    private final float targetTemp;
    private final float minGroundwater;
    private final float maxGroundwater;
    private final float targetGroundwater;
    private final float minRainVariance;
    private final float maxRainVariance;
    private final boolean rainVarianceAbsolute;
    private final float targetRainVariance;
    private final int minForest;
    private final int maxForest;
    private final int minElevation;
    private final int maxElevation;
    private final boolean fuzzy;
    private final boolean ignoreRivers;

    public ClimatePlacement(float minTemp, float maxTemp, float minGroundwater, float maxGroundwater, float minRainVariance, float maxRainVariance, boolean rainVarianceAbsolute, int minForest, int maxForest, List<ForestType> types, int minElevation, int maxElevation, boolean fuzzy, boolean ignoreRivers) {
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.types = types;
        this.targetTemp = (minTemp + maxTemp) / 2.0f;
        this.minGroundwater = minGroundwater;
        this.maxGroundwater = maxGroundwater;
        this.targetGroundwater = (minGroundwater + maxGroundwater) / 2.0f;
        this.minRainVariance = minRainVariance;
        this.maxRainVariance = maxRainVariance;
        this.targetRainVariance = (minRainVariance + maxRainVariance) / 2.0f;
        this.rainVarianceAbsolute = rainVarianceAbsolute;
        this.minForest = minForest;
        this.maxForest = maxForest;
        this.minElevation = minElevation;
        this.maxElevation = maxElevation;
        this.fuzzy = fuzzy;
        this.ignoreRivers = ignoreRivers;
    }

    public float getMinTemp() {
        return this.minTemp;
    }

    public float getMaxTemp() {
        return this.maxTemp;
    }

    public float getMinGroundwater() {
        return this.minGroundwater;
    }

    public float getMaxGroundwater() {
        return this.maxGroundwater;
    }

    public float getMinRainVariance() {
        return this.minRainVariance;
    }

    public float getMaxRainVariance() {
        return this.maxRainVariance;
    }

    public boolean isRainVarianceAbsolute() {
        return this.rainVarianceAbsolute;
    }

    public boolean ignoresRivers() {
        return this.ignoreRivers;
    }

    public int getMinForest() {
        return this.minForest;
    }

    public int getMaxForest() {
        return this.maxForest;
    }

    public int getMinElevation() {
        return this.minElevation;
    }

    public int getMaxElevation() {
        return this.maxElevation;
    }

    public List<ForestType> getTypes() {
        return this.types;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFCPlacements.CLIMATE.get();
    }

    public boolean isValidNonHemispheral(ChunkData data, BlockPos pos, RandomSource random) {
        return this.isValid(data, pos, random, true);
    }

    public boolean isValid(ChunkData data, BlockPos pos, RandomSource random, boolean useNorthHemisphereRainVar) {
        float rainVar = this.rainVarianceAbsolute ? Math.abs(data.getRainVariance(pos)) : data.getRainVariance(pos) * (useNorthHemisphereRainVar ? 1.0f : -1.0f);
        int y = pos.getY();
        float temperature = EnvironmentHelpers.adjustAvgTempForElev(y, data.getAverageSeaLevelTemp(pos));
        float groundwater = this.ignoreRivers ? data.getRainfall(pos) : data.getGroundwater(pos);
        ForestType forestType = data.getForestType();
        if (y >= this.minElevation && y <= this.maxElevation && this.minTemp <= temperature && temperature <= this.maxTemp && this.minGroundwater <= groundwater && groundwater <= this.maxGroundwater && this.minRainVariance <= rainVar && this.maxRainVariance >= rainVar && this.minForest <= forestType.getDensity() && forestType.getDensity() <= this.maxForest && (this.types.contains((Object)forestType) || this.types.isEmpty())) {
            if (this.fuzzy) {
                float normTempDelta = Math.abs(temperature - this.targetTemp) / (this.maxTemp - this.minTemp);
                float normGroundwaterDelta = Math.abs(groundwater - this.targetGroundwater) / (this.maxGroundwater - this.minGroundwater);
                float normRainVarDelta = Math.abs(rainVar - this.targetRainVariance) / (this.maxRainVariance - this.minRainVariance);
                return random.nextFloat() * random.nextFloat() > Math.max(normTempDelta, Math.max(normGroundwaterDelta, normRainVarDelta));
            }
            return true;
        }
        return false;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        WorldGenLevel level = context.getLevel();
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        if (this.isValid(data, pos, random, SolarCalculator.getInNorthernHemisphere(pos, (Level)level.getLevel()))) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }
}

