/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class NearFluidPlacement
extends PlacementModifier {
    public static final MapCodec<NearFluidPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("radius", (Object)2).forGetter(c -> c.radius), (App)Codecs.FLUID.listOf().optionalFieldOf("fluids", null).forGetter(c -> c.fluids)).apply((Applicative)instance, NearFluidPlacement::new));
    private final int radius;
    @Nullable
    private final List<Fluid> fluids;

    public NearFluidPlacement(int radius, @Nullable List<Fluid> fluids) {
        this.radius = radius;
        this.fluids = fluids;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TFCPlacements.NEAR_FLUID.get();
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                for (int y = 0; y >= -this.radius; --y) {
                    mutablePos.set((Vec3i)pos).move(x, y, z);
                    FluidState state = context.getBlockState((BlockPos)mutablePos).getFluidState();
                    if (!(this.fluids == null ? !state.isEmpty() : this.fluids.contains(state.getType()))) continue;
                    return Stream.of(pos);
                }
            }
        }
        return Stream.empty();
    }
}

