/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.world.placement.BiomePlacement;
import net.dries007.tfc.world.placement.BoundedCarvingMaskPlacement;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.dries007.tfc.world.placement.FlatEnoughPlacement;
import net.dries007.tfc.world.placement.IntertidalPlacement;
import net.dries007.tfc.world.placement.NearFluidPlacement;
import net.dries007.tfc.world.placement.NoSolidNeighborsPlacement;
import net.dries007.tfc.world.placement.OnTopPlacement;
import net.dries007.tfc.world.placement.ShallowWaterPlacement;
import net.dries007.tfc.world.placement.TuffRingPlacement;
import net.dries007.tfc.world.placement.TuyaPlacement;
import net.dries007.tfc.world.placement.UndergroundPlacement;
import net.dries007.tfc.world.placement.VolcanoPlacement;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCPlacements {
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registries.PLACEMENT_MODIFIER_TYPE, (String)"tfc");
    public static final Id<FlatEnoughPlacement> FLAT_ENOUGH = TFCPlacements.register("flat_enough", () -> FlatEnoughPlacement.CODEC);
    public static final Id<UndergroundPlacement> UNDERGROUND = TFCPlacements.register("underground", () -> UndergroundPlacement.CODEC);
    public static final Id<BoundedCarvingMaskPlacement> CARVING_MASK = TFCPlacements.register("carving_mask", () -> BoundedCarvingMaskPlacement.CODEC);
    public static final Id<ClimatePlacement> CLIMATE = TFCPlacements.register("climate", () -> ClimatePlacement.CODEC);
    public static final Id<IntertidalPlacement> INTERTIDAL = TFCPlacements.register("intertidal", () -> IntertidalPlacement.CODEC);
    public static final Id<VolcanoPlacement> VOLCANO = TFCPlacements.register("volcano", () -> VolcanoPlacement.CODEC);
    public static final Id<TuffRingPlacement> TUFF_RING = TFCPlacements.register("tuff_cone", () -> TuffRingPlacement.CODEC);
    public static final Id<TuyaPlacement> TUYA = TFCPlacements.register("tuya", () -> TuyaPlacement.CODEC);
    public static final Id<NearFluidPlacement> NEAR_FLUID = TFCPlacements.register("near_fluid", () -> NearFluidPlacement.CODEC);
    public static final Id<ShallowWaterPlacement> SHALLOW_WATER = TFCPlacements.register("shallow_water", () -> ShallowWaterPlacement.CODEC);
    public static final Id<OnTopPlacement> ON_TOP = TFCPlacements.register("on_top", () -> OnTopPlacement.CODEC);
    public static final Id<BiomePlacement> BIOME = TFCPlacements.register("biome", () -> BiomePlacement.CODEC);
    public static final Id<NoSolidNeighborsPlacement> NO_SOLID_NEIGHBORS = TFCPlacements.register("no_solid_neighbors", () -> NoSolidNeighborsPlacement.CODEC);

    private static <C extends PlacementModifier> Id<C> register(String name, PlacementModifierType<C> codec) {
        return new Id(PLACEMENT_MODIFIERS.register(name, () -> codec));
    }

    public record Id<T extends PlacementModifier>(DeferredHolder<PlacementModifierType<?>, PlacementModifierType<T>> holder) implements RegistryHolder<PlacementModifierType<?>, PlacementModifierType<T>>
    {
    }
}

