/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public enum AddMountains implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        RandomSource random = context.random;
        int placed = 0;
        for (int attempt = 0; attempt < 40 && placed < 3; ++attempt) {
            IntSet range;
            @Nullable Region.Point origin = region.random(random);
            if (origin == null || !origin.land() || origin.baseLandHeight > 1 && (origin.baseLandHeight < 4 || origin.baseLandHeight > 11) || (range = this.placeRange(region, random, origin.index)).size() <= 45) continue;
            range.forEach(index -> {
                Region.Point point = region.atIndex(index);
                point.setMountain();
                if (origin.baseLandHeight <= 2) {
                    point.setCoastalMountain();
                }
            });
            ++placed;
        }
    }

    private IntSet placeRange(Region region, RandomSource random, int originIndex) {
        BitSet explored = new BitSet(region.size());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        IntOpenHashSet range = new IntOpenHashSet();
        queue.enqueue(originIndex);
        explored.set(originIndex);
        range.add(originIndex);
        int originBaseLandHeight = Math.max(1, region.atIndex((int)originIndex).baseLandHeight);
        int maxSize = 70 + random.nextInt(40);
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.atIndex(last);
            if (range.size() > maxSize) break;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    @Nullable Region.Point point = region.atOffset(last, dx, dz);
                    if (point == null || !point.land() || point.baseLandHeight < originBaseLandHeight - 1 || point.baseLandHeight > originBaseLandHeight + 1 || point.baseLandHeight <= 2 && point.distanceToOcean >= 3 || explored.get(point.index)) continue;
                    if (lastPoint.baseLandHeight != point.baseLandHeight) {
                        queue.enqueue(point.index);
                    } else {
                        queue.enqueueFirst(point.index);
                    }
                    range.add(point.index);
                    explored.set(point.index);
                }
            }
        }
        return range;
    }
}

