/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum ChooseBiomes implements RegionTask
{
    INSTANCE;

    private static final int[] MOUNTAIN_ALTITUDE_BIOMES;
    private static final int[] OCEANIC_MOUNTAIN_ALTITUDE_BIOMES;
    private static final int[][] ALTITUDE_BIOMES;
    private static final int[][] ICE_SHEET_ALTITUDE_BIOMES;
    private static final int[][] PALEO_ICE_SHEET_ALTITUDE_BIOMES;
    private static final int[][] DESERT_ALTITUDE_BIOMES;
    private static final int[][] SEMI_ARID_ALTITUDE_BIOMES;
    private static final int[] KNOB_AND_KETTLE_BIOMES;
    private static final int[] ISLAND_BIOMES;
    private static final int[] MID_DEPTH_OCEAN_BIOMES;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        Area blobArea = context.generator().biomeArea.get();
        long rngSeed = context.random.nextLong();
        long climateSeed = context.random.nextLong();
        for (Region.Point point : region.points()) {
            int biome;
            float maxRainfallForBadlands;
            int areaSeed = blobArea.get(point.x, point.z);
            if (point.island()) {
                point.biome = this.randomSeededFrom(rngSeed, areaSeed, ISLAND_BIOMES);
            } else if (point.mountain()) {
                float temp = point.temperature;
                point.biome = point.coastalMountain() ? (temp < (maxIceSheetTemp = -16.0f + 0.006f * point.rainfall) + 2.0f ? TFCLayers.ICE_SHEET_OCEANIC_MOUNTAINS : (temp < maxIceSheetTemp + 6.0f ? TFCLayers.GLACIATED_OCEANIC_MOUNTAINS : (temp < maxIceSheetTemp + 10.0f ? TFCLayers.GLACIALLY_CARVED_OCEANIC_MOUNTAINS : this.randomSeededFrom(rngSeed, areaSeed, OCEANIC_MOUNTAIN_ALTITUDE_BIOMES)))) : (temp < (maxIceSheetTemp = -14.0f + 0.006f * point.rainfall) ? TFCLayers.ICE_SHEET_MOUNTAINS : (temp < maxIceSheetTemp + 4.0f ? TFCLayers.GLACIATED_MOUNTAINS : (temp < maxIceSheetTemp + 10.0f ? TFCLayers.GLACIALLY_CARVED_MOUNTAINS : this.randomSeededFrom(rngSeed, areaSeed, MOUNTAIN_ALTITUDE_BIOMES))));
            } else if (point.land()) {
                float temp = point.temperature;
                float rain = point.rainfall;
                maxIceSheetTemp = -17.0f + 0.006f * rain;
                if (temp < maxIceSheetTemp) {
                    int biome2 = this.randomSeededFrom(rngSeed, areaSeed, ICE_SHEET_ALTITUDE_BIOMES[point.discreteBiomeAltitude()]);
                    if (point.distanceToOcean < 3 && TFCLayers.isFlatIceSheet(biome2)) {
                        biome2 = TFCLayers.ICE_SHEET_OCEANIC;
                    }
                    point.biome = biome2;
                } else {
                    point.biome = temp < maxIceSheetTemp + 1.0f ? TFCLayers.ICE_SHEET_EDGE : ((double)temp < (double)maxIceSheetTemp + 2.5 ? this.randomSeededFrom(rngSeed, areaSeed, KNOB_AND_KETTLE_BIOMES) : (temp < maxIceSheetTemp + 6.0f ? this.randomSeededFrom(rngSeed, areaSeed, PALEO_ICE_SHEET_ALTITUDE_BIOMES[point.discreteBiomeAltitude()]) : (rain < 60.0f ? this.randomSeededFrom(rngSeed, areaSeed, DESERT_ALTITUDE_BIOMES[point.discreteBiomeAltitude()]) : (rain < 155.0f ? this.randomSeededFrom(rngSeed, areaSeed, SEMI_ARID_ALTITUDE_BIOMES[point.discreteBiomeAltitude()]) : this.randomSeededFrom(rngSeed, areaSeed, ALTITUDE_BIOMES[point.discreteBiomeAltitude()])))));
                }
            } else {
                point.biome = point.baseOceanDepth < 3 ? TFCLayers.OCEAN : (point.baseOceanDepth > 9 ? TFCLayers.DEEP_OCEAN_TRENCH : (point.baseOceanDepth >= 5 || point.distanceToEdge < 2 ? TFCLayers.DEEP_OCEAN : this.randomSeededFrom(rngSeed, areaSeed, MID_DEPTH_OCEAN_BIOMES)));
            }
            byte age = point.hotSpotAge;
            if (age > 0) {
                point.biome = age == 4 && point.biome == TFCLayers.OCEAN || point.biome == TFCLayers.DEEP_OCEAN || point.biome == TFCLayers.OCEAN_REEF || point.biome == TFCLayers.DEEP_OCEAN_TRENCH ? TFCLayers.SUNKEN_SHIELD_VOLCANO : this.getHotSpotBiome(point.hotSpotAge);
            }
            float minRainForLowFreshWaterBiomes = 90.0f + (float)Math.floorMod((long)areaSeed ^ climateSeed, 40);
            float rainfall = point.rainfall;
            float temperature = point.temperature;
            if (rainfall < minRainForLowFreshWaterBiomes && rainfall <= 55.0f) {
                if (point.biome == TFCLayers.LOWLANDS || point.biome == TFCLayers.LOW_CANYONS) {
                    point.biome = TFCLayers.SALT_FLATS;
                } else if (point.biome == TFCLayers.HILLS || point.biome == TFCLayers.ROLLING_HILLS || point.biome == TFCLayers.PLATEAU) {
                    point.biome = TFCLayers.DUNE_SEA;
                }
            }
            if (rainfall < 145.0f && (point.biome == TFCLayers.PATTERNED_GROUND || point.biome == TFCLayers.INVERTED_PATTERNED_GROUND)) {
                point.biome = TFCLayers.STONE_CIRCLES;
            }
            if (rainfall > (maxRainfallForBadlands = 420.0f + (float)Math.floorMod((long)areaSeed ^ climateSeed, 40)) && point.biome == TFCLayers.BADLANDS) {
                point.biome = TFCLayers.HIGHLANDS;
            }
            float maxIceSheetTemp = -14.0f + 0.006f * rainfall;
            if (point.land() && temperature < maxIceSheetTemp) {
                biome = point.biome;
                if (biome == TFCLayers.ACTIVE_SHIELD_VOLCANO || biome == TFCLayers.DORMANT_SHIELD_VOLCANO || biome == TFCLayers.EXTINCT_SHIELD_VOLCANO) {
                    point.biome = TFCLayers.ICE_SHEET_SHIELD_VOLCANO;
                }
            } else if (temperature < maxIceSheetTemp + 4.0f && ((biome = point.biome) == TFCLayers.ACTIVE_SHIELD_VOLCANO || biome == TFCLayers.DORMANT_SHIELD_VOLCANO || biome == TFCLayers.EXTINCT_SHIELD_VOLCANO)) {
                point.biome = TFCLayers.GLACIATED_SHIELD_VOLCANO;
            }
            if (point.isSurfaceRockKarst) {
                if (rainfall > 375.0f) {
                    point.biome = rainfall > 425.0f && rainfall + 10.0f * temperature > 500.0f ? this.getTowerKarstBiome(point.biome) : (temperature > 9.0f ? this.getShilinBiome(point.biome) : (temperature < 0.0f ? this.getBurrenBiome(point.biome) : this.getDolineBiome(point.biome)));
                } else if (rainfall > 250.0f) {
                    point.biome = temperature > 5.0f ? this.getCenoteBiome(point.biome) : this.getDolineBiome(point.biome);
                }
            }
            if (point.distanceToOcean > 2 || point.biome != TFCLayers.LOWLANDS || !(point.rainfall > 220.0f) || !(point.temperature > 18.0f)) continue;
            point.biome = TFCLayers.SALT_MARSH;
        }
    }

    private int getHotSpotBiome(int age) {
        if (age == 4) {
            return TFCLayers.ANCIENT_SHIELD_VOLCANO;
        }
        if (age == 3) {
            return TFCLayers.EXTINCT_SHIELD_VOLCANO;
        }
        if (age == 2) {
            return TFCLayers.DORMANT_SHIELD_VOLCANO;
        }
        if (age == 1) {
            return TFCLayers.ACTIVE_SHIELD_VOLCANO;
        }
        return TFCLayers.PLAINS;
    }

    private int getTowerKarstBiome(int biome) {
        if (biome == TFCLayers.SALT_MARSH) {
            return TFCLayers.TOWER_KARST_BAY;
        }
        if (biome == TFCLayers.LOWLANDS) {
            return TFCLayers.TOWER_KARST_LAKE;
        }
        if (biome == TFCLayers.PLAINS || biome == TFCLayers.LOW_CANYONS) {
            return TFCLayers.TOWER_KARST_PLAINS;
        }
        if (biome == TFCLayers.CANYONS) {
            return TFCLayers.TOWER_KARST_CANYONS;
        }
        if (biome == TFCLayers.HILLS || biome == TFCLayers.ROLLING_HILLS || biome == TFCLayers.BADLANDS) {
            return TFCLayers.TOWER_KARST_HILLS;
        }
        if (biome == TFCLayers.HIGHLANDS) {
            return TFCLayers.TOWER_KARST_HIGHLANDS;
        }
        if (biome == TFCLayers.PLATEAU || biome == TFCLayers.PLATEAU_WIDE) {
            return TFCLayers.EXTREME_DOLINE_PLATEAU;
        }
        if (biome == TFCLayers.OLD_MOUNTAINS || biome == TFCLayers.MOUNTAINS || biome == TFCLayers.OCEANIC_MOUNTAINS) {
            return TFCLayers.EXTREME_DOLINE_MOUNTAINS;
        }
        return biome;
    }

    private int getShilinBiome(int biome) {
        if (biome == TFCLayers.PLAINS) {
            return TFCLayers.SHILIN_PLAINS;
        }
        if (biome == TFCLayers.CANYONS) {
            return TFCLayers.SHILIN_CANYONS;
        }
        if (biome == TFCLayers.ROLLING_HILLS || biome == TFCLayers.BADLANDS) {
            return TFCLayers.SHILIN_HILLS;
        }
        if (biome == TFCLayers.PLATEAU || biome == TFCLayers.PLATEAU_WIDE) {
            return TFCLayers.SHILIN_PLATEAU;
        }
        if (biome == TFCLayers.HIGHLANDS) {
            return TFCLayers.SHILIN_HIGHLANDS;
        }
        return biome;
    }

    private int getBurrenBiome(int biome) {
        if (biome == TFCLayers.PLAINS || biome == TFCLayers.CANYONS) {
            return TFCLayers.BURREN_PLAINS;
        }
        if (biome == TFCLayers.BADLANDS || biome == TFCLayers.HILLS || biome == TFCLayers.ROLLING_HILLS) {
            return TFCLayers.BURREN_BADLANDS;
        }
        if (biome == TFCLayers.DRUMLINS) {
            return TFCLayers.BURREN_ROCHE_MOUTONEE;
        }
        if (biome == TFCLayers.HIGHLANDS) {
            return TFCLayers.BURREN_BADLANDS_TALL;
        }
        if (biome == TFCLayers.PLATEAU || biome == TFCLayers.PLATEAU_WIDE) {
            return TFCLayers.BURREN_PLATEAU;
        }
        return biome;
    }

    private int getDolineBiome(int biome) {
        if (biome == TFCLayers.CANYONS) {
            return TFCLayers.DOLINE_CANYONS;
        }
        if (biome == TFCLayers.PLAINS || biome == TFCLayers.LOW_CANYONS) {
            return TFCLayers.DOLINE_PLAINS;
        }
        if (biome == TFCLayers.HILLS) {
            return TFCLayers.DOLINE_HILLS;
        }
        if (biome == TFCLayers.ROLLING_HILLS) {
            return TFCLayers.DOLINE_ROLLING_HILLS;
        }
        if (biome == TFCLayers.HIGHLANDS) {
            return TFCLayers.DOLINE_HIGHLANDS;
        }
        if (biome == TFCLayers.PLATEAU || biome == TFCLayers.PLATEAU_WIDE) {
            return TFCLayers.DOLINE_PLATEAU;
        }
        return biome;
    }

    private int getCenoteBiome(int biome) {
        if (biome == TFCLayers.CANYONS) {
            return TFCLayers.CENOTE_CANYONS;
        }
        if (biome == TFCLayers.PLAINS || biome == TFCLayers.LOW_CANYONS) {
            return TFCLayers.CENOTE_PLAINS;
        }
        if (biome == TFCLayers.HILLS) {
            return TFCLayers.CENOTE_HILLS;
        }
        if (biome == TFCLayers.ROLLING_HILLS) {
            return TFCLayers.CENOTE_ROLLING_HILLS;
        }
        if (biome == TFCLayers.HIGHLANDS) {
            return TFCLayers.CENOTE_HIGHLANDS;
        }
        if (biome == TFCLayers.PLATEAU || biome == TFCLayers.PLATEAU_WIDE) {
            return TFCLayers.CENOTE_PLATEAU;
        }
        return biome;
    }

    private int randomSeededFrom(long rngSeed, int areaSeed, int[] choices) {
        return choices[Math.floorMod(rngSeed ^ (long)areaSeed, choices.length)];
    }

    static {
        MOUNTAIN_ALTITUDE_BIOMES = new int[]{TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.PLATEAU, TFCLayers.HIGHLANDS};
        OCEANIC_MOUNTAIN_ALTITUDE_BIOMES = new int[]{TFCLayers.VOLCANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.OCEANIC_MOUNTAINS, TFCLayers.OCEANIC_MOUNTAINS, TFCLayers.ROLLING_HILLS};
        ALTITUDE_BIOMES = new int[][]{{TFCLayers.PLAINS, TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS, TFCLayers.LOWLANDS}, {TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.HIGHLANDS, TFCLayers.BUTTES, TFCLayers.MESAS, TFCLayers.BADLANDS, TFCLayers.PLATEAU_WIDE, TFCLayers.CANYONS, TFCLayers.CANYONS, TFCLayers.LOW_CANYONS}, {TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.BADLANDS, TFCLayers.BADLANDS, TFCLayers.STAIR_STEP_CANYONS, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.PLATEAU_WIDE, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS}};
        ICE_SHEET_ALTITUDE_BIOMES = new int[][]{{TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET_TUYAS}, {TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET_TUYAS, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET_TUYAS}, {TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET, TFCLayers.ICE_SHEET_TUYAS, TFCLayers.ICE_SHEET_TUYAS, TFCLayers.ICE_SHEET_MOUNTAINS, TFCLayers.ICE_SHEET_MOUNTAINS}};
        PALEO_ICE_SHEET_ALTITUDE_BIOMES = new int[][]{{TFCLayers.PATTERNED_GROUND, TFCLayers.INVERTED_PATTERNED_GROUND, TFCLayers.KNOB_AND_KETTLE, TFCLayers.KNOB_AND_KETTLE, TFCLayers.KNOB_AND_KETTLE, TFCLayers.DRUMLINS, TFCLayers.TUYAS, TFCLayers.LOWLANDS, TFCLayers.LOWLANDS}, {TFCLayers.PATTERNED_GROUND, TFCLayers.KNOB_AND_KETTLE, TFCLayers.DRUMLINS, TFCLayers.DRUMLINS, TFCLayers.DRUMLINS, TFCLayers.DRUMLINS, TFCLayers.TUYAS, TFCLayers.TUYAS}, {TFCLayers.DRUMLINS, TFCLayers.DRUMLINS, TFCLayers.DRUMLINS, TFCLayers.BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.PLATEAU_WIDE, TFCLayers.ICE_SHEET_MOUNTAINS}};
        DESERT_ALTITUDE_BIOMES = new int[][]{{TFCLayers.BUTTES, TFCLayers.GRASSY_DUNES, TFCLayers.DUNE_SEA, TFCLayers.DUNE_SEA, TFCLayers.DUNE_SEA, TFCLayers.SALT_FLATS, TFCLayers.SALT_FLATS}, {TFCLayers.DUNE_SEA, TFCLayers.BUTTES, TFCLayers.BUTTES, TFCLayers.HOODOOS, TFCLayers.MESAS, TFCLayers.MESAS, TFCLayers.STAIR_STEP_CANYONS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.CANYONS, TFCLayers.WHORLED_CANYONS}, {TFCLayers.HOODOOS, TFCLayers.MESAS, TFCLayers.STAIR_STEP_CANYONS, TFCLayers.STAIR_STEP_CANYONS, TFCLayers.ROCKY_PLATEAU, TFCLayers.ROCKY_PLATEAU, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.WHORLED_CANYONS}};
        SEMI_ARID_ALTITUDE_BIOMES = new int[][]{{TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.HILLS, TFCLayers.GRASSY_DUNES, TFCLayers.GRASSY_DUNES, TFCLayers.GRASSY_DUNES, TFCLayers.GRASSY_DUNES, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS, TFCLayers.LOWLANDS, TFCLayers.MUD_FLATS}, {TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU_WIDE, TFCLayers.CANYONS, TFCLayers.LOW_CANYONS, TFCLayers.WHORLED_CANYONS, TFCLayers.BUTTES, TFCLayers.MESAS, TFCLayers.MESAS, TFCLayers.HOODOOS}, {TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.MESAS, TFCLayers.HOODOOS, TFCLayers.ROLLING_HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU_WIDE, TFCLayers.ROCKY_PLATEAU, TFCLayers.STAIR_STEP_CANYONS, TFCLayers.STAIR_STEP_CANYONS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.WHORLED_CANYONS}};
        KNOB_AND_KETTLE_BIOMES = new int[]{TFCLayers.KNOB_AND_KETTLE, TFCLayers.PATTERNED_GROUND, TFCLayers.INVERTED_PATTERNED_GROUND};
        ISLAND_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.GUANO_ISLAND};
        MID_DEPTH_OCEAN_BIOMES = new int[]{TFCLayers.DEEP_OCEAN, TFCLayers.OCEAN, TFCLayers.OCEAN, TFCLayers.OCEAN_REEF, TFCLayers.OCEAN_REEF, TFCLayers.OCEAN_REEF};
    }
}

