/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import net.minecraft.util.Mth;

public final class RiverHelpers {
    public static double distancePointToLineSq(double vx, double vy, double wx, double wy, double px, double py) {
        double t = RiverHelpers.projectAlongLine(vx, vy, wx, wy, px, py);
        double x0 = vx + t * (wx - vx);
        double y0 = vy + t * (wy - vy);
        return RiverHelpers.norm2(x0 - px, y0 - py);
    }

    public static double projectAlongLine(double vx, double vy, double wx, double wy, double px, double py) {
        double l2 = RiverHelpers.norm2(vx - wx, vy - wy);
        if (l2 == 0.0) {
            return l2;
        }
        return Mth.clamp((double)(((px - vx) * (wx - vx) + (py - vy) * (wy - vy)) / l2), (double)0.0, (double)1.0);
    }

    public static double norm2(double x, double y) {
        return x * x + y * y;
    }

    public static double normInf(double x, double y) {
        return Math.max(Math.abs(x), Math.abs(y));
    }

    public static long pack(double x, double y) {
        return RiverHelpers.pack(RiverHelpers.floor(x), RiverHelpers.floor(y));
    }

    public static long pack(int x, int y) {
        return (long)x & 0xFFFFFFFFL | (long)y << 32;
    }

    public static int unpackX(long key) {
        return (int)key;
    }

    public static int unpackZ(long key) {
        return (int)(key >> 32);
    }

    public static int floor(double f) {
        return f >= 0.0 ? (int)f : (int)f - 1;
    }
}

