/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.shore;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.Noise3D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.shore.ShoreNoiseSampler;
import net.minecraft.util.Mth;

public final class ShoreNoise {
    public static ShoreNoiseSampler sandyBeach(final Seed seed) {
        return new ShoreNoiseSampler(){
            double sandHeight;

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.sandHeight = ShoreNoise.simpleBeach(seed, x, z, heightIn, landWeight, oceanWeight);
                return this.sandHeight;
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.sandHeight) {
                    return 0.0;
                }
                return 0.7;
            }
        };
    }

    public static ShoreNoiseSampler setbackCliffs(final Seed seed) {
        return new ShoreNoiseSampler(){
            final Noise2D bankNoise;
            final Noise3D cliffNoise;
            final double cliffBaseWeight = 0.25;
            final double cliffTopWeight = 0.45;
            double bankHeight;
            double landWeight;
            int x;
            int z;
            double yTop;
            double sandHeight;
            {
                this.bankNoise = new OpenSimplex2D(seed.seed()).spread(0.03).abs().scaled(-1.0, 8.0);
                this.cliffNoise = BiomeNoise.cliffNoise(seed);
                this.cliffBaseWeight = 0.25;
                this.cliffTopWeight = 0.45;
            }

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.x = x;
                this.z = z;
                this.landWeight = landWeight;
                this.sandHeight = ShoreNoise.simpleBeachNoLandBlend(seed, x, z, heightIn, landWeight, oceanWeight);
                this.yTop = heightIn;
                double tideLevelAtOcean = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z) - 4.0;
                double shoreBankHeight = this.bankNoise.noise(x, z) + this.sandHeight;
                if (landWeight >= 0.25) {
                    this.bankHeight = shoreBankHeight;
                    return heightIn;
                }
                this.bankHeight = oceanWeight > 0.0 ? Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.25, (double)shoreBankHeight, (double)tideLevelAtOcean) : shoreBankHeight;
                this.bankHeight = Mth.clampedMap((double)(thisWeight + landWeight / 2.0), (double)0.5, (double)1.0, (double)this.sandHeight, (double)this.bankHeight);
                return this.bankHeight;
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.bankHeight) {
                    return 0.0;
                }
                if (this.landWeight >= 0.25) {
                    double percentHeight = Mth.clampedMap((double)yIn, (double)this.bankHeight, (double)this.yTop, (double)0.3, (double)1.0);
                    double percentDepth = Mth.clampedMap((double)this.landWeight, (double)0.25, (double)0.45, (double)0.0, (double)1.0);
                    double cliffNoiseValue = this.edgeFunction(percentHeight) * this.edgeFunction(percentDepth) * this.cliffNoise.noise(this.x, yIn, this.z);
                    return (percentHeight - cliffNoiseValue - percentDepth) * 3.0;
                }
                return 0.7;
            }

            public double edgeFunction(double input) {
                return Math.min(3.0 - 6.0 * Math.abs(input - 0.5), 1.0);
            }
        };
    }

    public static ShoreNoiseSampler dunes(final Seed seed) {
        return new ShoreNoiseSampler(){
            final OpenSimplex2D warpNoise;
            final Noise2D duneNoise;
            double duneHeight;
            double sandHeight;
            {
                this.warpNoise = new OpenSimplex2D(seed.seed()).scaled(-10.0, 10.0).spread(0.05);
                this.duneNoise = new OpenSimplex2D(seed.seed()).spread(0.03).abs().scaled(-2.0, 6.5).warped(this.warpNoise);
            }

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.sandHeight = ShoreNoise.simpleBeach(seed, x, z, heightIn, landWeight, oceanWeight);
                double tideLevelAtOcean = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z) - 4.0;
                double fullDuneHeight = this.duneNoise.noise(x, z) + this.sandHeight;
                this.duneHeight = oceanWeight > 0.0 ? Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.25, (double)fullDuneHeight, (double)tideLevelAtOcean) : fullDuneHeight;
                this.duneHeight = Mth.clampedMap((double)thisWeight, (double)0.5, (double)1.0, (double)this.sandHeight, (double)this.duneHeight);
                return this.duneHeight;
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.duneHeight) {
                    return Mth.clampedMap((double)yIn, (double)this.sandHeight, (double)this.duneHeight, (double)-0.5, (double)0.0);
                }
                return 1.3;
            }
        };
    }

    public static ShoreNoiseSampler embayments(final Seed seed) {
        return new ShoreNoiseSampler(){
            private final Noise2D rockShelfIntensity;
            private final Noise2D steepnessNoise;
            private final Noise2D roughnessNoise;
            private final Noise2D tidepoolNoise;
            private final Noise3D caveNoise;
            final double topShelfEdge = 0.7;
            final double midShelfEdge = 0.35;
            int x;
            int z;
            double tideLevel;
            double oceanWeight;
            double sandHeight;
            double shelfProgress;
            double height;
            double topShelfHeight;
            double midShelfHeight;
            {
                this.rockShelfIntensity = new OpenSimplex2D(seed.seed() + 5252L).octaves(3).spread(0.03).scaled(-0.8, 1.0);
                this.steepnessNoise = new OpenSimplex2D(seed.seed() + 224L).octaves(2).spread(0.11).clampedScaled(-0.7, 0.7, 0.0, 0.3);
                this.roughnessNoise = new OpenSimplex2D(seed.seed()).octaves(3).spread(0.09).scaled(-3.0, 3.0);
                this.tidepoolNoise = new OpenSimplex2D(seed.seed() + 492L).octaves(3).spread(0.09).clampedScaled(-1.0, 0.0, -5.0, 0.0);
                this.caveNoise = BiomeNoise.cliffNoise(seed).scaled(0.0, 0.12);
                this.topShelfEdge = 0.7;
                this.midShelfEdge = 0.35;
            }

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.tideLevel = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z);
                this.sandHeight = ShoreNoise.simpleBeach(this.tideLevel, heightIn, landWeight, oceanWeight);
                this.x = x;
                this.z = z;
                this.oceanWeight = oceanWeight;
                double roughness = this.roughnessNoise.noise(x, z) + this.tidepoolNoise.noise(x, z);
                this.topShelfHeight = 63.0 + roughness + 15.0;
                this.midShelfHeight = 63.0 + roughness + 9.0;
                double baseRockShelfNoise = this.rockShelfIntensity.noise(x, z);
                if (oceanWeight > 0.1) {
                    this.shelfProgress = Mth.clampedMap((double)oceanWeight, (double)0.1, (double)0.3, (double)baseRockShelfNoise, (double)(baseRockShelfNoise - oceanWeight * 3.0));
                } else {
                    double landInfluence = Mth.clampedMap((double)landWeight, (double)0.4, (double)0.0, (double)(baseRockShelfNoise + landWeight * 2.0), (double)baseRockShelfNoise);
                    this.shelfProgress = Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.1, (double)(baseRockShelfNoise + landInfluence), (double)baseRockShelfNoise);
                }
                double steepness = this.steepnessNoise.noise(x, z);
                this.height = this.shelfProgress > 0.7 + steepness ? this.topShelfHeight : (this.shelfProgress > 0.7 ? Mth.map((double)this.shelfProgress, (double)0.7, (double)(0.7 + steepness), (double)this.midShelfHeight, (double)this.topShelfHeight) : (this.shelfProgress > 0.35 + steepness ? this.midShelfHeight : (this.shelfProgress > 0.35 ? Mth.map((double)this.shelfProgress, (double)0.35, (double)(0.35 + steepness), (double)this.sandHeight, (double)this.midShelfHeight) : this.sandHeight)));
                return this.height;
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.sandHeight) {
                    return -0.6;
                }
                if (this.height <= this.midShelfHeight) {
                    double cliffCurveDepth = this.caveNoise.noise(this.x, yIn, this.z);
                    double cliffProgress = ShoreNoise.widthFunction(true, (double)yIn - this.tideLevel, this.midShelfHeight - this.tideLevel, 0.35 + cliffCurveDepth, 0.35);
                    return 0.4 + 3.0 * (cliffProgress - this.shelfProgress);
                }
                if ((double)yIn <= this.height) {
                    return 0.0;
                }
                return 0.7;
            }
        };
    }

    public static ShoreNoiseSampler rockyShores(final Seed seed) {
        return new ShoreNoiseSampler(){
            private final Noise2D rockShelfIntensity;
            private final Noise2D steepnessNoise;
            private final Noise2D roughnessNoise;
            private final Noise2D tidepoolNoise;
            private final Cellular2D cellularNoise;
            private final Noise2D punchbowlCarvingNoise;
            private final Noise2D punchbowlSizeNoise;
            final double topShelfEdge = 0.7;
            final double midShelfEdge = 0.35;
            final double lowShelfEdge = 0.1;
            int x;
            int z;
            double oceanWeight;
            double oceanEdgeHeight;
            double shelfProgress;
            double height;
            double topShelfHeight;
            double midShelfHeight;
            double lowShelfHeight;
            {
                this.rockShelfIntensity = new OpenSimplex2D(seed.seed() + 5252L).octaves(3).spread(0.03).scaled(-0.8, 1.0);
                this.steepnessNoise = new OpenSimplex2D(seed.seed() + 224L).octaves(2).spread(0.11).clampedScaled(-0.7, 0.7, 0.0, 0.3);
                this.roughnessNoise = new OpenSimplex2D(seed.seed()).octaves(3).spread(0.09).scaled(-3.0, 3.0);
                this.tidepoolNoise = new OpenSimplex2D(seed.seed() + 492L).octaves(3).spread(0.09).clampedScaled(-1.0, 0.0, -5.0, 0.0);
                this.cellularNoise = new Cellular2D(seed.seed() + 323L).spread(0.022);
                this.punchbowlCarvingNoise = (x, z) -> {
                    Cellular2D.Cell cell = this.cellularNoise.cell(x, z);
                    double punchBowlRarity = 0.25;
                    double punchBowlDiameter = 0.5;
                    if (cell.noise() > 0.25 && cell.f2() >= 0.5) {
                        return 1.0;
                    }
                    return cell.f1();
                };
                this.punchbowlSizeNoise = new OpenSimplex2D(seed.seed()).octaves(3).spread(0.06).clampedScaled(-0.7, 0.7, -0.05, 0.15);
                this.topShelfEdge = 0.7;
                this.midShelfEdge = 0.35;
                this.lowShelfEdge = 0.1;
            }

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                double tideLevel = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z);
                this.oceanEdgeHeight = tideLevel - 4.0;
                this.x = x;
                this.z = z;
                this.oceanWeight = oceanWeight;
                double roughness = this.roughnessNoise.noise(x, z) + this.tidepoolNoise.noise(x, z);
                this.topShelfHeight = 63.0 + roughness + 15.0;
                this.midShelfHeight = 63.0 + roughness + 9.0;
                this.lowShelfHeight = 63.0 + roughness + 3.0;
                double baseRockShelfNoise = this.rockShelfIntensity.noise(x, z);
                if (oceanWeight > 0.1) {
                    this.shelfProgress = Mth.clampedMap((double)oceanWeight, (double)0.1, (double)0.3, (double)baseRockShelfNoise, (double)(baseRockShelfNoise - oceanWeight * 3.0));
                } else {
                    double landInfluence = Mth.clampedMap((double)landWeight, (double)0.4, (double)0.0, (double)(baseRockShelfNoise + landWeight * 2.0), (double)baseRockShelfNoise);
                    this.shelfProgress = Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.1, (double)(baseRockShelfNoise + landInfluence), (double)baseRockShelfNoise);
                }
                double steepness = this.steepnessNoise.noise(x, z);
                this.height = this.shelfProgress > 0.7 + steepness ? this.topShelfHeight : (this.shelfProgress > 0.7 ? Mth.map((double)this.shelfProgress, (double)0.7, (double)(0.7 + steepness), (double)this.midShelfHeight, (double)this.topShelfHeight) : (this.shelfProgress > 0.35 + steepness ? this.midShelfHeight : (this.shelfProgress > 0.35 ? Mth.map((double)this.shelfProgress, (double)0.35, (double)(0.35 + steepness), (double)this.lowShelfHeight, (double)this.midShelfHeight) : (this.shelfProgress > 0.1 - steepness ? this.lowShelfHeight : this.oceanEdgeHeight))));
                return this.height;
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.oceanEdgeHeight) {
                    return 0.0;
                }
                if ((double)yIn >= this.height) {
                    return 0.7;
                }
                double punchbowlRadius = this.punchbowlCarvingNoise.noise(this.x, this.z);
                double returnNoise = 0.0;
                if (this.height <= this.lowShelfHeight) {
                    double cliffProgress = ShoreNoise.widthFunction(true, (double)yIn - this.oceanEdgeHeight, this.lowShelfHeight - this.oceanEdgeHeight, 0.21000000000000002, 0.1);
                    returnNoise = 0.4 + 3.0 * (cliffProgress - this.shelfProgress);
                }
                if (punchbowlRadius < 0.25) {
                    double intensityShift = this.punchbowlSizeNoise.noise(this.x, this.z);
                    double edgeIntensity = ShoreNoise.widthFunction(true, (double)yIn - this.oceanEdgeHeight, this.topShelfHeight - this.oceanEdgeHeight, 0.25 - intensityShift, 0.12 - intensityShift);
                    returnNoise = Math.max(returnNoise, 3.0 * (edgeIntensity - punchbowlRadius));
                }
                return returnNoise;
            }
        };
    }

    public static ShoreNoiseSampler classic(final Seed seed) {
        return new ShoreNoiseSampler(){
            final Noise2D shoreNoise;
            {
                this.shoreNoise = new OpenSimplex2D(seed.seed() + 8719234132L).octaves(2).spread(0.003f).scaled(-0.1, 1.1);
            }

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                double normalWeight;
                double adjustedNormalWeight;
                int cliffHeightAdjustment = biome.getShoreBaseHeight();
                double cliffInfluence = Mth.clamp((double)(this.shoreNoise.noise(x, z) + Mth.map((double)heightIn, (double)cliffHeightAdjustment, (double)(cliffHeightAdjustment + 20), (double)0.0, (double)0.6)), (double)0.0, (double)1.0);
                double adjustedCliffInfluence = 1.0 - (1.0 - cliffInfluence) * (1.0 - cliffInfluence);
                double x2 = Mth.lerp((double)adjustedCliffInfluence, (double)0.8, (double)0.515);
                double y2 = 1.15 - 0.3 * x2;
                double adjustedShoreWeight = shoreWeight < x2 ? Mth.map((double)shoreWeight, (double)0.5, (double)x2, (double)0.5, (double)y2) : Mth.map((double)shoreWeight, (double)x2, (double)1.0, (double)y2, (double)1.0);
                double adjustedHeight = Math.max(adjustedShoreWeight / shoreWeight * shoreHeight + (adjustedNormalWeight = 1.0 - adjustedShoreWeight) / (normalWeight = 1.0 - shoreWeight) * normalHeight, (double)cliffHeightAdjustment);
                if (adjustedHeight < heightIn) {
                    heightIn = adjustedHeight;
                }
                return heightIn;
            }
        };
    }

    public static ShoreNoiseSampler seaStacks(final Seed seed) {
        return new ShoreNoiseSampler(){
            final double minStackDensity = 0.85;
            final double noiseScale = 3.0;
            final Cellular2D cellularNoise = new Cellular2D(seed.seed() + 323L).spread(0.05);
            final Noise2D seaStackDistributionNoise = new OpenSimplex2D(seed.seed() + 5424L).octaves(2).map(y -> 1.0 - Math.abs(y)).spread(0.015);
            final Noise2D f2MinusF1Noise = (x, z) -> {
                Cellular2D.Cell cell = this.cellularNoise.cell(x, z);
                double f1 = cell.f1();
                double f2 = cell.f2();
                return f1 > 0.0 ? f2 - f1 : 1.0;
            };
            final Noise2D f1Noise = (x, z) -> {
                double centerZ;
                Cellular2D.Cell cell = this.cellularNoise.cell(x, z);
                double centerX = cell.x();
                double stackDensity = this.seaStackDistributionNoise.noise(centerX, centerZ = cell.y());
                if (stackDensity < 0.85) {
                    return 3.0;
                }
                return cell.f1();
            };
            final Noise3D cliffNoise = BiomeNoise.cliffNoise(seed);
            private double stackNoiseValue;
            private double sandHeight;
            private double landWeight;
            private double tideLevel;
            private double oceanWeightFactor;
            private int x;
            private int z;

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.x = x;
                this.z = z;
                this.landWeight = landWeight;
                this.oceanWeightFactor = Mth.clampedMap((double)oceanWeight, (double)0.1, (double)0.25, (double)1.0, (double)0.0);
                this.tideLevel = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z);
                double typicalBeachSandHeight = ShoreNoise.simpleBeach(this.tideLevel, heightIn, landWeight, oceanWeight);
                this.sandHeight = Mth.clampedMap((double)thisWeight, (double)0.5, (double)0.8, (double)typicalBeachSandHeight, (double)Math.min(typicalBeachSandHeight, this.tideLevel - 1.0));
                double f2MinusF1 = this.f2MinusF1Noise.noise(x, z);
                double outputMin = Mth.clampedMap((double)this.seaStackDistributionNoise.noise(x, z), (double)0.2, (double)0.6, (double)3.0, (double)1.0);
                this.stackNoiseValue = this.f1Noise.noise(x, z) * Mth.clampedMap((double)Math.abs(f2MinusF1), (double)0.0, (double)0.25, (double)outputMin, (double)1.0);
                return Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.5, (double)heightIn, (double)(shoreHeight / shoreWeight));
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.sandHeight) {
                    return 0.0;
                }
                double overhangHeight = 77.0;
                double stackBaseHeight = this.tideLevel + 1.0;
                double y = (double)yIn - stackBaseHeight;
                double cliffNoiseModifier = 0.04 * Math.abs(this.cliffNoise.noise(this.x, y, this.z));
                double stackMinWidth = (0.06 + cliffNoiseModifier) * this.oceanWeightFactor;
                double stackMaxWidth = (0.18 + cliffNoiseModifier) * this.oceanWeightFactor;
                double cliffBorderTopWeight = 0.22 + cliffNoiseModifier;
                double cliffBorderBaseWeight = 0.26 + cliffNoiseModifier;
                double height = 77.0 - stackBaseHeight;
                double stackWidth = ShoreNoise.widthFunction(false, y, height, stackMinWidth, stackMaxWidth);
                double stackOutput = Math.clamp((this.stackNoiseValue - stackWidth) * 10.0, 0.0, 1.0) * Mth.clampedMap((double)yIn, (double)stackBaseHeight, (double)77.0, (double)3.0, (double)0.75);
                if (this.landWeight >= cliffBorderTopWeight) {
                    double cliffBorderWeight = ShoreNoise.widthFunction(true, y, height, cliffBorderBaseWeight, cliffBorderTopWeight);
                    return Math.min(Math.clamp((cliffBorderWeight - this.landWeight) * 10.0, 0.0, 1.0) * 3.0, stackOutput);
                }
                return stackOutput;
            }
        };
    }

    public static ShoreNoiseSampler upperTerrace(final Seed seed) {
        return new ShoreNoiseSampler(){
            final double noiseScale = 3.0;
            final Noise3D cliffNoise = BiomeNoise.cliffNoise(seed);
            final Noise2D lowerTerraceNoise = BiomeNoise.lowerTerraceNoise(seed);
            final Noise2D upperTerraceNoise = BiomeNoise.upperTerraceNoise(seed);
            private double landWeight;
            private int x;
            private int z;

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.x = x;
                this.z = z;
                this.landWeight = landWeight;
                return this.upperTerraceNoise.noise(x, z);
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                double lowerHeight = this.lowerTerraceNoise.noise(this.x, this.z);
                if ((double)yIn <= lowerHeight) {
                    return 0.0;
                }
                double overhangHeight = 88.0;
                double cliffBaseHeight = 74.0;
                double y = (double)yIn - 74.0;
                double cliffNoiseModifier = 0.04 * Math.abs(this.cliffNoise.noise(this.x, y, this.z));
                double cliffBorderTopWeight = 0.32 + cliffNoiseModifier;
                double cliffBorderBaseWeight = 0.36 + cliffNoiseModifier;
                double height = 14.0;
                if (this.landWeight >= cliffBorderTopWeight) {
                    double cliffBorderWeight = ShoreNoise.widthFunction(true, y, 14.0, cliffBorderBaseWeight, cliffBorderTopWeight);
                    return Math.clamp((cliffBorderWeight - this.landWeight) * 10.0, 0.0, 1.0) * 3.0;
                }
                return Mth.clampedMap((double)yIn, (double)lowerHeight, (double)(lowerHeight + 6.0), (double)0.0, (double)3.0);
            }
        };
    }

    public static ShoreNoiseSampler lowerTerrace(final Seed seed) {
        return new ShoreNoiseSampler(){
            final double noiseScale = 1.0;
            final Noise3D cliffNoise = BiomeNoise.cliffNoise(seed);
            final Noise2D lowerTerraceNoise = BiomeNoise.lowerTerraceNoise(seed);
            private double oceanWeight;
            private double lowerTerraceHeight;
            private double sandHeight;
            private int x;
            private int z;

            @Override
            public double setColumnAndSampleHeight(double heightIn, int x, int z, double oceanWeight, double landWeight, double shoreWeight, double thisWeight, BiomeExtension biome, double shoreHeight, double normalHeight) {
                this.x = x;
                this.z = z;
                this.oceanWeight = oceanWeight;
                this.lowerTerraceHeight = this.lowerTerraceNoise.noise(x, z);
                this.sandHeight = ShoreNoise.simpleBeach(seed, x, z, heightIn, landWeight, oceanWeight);
                return this.lowerTerraceHeight;
            }

            @Override
            public double noise(int yIn, double noiseIn) {
                if ((double)yIn <= this.sandHeight) {
                    return 0.0;
                }
                double overhangHeight = 74.0;
                double cliffBaseHeight = 61.0;
                double y = (double)yIn - 61.0;
                double cliffNoiseModifier = 0.12 * Math.abs(this.cliffNoise.noise(this.x, y, this.z));
                double cliffBorderTopWeight = 0.26 - cliffNoiseModifier;
                double cliffBorderBaseWeight = 0.22 - cliffNoiseModifier;
                double height = 13.0;
                if (this.oceanWeight >= cliffBorderBaseWeight) {
                    double cliffBorderWeight = ShoreNoise.widthFunction(false, y, 13.0, cliffBorderBaseWeight, cliffBorderTopWeight);
                    return Math.clamp((this.oceanWeight - cliffBorderWeight) * 20.0, 0.0, 1.0) * 1.0;
                }
                return 0.0;
            }
        };
    }

    private static double widthFunction(boolean inverted, double y, double height, double baseWidth, double topWidth) {
        double curve = baseWidth + y * y / (height * height) * (topWidth - baseWidth);
        if (inverted) {
            return Math.max(curve, topWidth);
        }
        return Math.min(curve, topWidth);
    }

    private static double simpleBeach(Seed seed, int x, int z, double heightIn, double landWeight, double oceanWeight) {
        double tideLevel = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z);
        return ShoreNoise.simpleBeach(tideLevel, heightIn, landWeight, oceanWeight);
    }

    private static double simpleBeach(double tideLevel, double heightIn, double landWeight, double oceanWeight) {
        double simpleShoreLandHeight = tideLevel + 2.0;
        double simpleShoreSelfHeight = tideLevel - 2.0;
        double simpleShoreOceanHeight = tideLevel - 4.0;
        if (oceanWeight > 0.1) {
            return Mth.clampedMap((double)oceanWeight, (double)0.1, (double)0.25, (double)simpleShoreSelfHeight, (double)simpleShoreOceanHeight);
        }
        double landDerivedHeight = landWeight < 0.3 ? Mth.map((double)landWeight, (double)0.3, (double)0.0, (double)Math.min(heightIn, simpleShoreLandHeight), (double)simpleShoreSelfHeight) : Mth.clampedMap((double)landWeight, (double)0.3, (double)0.5, (double)Math.min(heightIn, simpleShoreLandHeight), (double)heightIn);
        return Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.1, (double)landDerivedHeight, (double)simpleShoreSelfHeight);
    }

    private static double simpleBeachNoLandBlend(Seed seed, int x, int z, double heightIn, double landWeight, double oceanWeight) {
        double tideLevel = BiomeNoise.shoreTideLevelNoise(seed).noise(x, z);
        double simpleShoreSelfHeight = tideLevel - 1.0;
        double simpleShoreOceanHeight = tideLevel - 4.0;
        return Mth.clampedMap((double)oceanWeight, (double)0.0, (double)0.5, (double)simpleShoreSelfHeight, (double)simpleShoreOceanHeight);
    }
}

