/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public final class SurfaceManager {
    private final Map<BiomeExtension, SurfaceBuilder> builders;

    private static Map<BiomeExtension, SurfaceBuilder> collectSurfaceBuilders(Seed seed) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BiomeExtension variant : TFCBiomes.REGISTRY) {
            builder.put((Object)variant, (Object)variant.createSurfaceBuilder(seed));
        }
        return builder.build();
    }

    public SurfaceManager(Seed seed) {
        this.builders = SurfaceManager.collectSurfaceBuilders(seed);
    }

    public void buildSurface(LevelAccessor world, ChunkAccess chunk, RockLayerSettings rockLayerSettings, ChunkData chunkData, BiomeExtension[] accurateChunkBiomes, BiomeExtension[] accurateChunkBiomesNoRivers, double[] accurateChunkBiomeWeights, double[] slopeMap, RandomSource random, int seaLevel, int minY) {
        boolean debugSlope = false;
        ChunkPos chunkPos = chunk.getPos();
        int blockX = chunkPos.getMinBlockX();
        int blockZ = chunkPos.getMinBlockZ();
        SurfaceBuilderContext context = new SurfaceBuilderContext(world, chunk, chunkData, random, rockLayerSettings, seaLevel, minY);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x, z) + 1;
                double slope = this.sampleSlope(slopeMap, x, z);
                BiomeExtension biome = accurateChunkBiomes[x + 16 * z];
                BiomeExtension originalBiome = accurateChunkBiomesNoRivers[x + 16 * z];
                double weight = accurateChunkBiomeWeights[x + 16 * z];
                SurfaceBuilder builder = this.builders.get(biome);
                context.buildSurface(biome, originalBiome, weight, biome.isSalty(), builder, blockX + x, y, blockZ + z, slope);
            }
        }
    }

    private double sampleSlope(double[] slopeMap, int x, int z) {
        int offsetX = x + 2;
        int offsetZ = z + 2;
        int cellX = offsetX >> 2;
        int cellZ = offsetZ >> 2;
        double deltaX = ((double)offsetX - (double)(cellX << 2)) * 0.25;
        double deltaZ = ((double)offsetZ - (double)(cellZ << 2)) * 0.25;
        double slope = 0.0;
        slope += slopeMap[cellX + 0 + 6 * (cellZ + 0)] * (1.0 - deltaX) * (1.0 - deltaZ);
        slope += slopeMap[cellX + 1 + 6 * (cellZ + 0)] * deltaX * (1.0 - deltaZ);
        slope += slopeMap[cellX + 0 + 6 * (cellZ + 1)] * (1.0 - deltaX) * deltaZ;
        slope += slopeMap[cellX + 1 + 6 * (cellZ + 1)] * deltaX * deltaZ;
        return slope *= (double)0.8f;
    }

    private void slopeVisualization(ChunkAccess chunk, double[] slopeMap, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Block[] meter = new Block[]{Blocks.WHITE_STAINED_GLASS, Blocks.LIGHT_GRAY_STAINED_GLASS, Blocks.LIGHT_BLUE_STAINED_GLASS, Blocks.BLUE_STAINED_GLASS, Blocks.CYAN_STAINED_GLASS, Blocks.GREEN_STAINED_GLASS, Blocks.LIME_STAINED_GLASS, Blocks.YELLOW_STAINED_GLASS, Blocks.ORANGE_STAINED_GLASS, Blocks.RED_STAINED_GLASS, Blocks.MAGENTA_STAINED_GLASS, Blocks.PINK_STAINED_GLASS};
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                mutablePos.set(chunkX + x, y, chunkZ + z);
                double slope = this.sampleSlope(slopeMap, x, z);
                int slopeIndex = Mth.clamp((int)((int)slope), (int)0, (int)(meter.length - 1));
                chunk.setBlockState((BlockPos)mutablePos, meter[slopeIndex].defaultBlockState(), false);
            }
        }
    }
}

