/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SoilSurfaceState;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public final class SurfaceStates {
    public static final SurfaceState RAW = context -> context.getRock().raw().defaultBlockState();
    public static final SurfaceState COBBLE = context -> context.getRock().cobble().defaultBlockState();
    public static final SurfaceState GRAVEL = context -> context.getRock().gravel().defaultBlockState();
    public static final SurfaceState SAND = context -> context.getRock().sand().defaultBlockState();
    public static final SurfaceState SANDSTONE = context -> context.getRock().sandstone().defaultBlockState();
    public static final SurfaceState BASALT = context -> ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState BASALT_COBBLE = context -> ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.COBBLE).get()).defaultBlockState();
    public static final SurfaceState BASALT_GRAVEL = context -> ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.GRAVEL).get()).defaultBlockState();
    public static final SurfaceState BASALT_MORAINE = context -> (Helpers.hash(729375982L, context.pos()) & 0x7F) > 96 ? ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.COBBLE).get()).defaultBlockState() : ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.GRAVEL).get()).defaultBlockState();
    public static final SurfaceState TUFF = context -> ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.TUFF).get((Object)Rock.BlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState TUFF_GRAVEL = context -> ((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.TUFF).get((Object)Rock.BlockType.GRAVEL).get()).defaultBlockState();
    public static final SurfaceState MORAINE = context -> (Helpers.hash(729375982L, context.pos()) & 0x7F) > 96 ? context.getRock().cobble().defaultBlockState() : context.getRock().gravel().defaultBlockState();
    public static final SurfaceState SAND_AND_GRAVEL = context -> (Helpers.hash(728275914L, context.pos()) & 0x7F) > 48 ? context.getRock().sand().defaultBlockState() : context.getRock().gravel().defaultBlockState();
    public static final SurfaceState PACKED_ICE = context -> Blocks.PACKED_ICE.defaultBlockState();
    public static final SurfaceState BLUE_ICE = context -> Blocks.BLUE_ICE.defaultBlockState();
    public static final SurfaceState SNOW = context -> Blocks.SNOW_BLOCK.defaultBlockState();
    public static final SurfaceState COARSE_ARIDISOL_BASE = SoilSurfaceState.soil(SoilBlockType.COARSE_DIRT, SoilBlockType.Variant.ARIDISOL);
    public static final SurfaceState COARSE_ANDISOL_BASE = SoilSurfaceState.soil(SoilBlockType.COARSE_DIRT, SoilBlockType.Variant.ANDISOL);
    public static final SurfaceState DRY_MUD = context -> ((Block)TFCBlocks.HARDENED_CLAY.get()).defaultBlockState();
    public static final SurfaceState SALTED_EARTH = context -> ((Block)TFCBlocks.HALITE.get()).defaultBlockState();
    public static final SurfaceState RIVER_SAND = context -> context.getSeaLevelRock().sand().defaultBlockState();
    public static final SurfaceState YELLOW_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.YELLOW).get()).defaultBlockState();
    public static final SurfaceState YELLOW_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.YELLOW).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState RED_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.RED).get()).defaultBlockState();
    public static final SurfaceState RED_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.RED).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState BROWN_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.BROWN).get()).defaultBlockState();
    public static final SurfaceState BROWN_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.BROWN).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState WHITE_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.WHITE).get()).defaultBlockState();
    public static final SurfaceState WHITE_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.WHITE).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState BLACK_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.BLACK).get()).defaultBlockState();
    public static final SurfaceState BLACK_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.BLACK).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState GREEN_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.GREEN).get()).defaultBlockState();
    public static final SurfaceState GREEN_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.GREEN).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState PINK_SAND = context -> ((Block)TFCBlocks.SAND.get((Object)SandBlockType.PINK).get()).defaultBlockState();
    public static final SurfaceState PINK_SANDSTONE = context -> ((Block)TFCBlocks.SANDSTONE.get((Object)SandBlockType.PINK).get((Object)SandstoneBlockType.RAW).get()).defaultBlockState();
    public static final SurfaceState OCEAN_MUD = context -> ((Block)TFCBlocks.SOIL.get((Object)SoilBlockType.MUD).get(SoilBlockType.Variant.FLUVISOL).get()).defaultBlockState();
    public static final SurfaceState TOP_GRASS_TO_GRAVEL = SoilSurfaceState.buildSurfaceType(SoilBlockType.GRASS, GRAVEL);
    public static final SurfaceState TOP_GRASS_TO_SAND = SoilSurfaceState.buildSurfaceType(SoilBlockType.GRASS, SAND);
    public static final SurfaceState MID_DIRT_TO_GRAVEL = SoilSurfaceState.buildMidType(SoilBlockType.DIRT, GRAVEL);
    public static final SurfaceState MID_DIRT_TO_SAND = SoilSurfaceState.buildMidType(SoilBlockType.DIRT, SAND);
    public static final SurfaceState VOLCANIC_TOP_GRASS_TO_GRAVEL = SoilSurfaceState.buildVolcanicSurfaceType(SoilBlockType.GRASS, BASALT_GRAVEL);
    public static final SurfaceState VOLCANIC_MID_DIRT_TO_GRAVEL = SoilSurfaceState.buildVolcanicMidType(SoilBlockType.DIRT, BASALT_GRAVEL);
    public static final SurfaceState VOLCANIC_TOP_GRASS_TO_LOCAL_GRAVEL = SoilSurfaceState.buildVolcanicSurfaceType(SoilBlockType.GRASS, GRAVEL);
    public static final SurfaceState VOLCANIC_MID_DIRT_TO_LOCAL_GRAVEL = SoilSurfaceState.buildVolcanicMidType(SoilBlockType.DIRT, GRAVEL);
    public static final SurfaceState UNDER_GRAVEL = SoilSurfaceState.buildUnderType();
    public static final SurfaceState MUD = SoilSurfaceState.buildSurfaceType(SoilBlockType.MUD, GRAVEL);
    public static final SurfaceState SNOWY_RAW = SoilSurfaceState.buildSnowableSurface(SNOW, RAW);
    public static final SurfaceState SNOWY_COBBLE = SoilSurfaceState.buildSnowableSurface(SNOW, COBBLE);
    public static final SurfaceState SNOWY_GRAVEL = SoilSurfaceState.buildSnowableSurface(SNOW, GRAVEL);
    public static final SurfaceState SNOWY_SAND = SoilSurfaceState.buildSnowableSurface(SNOW, SAND);
    public static final SurfaceState SNOWY_SANDSTONE = SoilSurfaceState.buildSnowableSurface(SNOW, SANDSTONE);
    public static final SurfaceState SNOWY_MORAINE = SoilSurfaceState.buildSnowableSurface(SNOW, MORAINE);
    public static final SurfaceState SNOWY_BASALT = SoilSurfaceState.buildSnowableSurface(SNOW, BASALT);
    public static final SurfaceState SNOWY_BASALT_COBBLE = SoilSurfaceState.buildSnowableSurface(SNOW, BASALT_COBBLE);
    public static final SurfaceState SNOWY_BASALT_GRAVEL = SoilSurfaceState.buildSnowableSurface(SNOW, BASALT_GRAVEL);
    public static final SurfaceState SNOWY_BASALT_MORAINE = SoilSurfaceState.buildSnowableSurface(SNOW, BASALT_MORAINE);
    public static final SurfaceState SNOWY_SAND_AND_GRAVEL = SoilSurfaceState.buildSnowableSurface(SNOW, SAND_AND_GRAVEL);
    public static final SurfaceState RARE_SHORE_SAND = new SurfaceState(){
        private final Supplier<Block> pinkSand = TFCBlocks.SAND.get((Object)SandBlockType.PINK);
        private final Supplier<Block> greenSand = TFCBlocks.SAND.get((Object)SandBlockType.GREEN);
        private final Supplier<Block> blackSand = TFCBlocks.SAND.get((Object)SandBlockType.BLACK);
        private final Supplier<Block> whiteSand = TFCBlocks.SAND.get((Object)SandBlockType.WHITE);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            if (context.groundWater() > 300.0f && context.averageTemperature() > 15.0f) {
                return this.pinkSand.get().defaultBlockState();
            }
            if (context.getSeaLevelRock().mafic().isPresent() && context.getSeaLevelRock().mafic().get().booleanValue()) {
                if (context.groundWater() > 300.0f) {
                    return this.greenSand.get().defaultBlockState();
                }
                return this.blackSand.get().defaultBlockState();
            }
            return this.whiteSand.get().defaultBlockState();
        }
    };
    public static final SurfaceState VOLCANIC_SHORE_SAND = new SurfaceState(){
        private final Supplier<Block> greenSand = TFCBlocks.SAND.get((Object)SandBlockType.GREEN);
        private final Supplier<Block> blackSand = TFCBlocks.SAND.get((Object)SandBlockType.BLACK);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            if (context.groundWater() > 420.0f) {
                return this.greenSand.get().defaultBlockState();
            }
            return this.blackSand.get().defaultBlockState();
        }
    };
    public static final SurfaceState SHORE_SAND = new SurfaceState(){
        private final Supplier<Block> redSand = TFCBlocks.SAND.get((Object)SandBlockType.RED);
        private final Supplier<Block> brownSand = TFCBlocks.SAND.get((Object)SandBlockType.BROWN);
        private final Supplier<Block> yellowSand = TFCBlocks.SAND.get((Object)SandBlockType.YELLOW);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            BlockPos pos = context.pos();
            int x = pos.getX();
            int z = pos.getZ();
            float variantNoiseValue = (float)SurfaceStates.sandVariantNoise().noise(x, z);
            if ((double)variantNoiseValue > 0.55) {
                return RARE_SHORE_SAND.getState(context);
            }
            if ((double)variantNoiseValue > 0.2) {
                return this.yellowSand.get().defaultBlockState();
            }
            if ((double)variantNoiseValue > 0.1) {
                return this.brownSand.get().defaultBlockState();
            }
            return this.redSand.get().defaultBlockState();
        }
    };
    public static final SurfaceState SHORE_SURFACE = new SurfaceState(){

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            double gravelCutoff;
            BlockPos pos = context.pos();
            int x = pos.getX();
            int z = pos.getZ();
            float variantNoiseValue = (float)SurfaceStates.sandGravelBeachNoise().noise(x, z);
            return ((double)variantNoiseValue > (gravelCutoff = Mth.clampedMap((double)context.averageTemperature(), (double)-15.0, (double)25.0, (double)-0.7, (double)0.7)) ? GRAVEL : SHORE_SAND).getState(context);
        }
    };
    public static final SurfaceState RARE_SHORE_SANDSTONE = new SurfaceState(){
        private final Supplier<Block> pinkSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.PINK).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> greenSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.GREEN).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> blackSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.BLACK).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> whiteSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.WHITE).get((Object)SandstoneBlockType.RAW);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            if (context.groundWater() > 300.0f && context.averageTemperature() > 15.0f) {
                return this.pinkSandstone.get().defaultBlockState();
            }
            if (context.getSeaLevelRock().mafic().isPresent() && context.getSeaLevelRock().mafic().get().booleanValue()) {
                if (context.groundWater() > 300.0f) {
                    return this.greenSandstone.get().defaultBlockState();
                }
                return this.blackSandstone.get().defaultBlockState();
            }
            return this.whiteSandstone.get().defaultBlockState();
        }
    };
    public static final SurfaceState VOLCANIC_SHORE_SANDSTONE = new SurfaceState(){
        private final Supplier<Block> greenSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.GREEN).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> blackSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.BLACK).get((Object)SandstoneBlockType.RAW);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            if (context.groundWater() > 420.0f) {
                return this.greenSandstone.get().defaultBlockState();
            }
            return this.blackSandstone.get().defaultBlockState();
        }
    };
    public static final SurfaceState SHORE_SANDSTONE = new SurfaceState(){
        private final Supplier<Block> redSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.RED).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> brownSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.BROWN).get((Object)SandstoneBlockType.RAW);
        private final Supplier<Block> yellowSandstone = TFCBlocks.SANDSTONE.get((Object)SandBlockType.YELLOW).get((Object)SandstoneBlockType.RAW);

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            BlockPos pos = context.pos();
            int x = pos.getX();
            int z = pos.getZ();
            float variantNoiseValue = (float)SurfaceStates.sandVariantNoise().noise(x, z);
            if ((double)variantNoiseValue > 0.8) {
                return RARE_SHORE_SANDSTONE.getState(context);
            }
            if ((double)variantNoiseValue > 0.4) {
                return this.yellowSandstone.get().defaultBlockState();
            }
            if ((double)variantNoiseValue > 0.2) {
                return this.redSandstone.get().defaultBlockState();
            }
            return this.brownSandstone.get().defaultBlockState();
        }
    };
    public static final SurfaceState SHORE_UNDERLAYER = new SurfaceState(){

        @Override
        public BlockState getState(SurfaceBuilderContext context) {
            double gravelCutoff;
            BlockPos pos = context.pos();
            int x = pos.getX();
            int z = pos.getZ();
            float variantNoiseValue = (float)SurfaceStates.sandGravelBeachNoise().noise(x, z);
            return ((double)variantNoiseValue > (gravelCutoff = Mth.clampedMap((double)context.averageTemperature(), (double)-15.0, (double)25.0, (double)-0.7, (double)0.7)) ? RAW : SHORE_SANDSTONE).getState(context);
        }
    };
    public static final SurfaceState TOP_GRASS_TO_SHORE_SAND = SoilSurfaceState.buildSurfaceType(SoilBlockType.GRASS, SHORE_SAND);
    public static final SurfaceState MID_DIRT_TO_SHORE_SAND = SoilSurfaceState.buildMidType(SoilBlockType.DIRT, SHORE_SAND);
    public static final SurfaceState VOLCANIC_TOP_GRASS_TO_SHORE_SAND = SoilSurfaceState.buildVolcanicSurfaceType(SoilBlockType.GRASS, SHORE_SAND);
    public static final SurfaceState VOLCANIC_MID_DIRT_TO_SHORE_SAND = SoilSurfaceState.buildVolcanicMidType(SoilBlockType.DIRT, SHORE_SAND);
    public static final SurfaceState WATER = context -> context.salty() ? TFCFluids.SALT_WATER.createSourceBlock() : Fluids.WATER.defaultFluidState().createLegacyBlock();

    public static Noise2D sandVariantNoise() {
        return new OpenSimplex2D(36263276L).octaves(5).spread(3.0E-4f).abs();
    }

    public static Noise2D sandGravelBeachNoise() {
        return new OpenSimplex2D(124154L).octaves(3).spread(2.0E-5f);
    }
}

