/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.ClientInventoryTooltip;
import net.dries007.tfc.client.ColorMapReloadListener;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.IngameOverlays;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.TFCKeyBindings;
import net.dries007.tfc.client.extensions.BlowpipeExtension;
import net.dries007.tfc.client.extensions.FluidRendererExtension;
import net.dries007.tfc.client.extensions.ItemRendererExtension;
import net.dries007.tfc.client.model.ContainedFluidModel;
import net.dries007.tfc.client.model.DoubleIngotPileBlockModel;
import net.dries007.tfc.client.model.IngotPileBlockModel;
import net.dries007.tfc.client.model.MoldsModelLoader;
import net.dries007.tfc.client.model.PlantBlockModel;
import net.dries007.tfc.client.model.ScrapingBlockModel;
import net.dries007.tfc.client.model.TrimmedItemModel;
import net.dries007.tfc.client.model.entity.AlpacaModel;
import net.dries007.tfc.client.model.entity.AnemometerModel;
import net.dries007.tfc.client.model.entity.BisonModel;
import net.dries007.tfc.client.model.entity.BlackBearModel;
import net.dries007.tfc.client.model.entity.BluegillModel;
import net.dries007.tfc.client.model.entity.BoarModel;
import net.dries007.tfc.client.model.entity.BongoModel;
import net.dries007.tfc.client.model.entity.CalendarClockModel;
import net.dries007.tfc.client.model.entity.CaribouModel;
import net.dries007.tfc.client.model.entity.CougarModel;
import net.dries007.tfc.client.model.entity.CrocodileModel;
import net.dries007.tfc.client.model.entity.DeerModel;
import net.dries007.tfc.client.model.entity.DirewolfModel;
import net.dries007.tfc.client.model.entity.DogModel;
import net.dries007.tfc.client.model.entity.DuckModel;
import net.dries007.tfc.client.model.entity.GazelleModel;
import net.dries007.tfc.client.model.entity.GrizzlyBearModel;
import net.dries007.tfc.client.model.entity.GrouseModel;
import net.dries007.tfc.client.model.entity.HorseChestLayer;
import net.dries007.tfc.client.model.entity.HorseshoeCrabModel;
import net.dries007.tfc.client.model.entity.HyenaModel;
import net.dries007.tfc.client.model.entity.IsopodModel;
import net.dries007.tfc.client.model.entity.JavelinModel;
import net.dries007.tfc.client.model.entity.JellyfishModel;
import net.dries007.tfc.client.model.entity.JerboaModel;
import net.dries007.tfc.client.model.entity.LemmingModel;
import net.dries007.tfc.client.model.entity.LeopardSealModel;
import net.dries007.tfc.client.model.entity.LionModel;
import net.dries007.tfc.client.model.entity.LobsterModel;
import net.dries007.tfc.client.model.entity.ManateeModel;
import net.dries007.tfc.client.model.entity.MongooseModel;
import net.dries007.tfc.client.model.entity.MooseModel;
import net.dries007.tfc.client.model.entity.MuskOxModel;
import net.dries007.tfc.client.model.entity.OrcaModel;
import net.dries007.tfc.client.model.entity.PeafowlModel;
import net.dries007.tfc.client.model.entity.PenguinModel;
import net.dries007.tfc.client.model.entity.PheasantModel;
import net.dries007.tfc.client.model.entity.PolarBearModel;
import net.dries007.tfc.client.model.entity.QuailModel;
import net.dries007.tfc.client.model.entity.RatModel;
import net.dries007.tfc.client.model.entity.SabertoothModel;
import net.dries007.tfc.client.model.entity.TFCChickenModel;
import net.dries007.tfc.client.model.entity.TFCCowModel;
import net.dries007.tfc.client.model.entity.TFCGoatModel;
import net.dries007.tfc.client.model.entity.TFCPigModel;
import net.dries007.tfc.client.model.entity.TFCSheepModel;
import net.dries007.tfc.client.model.entity.TFCTurtleModel;
import net.dries007.tfc.client.model.entity.TFCWolfModel;
import net.dries007.tfc.client.model.entity.TigerModel;
import net.dries007.tfc.client.model.entity.TurkeyModel;
import net.dries007.tfc.client.model.entity.VaneModel;
import net.dries007.tfc.client.model.entity.WaterWheelModel;
import net.dries007.tfc.client.model.entity.WildebeestModel;
import net.dries007.tfc.client.model.entity.WindmillBladeLatticeModel;
import net.dries007.tfc.client.model.entity.WindmillBladeModel;
import net.dries007.tfc.client.model.entity.WindmillBladeRusticModel;
import net.dries007.tfc.client.model.entity.YakModel;
import net.dries007.tfc.client.overworld.LevelRendererExtension;
import net.dries007.tfc.client.overworld.StarsReloadListener;
import net.dries007.tfc.client.particle.AnimatedParticle;
import net.dries007.tfc.client.particle.BubbleParticle;
import net.dries007.tfc.client.particle.FallingLeafParticle;
import net.dries007.tfc.client.particle.FluidDripParticle;
import net.dries007.tfc.client.particle.GlintParticleProvider;
import net.dries007.tfc.client.particle.LeafParticle;
import net.dries007.tfc.client.particle.SleepParticle;
import net.dries007.tfc.client.particle.SparkParticle;
import net.dries007.tfc.client.particle.SteamParticle;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.client.particle.VariableHeightSmokeParticle;
import net.dries007.tfc.client.particle.WaterFlowParticle;
import net.dries007.tfc.client.particle.WindParticle;
import net.dries007.tfc.client.render.blockentity.AnemometerBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.AnvilBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.AxleBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.BarrelBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.BellowsBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.BladedAxleBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.BowlBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.CalendarClockBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.ChannelBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.CharcoalForgeBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.ChestItemRenderer;
import net.dries007.tfc.client.render.blockentity.CrankshaftBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.CrucibleBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.FirepitBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.GlassBasinBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.GrillBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.HotPouredGlassBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.JavelinItemRenderer;
import net.dries007.tfc.client.render.blockentity.LoomBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.MoldBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.NestBoxBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.PanItemRenderer;
import net.dries007.tfc.client.render.blockentity.PitKilnBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.PlacedItemBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.PotBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.QuernBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.SluiceBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TFCBellBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TFCChestBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TFCHangingSignBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TFCSignBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.ToolRackBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TripHammerBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.VaneBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.WaterWheelBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.WindmillBlockEntityRenderer;
import net.dries007.tfc.client.render.entity.AnimalRenderer;
import net.dries007.tfc.client.render.entity.DogRenderer;
import net.dries007.tfc.client.render.entity.GlowArrowRenderer;
import net.dries007.tfc.client.render.entity.JellyfishRenderer;
import net.dries007.tfc.client.render.entity.JerboaRenderer;
import net.dries007.tfc.client.render.entity.LemmingRenderer;
import net.dries007.tfc.client.render.entity.MongooseRenderer;
import net.dries007.tfc.client.render.entity.OctopoteuthisRenderer;
import net.dries007.tfc.client.render.entity.OviparousRenderer;
import net.dries007.tfc.client.render.entity.PenguinRenderer;
import net.dries007.tfc.client.render.entity.RatRenderer;
import net.dries007.tfc.client.render.entity.SimpleMobRenderer;
import net.dries007.tfc.client.render.entity.TFCBoatRenderer;
import net.dries007.tfc.client.render.entity.TFCCatRenderer;
import net.dries007.tfc.client.render.entity.TFCChestBoatRenderer;
import net.dries007.tfc.client.render.entity.TFCChestedHorseRenderer;
import net.dries007.tfc.client.render.entity.TFCFishingHookRenderer;
import net.dries007.tfc.client.render.entity.TFCHorseRenderer;
import net.dries007.tfc.client.render.entity.TFCSquidRenderer;
import net.dries007.tfc.client.render.entity.ThrownJavelinRenderer;
import net.dries007.tfc.client.screen.AnvilPlanScreen;
import net.dries007.tfc.client.screen.AnvilScreen;
import net.dries007.tfc.client.screen.BarrelScreen;
import net.dries007.tfc.client.screen.BlastFurnaceScreen;
import net.dries007.tfc.client.screen.CalendarScreen;
import net.dries007.tfc.client.screen.CharcoalForgeScreen;
import net.dries007.tfc.client.screen.ClimateScreen;
import net.dries007.tfc.client.screen.CreateTFCWorldScreen;
import net.dries007.tfc.client.screen.CrucibleScreen;
import net.dries007.tfc.client.screen.FireboxScreen;
import net.dries007.tfc.client.screen.FirepitScreen;
import net.dries007.tfc.client.screen.GrillScreen;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.client.screen.LargeVesselScreen;
import net.dries007.tfc.client.screen.MoldLikeAlloyScreen;
import net.dries007.tfc.client.screen.NestBoxScreen;
import net.dries007.tfc.client.screen.NutritionScreen;
import net.dries007.tfc.client.screen.PotScreen;
import net.dries007.tfc.client.screen.PowderkegScreen;
import net.dries007.tfc.client.screen.SaladScreen;
import net.dries007.tfc.client.screen.ScribingTableScreen;
import net.dries007.tfc.client.screen.SewingTableScreen;
import net.dries007.tfc.client.screen.SmallVesselInventoryScreen;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.blocks.plant.KrummholzBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.client.accessor.BiomeColorsAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.CodModel;
import net.minecraft.client.model.GoatModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.client.renderer.entity.CodRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.FrogRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.OcelotRenderer;
import net.minecraft.client.renderer.entity.PandaRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.renderer.entity.SalmonRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterPresetEditorsEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public final class ClientEventHandler {
    public static final ResourceLocation WATER_STILL = Helpers.identifierMC("block/water_still");
    public static final ResourceLocation WATER_FLOW = Helpers.identifierMC("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = Helpers.identifierMC("block/water_overlay");
    public static final ResourceLocation UNDERWATER_LOCATION = Helpers.identifierMC("textures/misc/underwater.png");
    public static final ResourceLocation MOLTEN_STILL = Helpers.identifier("block/molten_still");
    public static final ResourceLocation MOLTEN_FLOW = Helpers.identifier("block/molten_flow");
    private static final ResourceLocation SEALED = Helpers.identifier("sealed");

    public static void init(ModContainer mod, IEventBus bus) {
        bus.addListener(ClientEventHandler::clientSetup);
        bus.addListener(ClientEventHandler::registerMenuScreens);
        bus.addListener(ClientEventHandler::registerModelLoaders);
        bus.addListener(ClientEventHandler::registerSpecialModels);
        bus.addListener(ClientEventHandler::registerColorHandlerBlocks);
        bus.addListener(ClientEventHandler::registerColorHandlerItems);
        bus.addListener(ClientEventHandler::registerColorResolvers);
        bus.addListener(ClientEventHandler::registerParticleFactories);
        bus.addListener(ClientEventHandler::registerClientReloadListeners);
        bus.addListener(ClientEventHandler::registerEntityRenderers);
        bus.addListener(ClientEventHandler::registerTooltipFactories);
        bus.addListener(ClientEventHandler::registerKeyBindings);
        bus.addListener(ClientEventHandler::registerLayerDefinitions);
        bus.addListener(ClientEventHandler::registerPresetEditors);
        bus.addListener(ClientEventHandler::registerExtensions);
        bus.addListener(ClientEventHandler::registerDimensionEffects);
        bus.addListener(IngameOverlays::registerOverlays);
        mod.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (Metal metal : Metal.values()) {
                if (!metal.allParts()) continue;
                Item rod = (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)Metal.ItemType.FISHING_ROD).get();
                ItemProperties.register((Item)rod, (ResourceLocation)Helpers.identifier("cast"), (stack, level, entity, unused) -> {
                    Player player;
                    if (entity == null) {
                        return 0.0f;
                    }
                    return entity instanceof Player && TFCFishingRodItem.isThisTheHeldRod(player = (Player)entity, stack) && player.fishing != null ? 1.0f : 0.0f;
                });
                Item shield = (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)Metal.ItemType.SHIELD).get();
                ItemProperties.register((Item)shield, (ResourceLocation)Helpers.identifierMC("blocking"), (stack, level, entity, unused) -> {
                    if (entity == null) {
                        return 0.0f;
                    }
                    return entity instanceof Player && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
                });
                Item javelin = (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)Metal.ItemType.JAVELIN).get();
                ItemProperties.register((Item)javelin, (ResourceLocation)Helpers.identifier("throwing"), (stack, level, entity, unused) -> {
                    Monster monster;
                    return entity != null && (entity.isUsingItem() && entity.getUseItem() == stack || entity instanceof Monster && (monster = (Monster)entity).isAggressive()) ? 1.0f : 0.0f;
                });
            }
            TFCItems.ROCK_TOOLS.values().forEach(tool -> {
                Item javelin = (Item)((TFCItems.ItemId)tool.get((Object)RockCategory.ItemType.JAVELIN)).get();
                ItemProperties.register((Item)javelin, (ResourceLocation)Helpers.identifier("throwing"), (stack, level, entity, unused) -> {
                    Monster monster;
                    return entity != null && (entity.isUsingItem() && entity.getUseItem() == stack || entity instanceof Monster && (monster = (Monster)entity).isAggressive()) ? 1.0f : 0.0f;
                });
            });
            ItemProperties.register((Item)((Item)TFCItems.HANDSTONE.get()), (ResourceLocation)Helpers.identifier("damaged"), (stack, level, entity, unused) -> stack.getDamageValue() > stack.getMaxDamage() - 10 ? 1.0f : 0.0f);
            ClientEventHandler.registerSealedProperty(TFCBlocks.POWDERKEG, TFCComponents.CONTENTS);
            ClientEventHandler.registerSealedProperty(TFCBlocks.LARGE_VESSEL, TFCComponents.CONTENTS);
            TFCBlocks.GLAZED_LARGE_VESSELS.values().forEach(item -> ClientEventHandler.registerSealedProperty(item, TFCComponents.CONTENTS));
            TFCBlocks.WOODS.values().forEach(map -> ClientEventHandler.registerSealedProperty((ItemLike)map.get((Object)Wood.BlockType.BARREL), TFCComponents.BARREL));
            ItemProperties.register((Item)((Item)TFCItems.BLOWPIPE_WITH_GLASS.get()), (ResourceLocation)Helpers.identifier("heat"), (stack, level, entity, unused) -> Mth.clamp((float)(HeatCapability.getTemperature(stack) / Heat.maxVisibleTemperature()), (float)0.0f, (float)1.0f));
            ItemProperties.register((Item)((Item)TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.get()), (ResourceLocation)Helpers.identifier("heat"), (stack, level, entity, unused) -> Mth.clamp((float)(HeatCapability.getTemperature(stack) / Heat.maxVisibleTemperature()), (float)0.0f, (float)1.0f));
            TFCBlocks.WOODS.forEach((wood, map) -> {
                HorseChestLayer.registerChest(((Block)((TFCBlocks.Id)map.get((Object)Wood.BlockType.CHEST)).get()).asItem(), Helpers.identifier("textures/entity/chest/horse/" + wood.getSerializedName() + ".png"));
                HorseChestLayer.registerChest(((Block)((TFCBlocks.Id)map.get((Object)Wood.BlockType.TRAPPED_CHEST)).get()).asItem(), Helpers.identifier("textures/entity/chest/horse/" + wood.getSerializedName() + ".png"));
                HorseChestLayer.registerChest(((Block)((TFCBlocks.Id)map.get((Object)Wood.BlockType.BARREL)).get()).asItem(), Helpers.identifier("textures/entity/chest/horse/" + wood.getSerializedName() + "_barrel.png"));
            });
        });
        RenderType solid = RenderType.solid();
        RenderType cutout = RenderType.cutout();
        RenderType cutoutMipped = RenderType.cutoutMipped();
        RenderType translucent = RenderType.translucent();
        Predicate<RenderType> ghostBlock = rt -> rt == cutoutMipped || rt == Sheets.translucentCullBlockSheet();
        TFCBlocks.ROCK_BLOCKS.values().forEach(map -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((TFCBlocks.Id)map.get((Object)Rock.BlockType.SPIKE)).get()), (RenderType)cutout);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((TFCBlocks.Id)map.get((Object)Rock.BlockType.AQUEDUCT)).get()), (RenderType)cutout);
        });
        TFCBlocks.ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.GRADED_ORES.values().forEach(map -> map.values().forEach(inner -> inner.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout))));
        TFCBlocks.ORE_DEPOSITS.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.WOODS.values().forEach(map -> {
            Stream.of(Wood.BlockType.SAPLING, Wood.BlockType.DOOR, Wood.BlockType.TRAPDOOR, Wood.BlockType.FENCE, Wood.BlockType.FENCE_GATE, Wood.BlockType.BUTTON, Wood.BlockType.PRESSURE_PLATE, Wood.BlockType.SLAB, Wood.BlockType.STAIRS, Wood.BlockType.TWIG, Wood.BlockType.BARREL, Wood.BlockType.SCRIBING_TABLE, Wood.BlockType.SEWING_TABLE, Wood.BlockType.SHELF, Wood.BlockType.POTTED_SAPLING, Wood.BlockType.ENCASED_AXLE, Wood.BlockType.CLUTCH, Wood.BlockType.GEAR_BOX).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((TFCBlocks.Id)map.get(type)).get()), (RenderType)cutout));
            Stream.of(Wood.BlockType.LEAVES, Wood.BlockType.FALLEN_LEAVES).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((TFCBlocks.Id)map.get(type)).get()), (RenderType)cutoutMipped));
        });
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.TREE_ROOTS.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.PINE_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DOUGLAS_FIR_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.SPRUCE_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.WHITE_CEDAR_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.ASPEN_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POTTED_PINE_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POTTED_DOUGLAS_FIR_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POTTED_SPRUCE_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POTTED_WHITE_CEDAR_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POTTED_ASPEN_KRUMMHOLZ.get()), (RenderType)cutoutMipped);
        TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutoutMipped));
        TFCBlocks.SOIL.get((Object)SoilBlockType.CLAY_GRASS).values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutoutMipped));
        TFCBlocks.SOIL.get((Object)SoilBlockType.DUFF).values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutoutMipped));
        TFCBlocks.SOIL.get((Object)SoilBlockType.CLAY_DUFF).values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutoutMipped));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.PEAT_GRASS.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.KAOLIN_CLAY_GRASS.get()), (RenderType)cutoutMipped);
        TFCBlocks.METALS.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.GROUNDCOVER.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.SMALL_ORES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.CALCITE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.ICICLE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.SEA_ICE.get()), (RenderType)cutout);
        TFCBlocks.COLORED_POURED_GLASS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)translucent));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POURED_GLASS.get()), (RenderType)translucent);
        TFCBlocks.CROPS.values().forEach(reg -> {
            if (reg.get() instanceof IGhostBlockHandler) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (Predicate)ghostBlock);
            } else {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout);
            }
        });
        TFCBlocks.DEAD_CROPS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.WILD_CROPS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.PLANTS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.POTTED_PLANTS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.CORAL.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.SPREADING_BUSHES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        TFCBlocks.SPREADING_CANES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        TFCBlocks.STATIONARY_BUSHES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.CRANBERRY_BUSH.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_BERRY_BUSH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_CANE.get()), (RenderType)cutout);
        TFCBlocks.FRUIT_TREE_LEAVES.values().forEach(leaves -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)leaves.get()), (RenderType)cutoutMipped));
        TFCBlocks.FRUIT_TREE_SAPLINGS.values().forEach(leaves -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)leaves.get()), (RenderType)cutout));
        TFCBlocks.FRUIT_TREE_POTTED_SAPLINGS.values().forEach(leaves -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)leaves.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BANANA_PLANT.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_BANANA_PLANT.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BANANA_SAPLING.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BANANA_POTTED_SAPLING.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.FIREPIT.get()), ghostBlock);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.GRILL.get()), ghostBlock);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.POT.get()), ghostBlock);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.CERAMIC_BOWL.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.WALL_TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_WALL_TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.WATTLE.get()), ghostBlock);
        TFCBlocks.STAINED_WATTLE.values().forEach(wattle -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)wattle.get()), (Predicate)ghostBlock));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.UNSTAINED_WATTLE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.INGOT_PILE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DOUBLE_INGOT_PILE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.SCRAPING.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.STEEL_PIPE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.STEEL_PUMP.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.COMPOSTER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BLOOMERY.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.FIRE_BRICK_SHELF.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.FIREPROOF_DOOR.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.ICE_PILE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.LARGE_VESSEL.get()), (RenderType)cutout);
        TFCBlocks.GLAZED_LARGE_VESSELS.values().forEach(vessel -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)vessel.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SALT_WATER.getFlowing(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SALT_WATER.getSource(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SPRING_WATER.getFlowing(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SPRING_WATER.getSource(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)TFCFluids.RIVER_WATER.get()), (RenderType)translucent);
        BiomeColorsAccessor.accessor$setWaterColorsResolver(TFCColors.FRESH_WATER);
        for (Wood wood : Wood.VALUES) {
            Sheets.addWoodType((WoodType)wood.getVanillaWoodType());
        }
    }

    private static void registerSealedProperty(ItemLike item, Supplier<? extends DataComponentType<?>> type) {
        ItemProperties.register((Item)item.asItem(), (ResourceLocation)SEALED, (stack, level, entity, unused) -> stack.has(type) ? 1.0f : 0.0f);
    }

    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)TFCContainerTypes.CALENDAR.get(), CalendarScreen::new);
        event.register((MenuType)TFCContainerTypes.NUTRITION.get(), NutritionScreen::new);
        event.register((MenuType)TFCContainerTypes.CLIMATE.get(), ClimateScreen::new);
        event.register((MenuType)TFCContainerTypes.SALAD.get(), SaladScreen::new);
        event.register((MenuType)TFCContainerTypes.WORKBENCH.get(), CraftingScreen::new);
        event.register((MenuType)TFCContainerTypes.FIREPIT.get(), FirepitScreen::new);
        event.register((MenuType)TFCContainerTypes.GRILL.get(), GrillScreen::new);
        event.register((MenuType)TFCContainerTypes.POT.get(), PotScreen::new);
        event.register((MenuType)TFCContainerTypes.POWDERKEG.get(), PowderkegScreen::new);
        event.register((MenuType)TFCContainerTypes.CHARCOAL_FORGE.get(), CharcoalForgeScreen::new);
        event.register((MenuType)TFCContainerTypes.FIREBOX.get(), FireboxScreen::new);
        event.register((MenuType)TFCContainerTypes.NEST_BOX.get(), NestBoxScreen::new);
        event.register((MenuType)TFCContainerTypes.CRUCIBLE.get(), CrucibleScreen::new);
        event.register((MenuType)TFCContainerTypes.BARREL.get(), BarrelScreen::new);
        event.register((MenuType)TFCContainerTypes.ANVIL.get(), AnvilScreen::new);
        event.register((MenuType)TFCContainerTypes.ANVIL_PLAN.get(), AnvilPlanScreen::new);
        event.register((MenuType)TFCContainerTypes.BLAST_FURNACE.get(), BlastFurnaceScreen::new);
        event.register((MenuType)TFCContainerTypes.CHEST_9x2.get(), ContainerScreen::new);
        event.register((MenuType)TFCContainerTypes.CHEST_9x4.get(), ContainerScreen::new);
        event.register((MenuType)TFCContainerTypes.KNAPPING.get(), KnappingScreen::new);
        event.register((MenuType)TFCContainerTypes.SMALL_VESSEL_INVENTORY.get(), SmallVesselInventoryScreen::new);
        event.register((MenuType)TFCContainerTypes.MOLD_LIKE_ALLOY.get(), MoldLikeAlloyScreen::new);
        event.register((MenuType)TFCContainerTypes.LARGE_VESSEL.get(), LargeVesselScreen::new);
        event.register((MenuType)TFCContainerTypes.SCRIBING_TABLE.get(), ScribingTableScreen::new);
        event.register((MenuType)TFCContainerTypes.SEWING_TABLE.get(), SewingTableScreen::new);
    }

    public static void registerTooltipFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TooltipBlock.Instance.class, ClientInventoryTooltip::new);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(TFCKeyBindings.PLACE_BLOCK);
        event.register(TFCKeyBindings.CYCLE_CHISEL_MODE);
        event.register(TFCKeyBindings.STACK_FOOD);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TFCEntities.FALLING_BLOCK.get(), FallingBlockRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.FISHING_BOBBER.get(), TFCFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.THROWN_JAVELIN.get(), ThrownJavelinRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.GLOW_ARROW.get(), GlowArrowRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.SEAT.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.CHEST_MINECART.get(), ctx -> new MinecartRenderer(ctx, RenderHelpers.layerId("chest_minecart")));
        event.registerEntityRenderer((EntityType)TFCEntities.HOLDING_MINECART.get(), ctx -> new MinecartRenderer(ctx, RenderHelpers.layerId("holding_minecart")));
        for (Wood wood : Wood.VALUES) {
            event.registerEntityRenderer((EntityType)TFCEntities.BOATS.get(wood).get(), ctx -> new TFCBoatRenderer(ctx, wood.getSerializedName()));
            event.registerEntityRenderer((EntityType)TFCEntities.CHEST_BOATS.get(wood).get(), ctx -> new TFCChestBoatRenderer(ctx, wood.getSerializedName()));
        }
        event.registerEntityRenderer((EntityType)TFCEntities.COD.get(), CodRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.SALMON).get(), SalmonRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.LARGEMOUTH_BASS).get(), ctx -> new SimpleMobRenderer.Builder(ctx, CodModel::new, "largemouth_bass").flops().build());
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.SMALLMOUTH_BASS).get(), ctx -> new SimpleMobRenderer.Builder(ctx, CodModel::new, "smallmouth_bass").flops().build());
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.LAKE_TROUT).get(), ctx -> new SimpleMobRenderer.Builder(ctx, CodModel::new, "lake_trout").flops().build());
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.RAINBOW_TROUT).get(), ctx -> new SimpleMobRenderer.Builder(ctx, CodModel::new, "rainbow_trout").flops().build());
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.CRAPPIE).get(), ctx -> new SimpleMobRenderer.Builder(ctx, CodModel::new, "crappie").flops().build());
        event.registerEntityRenderer((EntityType)TFCEntities.FRESHWATER_FISH.get((Object)Fish.BLUEGILL).get(), ctx -> new SimpleMobRenderer.Builder(ctx, BluegillModel::new, "bluegill").flops().build());
        event.registerEntityRenderer((EntityType)TFCEntities.TROPICAL_FISH.get(), TropicalFishRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.PUFFERFISH.get(), PufferfishRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.JELLYFISH.get(), JellyfishRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.LOBSTER.get(), ctx -> new SimpleMobRenderer.Builder(ctx, LobsterModel::new, "lobster").build());
        event.registerEntityRenderer((EntityType)TFCEntities.CRAYFISH.get(), ctx -> new SimpleMobRenderer.Builder(ctx, LobsterModel::new, "crayfish").build());
        event.registerEntityRenderer((EntityType)TFCEntities.ISOPOD.get(), ctx -> new SimpleMobRenderer.Builder(ctx, IsopodModel::new, "isopod").build());
        event.registerEntityRenderer((EntityType)TFCEntities.HORSESHOE_CRAB.get(), ctx -> new SimpleMobRenderer.Builder(ctx, HorseshoeCrabModel::new, "horseshoe_crab").build());
        event.registerEntityRenderer((EntityType)TFCEntities.DOLPHIN.get(), DolphinRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.ORCA.get(), ctx -> new SimpleMobRenderer.Builder(ctx, OrcaModel::new, "orca").build());
        event.registerEntityRenderer((EntityType)TFCEntities.MANATEE.get(), ctx -> new SimpleMobRenderer.Builder(ctx, ManateeModel::new, "manatee").build());
        event.registerEntityRenderer((EntityType)TFCEntities.TURTLE.get(), ctx -> new SimpleMobRenderer.Builder(ctx, TFCTurtleModel::new, "turtle").build());
        event.registerEntityRenderer((EntityType)TFCEntities.PENGUIN.get(), PenguinRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.LEOPARD_SEAL.get(), ctx -> new SimpleMobRenderer.Builder(ctx, LeopardSealModel::new, "seal").build());
        event.registerEntityRenderer((EntityType)TFCEntities.FROG.get(), FrogRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.POLAR_BEAR.get(), ctx -> new SimpleMobRenderer.Builder(ctx, PolarBearModel::new, "polar_bear").shadow(0.9f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.GRIZZLY_BEAR.get(), ctx -> new SimpleMobRenderer.Builder(ctx, GrizzlyBearModel::new, "grizzly_bear").shadow(0.9f).scale(1.1f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.BLACK_BEAR.get(), ctx -> new SimpleMobRenderer.Builder(ctx, BlackBearModel::new, "black_bear").shadow(0.9f).scale(0.9f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.COUGAR.get(), ctx -> new SimpleMobRenderer.Builder(ctx, CougarModel::new, "cougar").shadow(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.PANTHER.get(), ctx -> new SimpleMobRenderer.Builder(ctx, CougarModel::new, "panther").shadow(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.LION.get(), ctx -> new SimpleMobRenderer.Builder(ctx, LionModel::new, "lion").shadow(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.SABERTOOTH.get(), ctx -> new SimpleMobRenderer.Builder(ctx, SabertoothModel::new, "sabertooth").shadow(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.TIGER.get(), ctx -> new SimpleMobRenderer.Builder(ctx, TigerModel::new, "tiger").shadow(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.CROCODILE.get(), ctx -> new SimpleMobRenderer.Builder(ctx, CrocodileModel::new, "crocodile").shadow(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.WOLF.get(), ctx -> new SimpleMobRenderer.Builder(ctx, TFCWolfModel::new, "wolf").shadow(0.5f).scale(1.1f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.HYENA.get(), ctx -> new SimpleMobRenderer.Builder(ctx, HyenaModel::new, "hyena").shadow(0.5f).scale(1.1f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.DIREWOLF.get(), ctx -> new SimpleMobRenderer.Builder(ctx, DirewolfModel::new, "direwolf").shadow(0.9f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.SQUID.get(), ctx -> new TFCSquidRenderer(ctx, new SquidModel(RenderHelpers.bakeSimple(ctx, "squid"))));
        event.registerEntityRenderer((EntityType)TFCEntities.OCTOPOTEUTHIS.get(), ctx -> new OctopoteuthisRenderer(ctx, (SquidModel<Octopoteuthis>)new SquidModel(RenderHelpers.bakeSimple(ctx, "glow_squid"))));
        event.registerEntityRenderer((EntityType)TFCEntities.PIG.get(), ctx -> new AnimalRenderer(ctx, new TFCPigModel(RenderHelpers.bakeSimple(ctx, "pig")), "pig"));
        event.registerEntityRenderer((EntityType)TFCEntities.COW.get(), ctx -> new AnimalRenderer(ctx, new TFCCowModel(RenderHelpers.bakeSimple(ctx, "cow")), "cow"));
        event.registerEntityRenderer((EntityType)TFCEntities.GOAT.get(), ctx -> new AnimalRenderer(ctx, new TFCGoatModel(RenderHelpers.bakeSimple(ctx, "goat")), "goat"));
        event.registerEntityRenderer((EntityType)TFCEntities.YAK.get(), ctx -> new AnimalRenderer(ctx, new YakModel(RenderHelpers.bakeSimple(ctx, "yak")), "yak"));
        event.registerEntityRenderer((EntityType)TFCEntities.ALPACA.get(), ctx -> new AnimalRenderer(ctx, new AlpacaModel(RenderHelpers.bakeSimple(ctx, "alpaca")), "alpaca"));
        event.registerEntityRenderer((EntityType)TFCEntities.SHEEP.get(), ctx -> new AnimalRenderer(ctx, new TFCSheepModel(RenderHelpers.bakeSimple(ctx, "sheep")), "sheep"));
        event.registerEntityRenderer((EntityType)TFCEntities.MUSK_OX.get(), ctx -> new AnimalRenderer(ctx, new MuskOxModel(RenderHelpers.bakeSimple(ctx, "musk_ox")), "musk_ox"));
        event.registerEntityRenderer((EntityType)TFCEntities.CHICKEN.get(), ctx -> new OviparousRenderer(ctx, new TFCChickenModel(RenderHelpers.bakeSimple(ctx, "chicken")), "chicken", "rooster", "chick"));
        event.registerEntityRenderer((EntityType)TFCEntities.DUCK.get(), ctx -> new OviparousRenderer(ctx, new DuckModel(RenderHelpers.bakeSimple(ctx, "duck")), "duck", "drake", "duckling"));
        event.registerEntityRenderer((EntityType)TFCEntities.QUAIL.get(), ctx -> new OviparousRenderer(ctx, new QuailModel(RenderHelpers.bakeSimple(ctx, "quail")), "quail", "quail_male", "quail_chick"));
        event.registerEntityRenderer((EntityType)TFCEntities.RABBIT.get(), RabbitRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.FOX.get(), FoxRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.PANDA.get(), PandaRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.OCELOT.get(), OcelotRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.BONGO.get(), ctx -> new SimpleMobRenderer.Builder(ctx, BongoModel::new, "bongo").shadow(0.6f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.CARIBOU.get(), ctx -> new SimpleMobRenderer.Builder(ctx, CaribouModel::new, "caribou").shadow(0.6f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.DEER.get(), ctx -> new SimpleMobRenderer.Builder(ctx, DeerModel::new, "deer").shadow(0.6f).hasBabyTexture().build());
        event.registerEntityRenderer((EntityType)TFCEntities.GAZELLE.get(), ctx -> new SimpleMobRenderer.Builder(ctx, GazelleModel::new, "gazelle").shadow(0.6f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.GROUSE.get(), ctx -> new SimpleMobRenderer.Builder(ctx, GrouseModel::new, "grouse").shadow(0.5f).texture(e -> RenderHelpers.getGenderedTexture(e, "grouse")).build());
        event.registerEntityRenderer((EntityType)TFCEntities.PHEASANT.get(), ctx -> new SimpleMobRenderer.Builder(ctx, PheasantModel::new, "pheasant").shadow(0.5f).texture(e -> RenderHelpers.getGenderedTexture(e, "pheasant")).build());
        event.registerEntityRenderer((EntityType)TFCEntities.TURKEY.get(), ctx -> new SimpleMobRenderer.Builder(ctx, TurkeyModel::new, "turkey").shadow(0.5f).texture(e -> RenderHelpers.getGenderedTexture(e, "turkey")).build());
        event.registerEntityRenderer((EntityType)TFCEntities.PEAFOWL.get(), ctx -> new SimpleMobRenderer.Builder(ctx, PeafowlModel::new, "peafowl").shadow(0.5f).texture(e -> RenderHelpers.getGenderedTexture(e, "peafowl")).build());
        event.registerEntityRenderer((EntityType)TFCEntities.MULE.get(), ctx -> new TFCChestedHorseRenderer(ctx, 0.92f, RenderHelpers.layerId("mule"), "mule"));
        event.registerEntityRenderer((EntityType)TFCEntities.DONKEY.get(), ctx -> new TFCChestedHorseRenderer(ctx, 0.87f, RenderHelpers.layerId("donkey"), "donkey"));
        event.registerEntityRenderer((EntityType)TFCEntities.HORSE.get(), TFCHorseRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.RAT.get(), RatRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.JERBOA.get(), JerboaRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.LEMMING.get(), LemmingRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.MONGOOSE.get(), MongooseRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.CAT.get(), TFCCatRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.DOG.get(), DogRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.BOAR.get(), ctx -> new SimpleMobRenderer.Builder(ctx, BoarModel::new, "boar").build());
        event.registerEntityRenderer((EntityType)TFCEntities.WILDEBEEST.get(), ctx -> new SimpleMobRenderer.Builder(ctx, WildebeestModel::new, "wildebeest").build());
        event.registerEntityRenderer((EntityType)TFCEntities.MOOSE.get(), ctx -> new SimpleMobRenderer.Builder(ctx, MooseModel::new, "moose").shadow(1.0f).scale(0.8f).build());
        event.registerEntityRenderer((EntityType)TFCEntities.BISON.get(), ctx -> new SimpleMobRenderer.Builder(ctx, BisonModel::new, "bison").build());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.FIREPIT.get(), ctx -> new FirepitBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.POT.get(), ctx -> new PotBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.GRILL.get(), ctx -> new GrillBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.PLACED_ITEM.get(), ctx -> new PlacedItemBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.PIT_KILN.get(), ctx -> new PitKilnBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SHELF.get(), ctx -> new PlacedItemBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.QUERN.get(), ctx -> new QuernBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CHEST.get(), TFCChestBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.TRAPPED_CHEST.get(), TFCChestBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.LOOM.get(), ctx -> new LoomBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SLUICE.get(), ctx -> new SluiceBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BELLOWS.get(), ctx -> new BellowsBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), ctx -> new ToolRackBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SIGN.get(), TFCSignBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.HANGING_SIGN.get(), TFCHangingSignBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BARREL.get(), ctx -> new BarrelBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CRUCIBLE.get(), ctx -> new CrucibleBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.LECTERN.get(), LecternRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.ANVIL.get(), ctx -> new AnvilBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get(), ctx -> new CharcoalForgeBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.NEST_BOX.get(), ctx -> new NestBoxBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BELL.get(), TFCBellBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BOWL.get(), ctx -> new BowlBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.HOT_POURED_GLASS.get(), ctx -> new HotPouredGlassBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.GLASS_BASIN.get(), ctx -> new GlassBasinBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.AXLE.get(), ctx -> new AxleBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BLADED_AXLE.get(), ctx -> new BladedAxleBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.TRIP_HAMMER.get(), ctx -> new TripHammerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.WATER_WHEEL.get(), WaterWheelBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.WINDMILL.get(), WindmillBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.VANE.get(), VaneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.ANEMOMETER.get(), AnemometerBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CRANKSHAFT.get(), ctx -> new CrankshaftBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BELL.get(), TFCBellBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CHANNEL.get(), ctx -> new ChannelBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.MOLD_TABLE.get(), ctx -> new MoldBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CALENDAR_CLOCK.get(), CalendarClockBlockEntityRenderer::new);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition boatLayer = BoatModel.createBodyModel();
        LayerDefinition raftLayer = RaftModel.createBodyModel();
        LayerDefinition chestLayer = ChestBoatModel.createBodyModel();
        LayerDefinition chestRaftLayer = ChestRaftModel.createBodyModel();
        for (Wood wood : Wood.VALUES) {
            event.registerLayerDefinition(TFCBoatRenderer.boatName(wood.getSerializedName()), wood == Wood.PALM ? () -> raftLayer : () -> boatLayer);
            event.registerLayerDefinition(TFCChestBoatRenderer.chestBoatName(wood.getSerializedName()), wood == Wood.PALM ? () -> chestRaftLayer : () -> chestLayer);
        }
        event.registerLayerDefinition(RenderHelpers.layerId("bluegill"), BluegillModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("crappie"), CodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("smallmouth_bass"), CodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("largemouth_bass"), CodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("rainbow_trout"), CodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("lake_trout"), CodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("jellyfish"), JellyfishModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("lobster"), LobsterModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("crayfish"), LobsterModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("horseshoe_crab"), HorseshoeCrabModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("isopod"), IsopodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("orca"), OrcaModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("manatee"), ManateeModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("turtle"), TFCTurtleModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("penguin"), PenguinModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("seal"), LeopardSealModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("polar_bear"), PolarBearModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("grizzly_bear"), GrizzlyBearModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("black_bear"), BlackBearModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("cougar"), CougarModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("panther"), CougarModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("lion"), LionModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("sabertooth"), SabertoothModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("tiger"), TigerModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("crocodile"), CrocodileModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("wolf"), TFCWolfModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("hyena"), HyenaModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("direwolf"), DirewolfModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("squid"), SquidModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("glow_squid"), SquidModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("pig"), () -> TFCPigModel.createTFCBodyLayer(CubeDeformation.NONE));
        event.registerLayerDefinition(RenderHelpers.layerId("cow"), TFCCowModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("goat"), GoatModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("yak"), YakModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("alpaca"), AlpacaModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("sheep"), TFCSheepModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("musk_ox"), MuskOxModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("chicken"), TFCChickenModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("duck"), DuckModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("quail"), QuailModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("bongo"), BongoModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("caribou"), CaribouModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("deer"), DeerModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("gazelle"), GazelleModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("moose"), MooseModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("grouse"), GrouseModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("pheasant"), PheasantModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("turkey"), TurkeyModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("peafowl"), PeafowlModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("rat"), RatModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("lemming"), LemmingModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("jerboa"), JerboaModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("mongoose"), MongooseModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("dog"), DogModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("cat"), () -> LayerDefinition.create((MeshDefinition)OcelotModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE), (int)64, (int)32));
        event.registerLayerDefinition(RenderHelpers.layerId("cat_collar"), () -> LayerDefinition.create((MeshDefinition)OcelotModel.createBodyMesh((CubeDeformation)new CubeDeformation(0.01f)), (int)64, (int)32));
        event.registerLayerDefinition(RenderHelpers.layerId("boar"), BoarModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("wildebeest"), WildebeestModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("bison"), BisonModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("javelin"), JavelinModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("chest_minecart"), MinecartModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("holding_minecart"), MinecartModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("bell_body"), BellRenderer::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("water_wheel"), WaterWheelModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("windmill_blade"), WindmillBladeModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("windmill_blade_lattice"), WindmillBladeLatticeModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("windmill_blade_rustic"), WindmillBladeRusticModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("horse_chest"), ChestedHorseModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("mule"), ChestedHorseModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("donkey"), ChestedHorseModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("water_wheel"), WaterWheelModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("vane"), VaneModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("anemometer"), AnemometerModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.layerId("calendar_clock"), CalendarClockModel::createBodyLayer);
    }

    public static void registerSpecialModels(ModelEvent.RegisterAdditional event) {
        for (String metal : new String[]{"native_copper", "native_silver", "native_gold", "cassiterite"}) {
            ClientEventHandler.register(event, Helpers.identifier("item/pan/" + metal + "/result"));
            for (Rock rock : Rock.values()) {
                ClientEventHandler.register(event, Helpers.identifier("item/pan/" + metal + "/" + rock.getSerializedName() + "_half"));
                ClientEventHandler.register(event, Helpers.identifier("item/pan/" + metal + "/" + rock.getSerializedName() + "_full"));
            }
        }
        PlacedItemBlockEntityRenderer.MODELS.forEach((item, model) -> event.register(model.model()));
        FirepitBlockEntityRenderer.BURN_STAGE_MODELS.values().forEach(list -> list.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0)));
        event.register(CrankshaftBlockEntityRenderer.WHEEL_MODEL);
        ResourceManager rm = Minecraft.getInstance().getResourceManager();
        Map resources = rm.listResources("models/block/mold", r -> r.getPath().endsWith(".json"));
        for (ResourceLocation model2 : resources.keySet()) {
            String path = model2.getPath();
            path = path.substring("models/".length(), path.length() - ".json".length());
            ClientEventHandler.register(event, ResourceLocation.fromNamespaceAndPath((String)model2.getNamespace(), (String)path));
        }
        TFCConfig.CLIENT.additionalSpecialModels.get().forEach(s -> ClientEventHandler.register(event, Helpers.resourceLocation(s)));
    }

    private static void register(ModelEvent.RegisterAdditional event, ResourceLocation id) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)id));
    }

    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(Helpers.identifier("fluid_container"), (IGeometryLoader)new ContainedFluidModel.Loader());
        event.register(Helpers.identifier("trim"), (IGeometryLoader)new TrimmedItemModel.Loader());
        event.register(Helpers.identifier("ingot_pile"), (IGeometryLoader)IngotPileBlockModel.INSTANCE);
        event.register(Helpers.identifier("double_ingot_pile"), (IGeometryLoader)DoubleIngotPileBlockModel.INSTANCE);
        event.register(Helpers.identifier("scraping"), (IGeometryLoader)ScrapingBlockModel.INSTANCE);
        event.register(Helpers.identifier("plant"), (IGeometryLoader)PlantBlockModel.Loader.INSTANCE);
        event.register(Helpers.identifier("mold"), (IGeometryLoader)new MoldsModelLoader());
    }

    public static void registerColorHandlerBlocks(RegisterColorHandlersEvent.Block event) {
        BlockColor grassColor = (state, level, pos, tintIndex) -> TFCColors.getGrassColor(pos, tintIndex);
        BlockColor tallGrassColor = (state, level, pos, tintIndex) -> TFCColors.getTallGrassColor(pos, tintIndex);
        BlockColor foliageColor = (state, level, pos, tintIndex) -> TFCColors.getFoliageColor(pos, tintIndex);
        BlockColor grassBlockColor = (state, level, pos, tintIndex) -> (Boolean)state.getValue((Property)ConnectedGrassBlock.SNOWY) != false || tintIndex != 1 ? -1 : grassColor.getColor(state, level, pos, tintIndex);
        BlockColor waterBlockColor = (state, level, pos, tintIndex) -> TFCColors.getWaterColor(pos);
        TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).values().forEach(reg -> event.register(grassBlockColor, new Block[]{(Block)reg.get()}));
        TFCBlocks.SOIL.get((Object)SoilBlockType.CLAY_GRASS).values().forEach(reg -> event.register(grassBlockColor, new Block[]{(Block)reg.get()}));
        event.register(grassBlockColor, new Block[]{(Block)TFCBlocks.PEAT_GRASS.get()});
        event.register(grassBlockColor, new Block[]{(Block)TFCBlocks.KAOLIN_CLAY_GRASS.get()});
        TFCBlocks.PLANTS.forEach((plant, reg) -> {
            if (plant.isBlockTinted()) {
                event.register(plant.usesWaterTint() ? waterBlockColor : (plant.isTallGrass() ? tallGrassColor : (plant.isSeasonal() ? (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, 145) : (plant.isFoliage() ? foliageColor : grassColor))), new Block[]{(Block)reg.get()});
            }
        });
        TFCBlocks.POTTED_PLANTS.forEach((plant, reg) -> {
            if (plant.isFlowerpotTinted()) {
                event.register(grassColor, new Block[]{(Block)reg.get()});
            }
        });
        TFCBlocks.WOODS.forEach((wood, reg) -> event.register(wood.isConifer() ? foliageColor : (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, wood.autumnIndex()), new Block[]{(Block)((TFCBlocks.Id)reg.get((Object)Wood.BlockType.LEAVES)).get()}));
        TFCBlocks.WOODS.forEach((wood, reg) -> event.register(wood.isConifer() ? ClientEventHandler.blockColor(13597971) : (state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, wood.autumnIndex()), new Block[]{(Block)((TFCBlocks.Id)reg.get((Object)Wood.BlockType.FALLEN_LEAVES)).get()}));
        event.register((state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.PINE.autumnIndex()), new Block[]{(Block)TFCBlocks.POTTED_PINE_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.DOUGLAS_FIR.autumnIndex()), new Block[]{(Block)TFCBlocks.POTTED_DOUGLAS_FIR_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.SPRUCE.autumnIndex()), new Block[]{(Block)TFCBlocks.POTTED_SPRUCE_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.WHITE_CEDAR.autumnIndex()), new Block[]{(Block)TFCBlocks.POTTED_WHITE_CEDAR_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.ASPEN.autumnIndex()), new Block[]{(Block)TFCBlocks.POTTED_ASPEN_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> (Boolean)state.getValue((Property)KrummholzBlock.SNOWY) != false ? -1 : TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.PINE.autumnIndex()), new Block[]{(Block)TFCBlocks.PINE_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> (Boolean)state.getValue((Property)KrummholzBlock.SNOWY) != false ? -1 : TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.DOUGLAS_FIR.autumnIndex()), new Block[]{(Block)TFCBlocks.DOUGLAS_FIR_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> (Boolean)state.getValue((Property)KrummholzBlock.SNOWY) != false ? -1 : TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.SPRUCE.autumnIndex()), new Block[]{(Block)TFCBlocks.SPRUCE_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> (Boolean)state.getValue((Property)KrummholzBlock.SNOWY) != false ? -1 : TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.WHITE_CEDAR.autumnIndex()), new Block[]{(Block)TFCBlocks.WHITE_CEDAR_KRUMMHOLZ.get()});
        event.register((state, level, pos, tintIndex) -> (Boolean)state.getValue((Property)KrummholzBlock.SNOWY) != false ? -1 : TFCColors.getSeasonalFoliageColor(pos, tintIndex, Wood.ASPEN.autumnIndex()), new Block[]{(Block)TFCBlocks.ASPEN_KRUMMHOLZ.get()});
        TFCBlocks.WILD_CROPS.forEach((crop, reg) -> event.register(grassColor, new Block[]{(Block)reg.get()}));
        event.register(waterBlockColor, new Block[]{(Block)TFCBlocks.SALT_WATER.get(), (Block)TFCBlocks.SEA_ICE.get(), (Block)TFCBlocks.RIVER_WATER.get()});
        event.register(ClientEventHandler.blockColor(6272440), new Block[]{(Block)TFCBlocks.SPRING_WATER.get()});
    }

    private static BlockColor blockColor(int color) {
        return (state, level, pos, tintIndex) -> color;
    }

    public static void registerColorResolvers(RegisterColorHandlersEvent.ColorResolvers event) {
        event.register(TFCColors.SALT_WATER);
        event.register(TFCColors.FRESH_WATER);
    }

    public static void registerColorHandlerItems(RegisterColorHandlersEvent.Item event) {
        ItemColor grassColor = (stack, tintIndex) -> TFCColors.getGrassColor(null, tintIndex);
        ItemColor seasonalFoliageColor = (stack, tintIndex) -> TFCColors.getFoliageColor(null, tintIndex);
        TFCBlocks.PLANTS.forEach((plant, reg) -> {
            if (plant.isItemTinted()) {
                event.register(plant.isSeasonal() ? seasonalFoliageColor : grassColor, new ItemLike[]{(ItemLike)reg.get()});
            }
        });
        TFCBlocks.WOODS.forEach((key, value) -> event.register(seasonalFoliageColor, new ItemLike[]{(ItemLike)((TFCBlocks.Id)value.get((Object)Wood.BlockType.FALLEN_LEAVES)).get(), (ItemLike)((TFCBlocks.Id)value.get((Object)Wood.BlockType.LEAVES)).get()}));
        TFCBlocks.WILD_CROPS.forEach((key, value) -> event.register(grassColor, new ItemLike[]{((Block)value.get()).asItem()}));
        event.register(seasonalFoliageColor, new ItemLike[]{((Block)TFCBlocks.PINE_KRUMMHOLZ.get()).asItem()});
        event.register(seasonalFoliageColor, new ItemLike[]{((Block)TFCBlocks.DOUGLAS_FIR_KRUMMHOLZ.get()).asItem()});
        event.register(seasonalFoliageColor, new ItemLike[]{((Block)TFCBlocks.WHITE_CEDAR_KRUMMHOLZ.get()).asItem()});
        event.register(seasonalFoliageColor, new ItemLike[]{((Block)TFCBlocks.SPRUCE_KRUMMHOLZ.get()).asItem()});
        event.register(seasonalFoliageColor, new ItemLike[]{((Block)TFCBlocks.ASPEN_KRUMMHOLZ.get()).asItem()});
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            if (!Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)fluid)).getNamespace().equals("tfc")) continue;
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{fluid.getBucket()});
        }
        TFCItems.MOLDS.values().forEach(reg -> event.register(ContainedFluidModel.COLOR, new ItemLike[]{(ItemLike)reg.get()}));
        event.register(ContainedFluidModel.COLOR, new ItemLike[]{(ItemLike)TFCItems.WOODEN_BUCKET.get(), (ItemLike)TFCItems.RED_STEEL_BUCKET.get(), (ItemLike)TFCItems.BLUE_STEEL_BUCKET.get(), (ItemLike)TFCItems.BELL_MOLD.get(), (ItemLike)TFCItems.FIRE_INGOT_MOLD.get(), (ItemLike)TFCItems.JUG.get(), (ItemLike)TFCItems.SILICA_GLASS_BOTTLE.get(), (ItemLike)TFCItems.HEMATITIC_GLASS_BOTTLE.get(), (ItemLike)TFCItems.VOLCANIC_GLASS_BOTTLE.get(), (ItemLike)TFCItems.OLIVINE_GLASS_BOTTLE.get()});
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setSkyColors, TFCColors.SKY_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFogColors, TFCColors.FOG_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setWaterColors, TFCColors.WATER_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setWaterFogColors, TFCColors.WATER_FOG_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setGrassColors, TFCColors.GRASS_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setTallGrassColors, TFCColors.TALL_GRASS_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFoliageColors, TFCColors.FOLIAGE_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFoliageFallColors, TFCColors.FOLIAGE_FALL_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFoliageWinterColors, TFCColors.FOLIAGE_WINTER_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new StarsReloadListener());
    }

    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)TFCParticles.BUBBLE.get(), BubbleParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.WATER_FLOW.get(), WaterFlowParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.STEAM.get(), SteamParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.NITROGEN.get(), set -> new GlintParticleProvider(set, ChatFormatting.AQUA));
        event.registerSpriteSet((ParticleType)TFCParticles.PHOSPHORUS.get(), set -> new GlintParticleProvider(set, ChatFormatting.GOLD));
        event.registerSpriteSet((ParticleType)TFCParticles.POTASSIUM.get(), set -> new GlintParticleProvider(set, ChatFormatting.LIGHT_PURPLE));
        event.registerSpriteSet((ParticleType)TFCParticles.COMPOST_READY.get(), set -> new GlintParticleProvider(set, ChatFormatting.GRAY));
        event.registerSpriteSet((ParticleType)TFCParticles.COMPOST_ROTTEN.get(), set -> new GlintParticleProvider(set, ChatFormatting.DARK_RED));
        event.registerSpriteSet((ParticleType)TFCParticles.SLEEP.get(), SleepParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.LEAF.get(), set -> new LeafParticle.Provider(set, true));
        event.registerSpriteSet((ParticleType)TFCParticles.SNOWFLAKE.get(), FallingLeafParticle.SimpleProvider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.FLYING_SNOWFLAKE.get(), WindParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.WIND.get(), WindParticle.Provider::new);
        event.registerSpriteSet((ParticleType)TFCParticles.FALLING_LEAF.get(), set -> new FallingLeafParticle.Provider(set, true));
        event.registerSpriteSet((ParticleType)TFCParticles.FEATHER.get(), set -> new LeafParticle.Provider(set, false));
        event.registerSpriteSet((ParticleType)TFCParticles.SPARK.get(), SparkParticle.Provider::new);
        TFCParticles.BUTTERFLIES.values().forEach(fly -> event.registerSpriteSet((ParticleType)fly.get(), AnimatedParticle.Provider::new));
        event.registerSpriteSet((ParticleType)TFCParticles.FLUID_DRIP.get(), set -> FluidDripParticle.provider(set, FluidDripParticle.FluidHangParticle::new));
        event.registerSpriteSet((ParticleType)TFCParticles.FLUID_FALL.get(), set -> FluidDripParticle.provider(set, FluidDripParticle.FluidFallAndLandParticle::new));
        event.registerSpriteSet((ParticleType)TFCParticles.FLUID_LAND.get(), set -> FluidDripParticle.provider(set, FluidDripParticle.FluidLandParticle::new));
        event.registerSpriteSet((ParticleType)TFCParticles.BARREL_DRIP.get(), set -> FluidDripParticle.provider(set, FluidDripParticle.BarrelDripParticle::new));
        for (int i = 0; i < 5; ++i) {
            int lifetime = i * 80 + 10;
            event.registerSpriteSet((ParticleType)TFCParticles.SMOKES.get(i).get(), set -> new VariableHeightSmokeParticle.Provider(set, lifetime));
        }
    }

    public static void registerPresetEditors(RegisterPresetEditorsEvent event) {
        event.register(TerraFirmaCraft.PRESET, CreateTFCWorldScreen::new);
    }

    public static void registerExtensions(RegisterClientExtensionsEvent event) {
        TFCItems.ROCK_TOOLS.values().forEach(map -> ClientEventHandler.registerCustomItemRenderer(event, (Supplier)map.get((Object)RockCategory.ItemType.JAVELIN), JavelinItemRenderer::new));
        TFCItems.METAL_ITEMS.values().forEach(map -> ClientEventHandler.registerCustomItemRenderer(event, (Supplier)map.get((Object)Metal.ItemType.JAVELIN), JavelinItemRenderer::new));
        TFCBlocks.WOODS.values().forEach(map -> ClientEventHandler.registerCustomItemRenderer(event, (Supplier)map.get((Object)Wood.BlockType.CHEST), ChestItemRenderer::new));
        TFCBlocks.WOODS.values().forEach(map -> ClientEventHandler.registerCustomItemRenderer(event, (Supplier)map.get((Object)Wood.BlockType.TRAPPED_CHEST), ChestItemRenderer::new));
        event.registerItem((IClientItemExtensions)ItemRendererExtension.cached((com.google.common.base.Supplier<BlockEntityWithoutLevelRenderer>)((com.google.common.base.Supplier)PanItemRenderer::new)), new Item[]{(Item)TFCItems.FILLED_PAN.get()});
        event.registerItem((IClientItemExtensions)BlowpipeExtension.INSTANCE, new Item[]{(Item)TFCItems.BLOWPIPE.get(), (Item)TFCItems.BLOWPIPE_WITH_GLASS.get(), (Item)TFCItems.CERAMIC_BLOWPIPE.get(), (Item)TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.get()});
        TFCFluids.METALS.forEach((metal, holder) -> event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(0xFF000000 | metal.getColor(), MOLTEN_STILL, MOLTEN_FLOW, null, null), new FluidType[]{holder.getType()}));
        TFCFluids.SIMPLE_FLUIDS.forEach((fluid, holder) -> event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(fluid.isTransparent() ? 0xFF000000 | fluid.getColor() : fluid.getColor(), WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), new FluidType[]{holder.getType()}));
        TFCFluids.COLORED_FLUIDS.forEach((color, holder) -> event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(color.getTextureDiffuseColor(), WATER_STILL, WATER_FLOW, WATER_OVERLAY, null), new FluidType[]{holder.getType()}));
        event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(-12618012, (level, pos) -> level.getBlockTint(pos, TFCColors.SALT_WATER) | 0xFF000000, WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), new FluidType[]{TFCFluids.SALT_WATER.getType()});
        event.registerFluidType((IClientFluidTypeExtensions)new FluidRendererExtension(-11613225, WATER_STILL, WATER_FLOW, WATER_OVERLAY, UNDERWATER_LOCATION), new FluidType[]{TFCFluids.SPRING_WATER.getType()});
    }

    private static <T> void registerCustomItemRenderer(RegisterClientExtensionsEvent event, @Nullable Supplier<? extends ItemLike> item, Function<T, BlockEntityWithoutLevelRenderer> renderer) {
        if (item != null) {
            event.registerItem((IClientItemExtensions)ItemRendererExtension.cached((com.google.common.base.Supplier<BlockEntityWithoutLevelRenderer>)((com.google.common.base.Supplier)() -> (BlockEntityWithoutLevelRenderer)renderer.apply(((ItemLike)item.get()).asItem()))), new Item[]{item.get().asItem()});
        }
    }

    public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(BuiltinDimensionTypes.OVERWORLD_EFFECTS, (DimensionSpecialEffects)LevelRendererExtension.INSTANCE);
    }
}

