/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.HoeOverlays;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.client.IngameOverlays;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCBubbleColumnAmbientSoundHandler;
import net.dries007.tfc.client.TFCKeyBindings;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.component.EggComponent;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.forge.ForgingBonusComponent;
import net.dries007.tfc.common.component.forge.ForgingCapability;
import net.dries007.tfc.common.component.glass.GlassWorking;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.items.EmptyPanItem;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.client.accessor.LocalPlayerAccessor;
import net.dries007.tfc.network.CycleChiselModePacket;
import net.dries007.tfc.network.PlaceBlockSpecialPacket;
import net.dries007.tfc.network.RequestClimateModelPacket;
import net.dries007.tfc.network.StackFoodPacket;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.PhysicalDamageType;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.Deposit;
import net.dries007.tfc.util.data.Fertilizer;
import net.dries007.tfc.util.data.Fuel;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ToastAddEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class ClientForgeEventHandler {
    private static float waterFogLevel = 1.0f;

    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(ClientForgeEventHandler::onRenderGameOverlayText);
        bus.addListener(ClientForgeEventHandler::onRenderGameOverlayPost);
        bus.addListener(ClientForgeEventHandler::onItemTooltip);
        bus.addListener(ClientForgeEventHandler::onInitGuiPost);
        bus.addListener(ClientForgeEventHandler::onClientPlayerLoggedIn);
        bus.addListener(ClientForgeEventHandler::onClientPlayerLoggedOut);
        bus.addListener(ClientForgeEventHandler::onClientTick);
        bus.addListener(ClientForgeEventHandler::onKeyEvent);
        bus.addListener(ClientForgeEventHandler::onScreenKey);
        bus.addListener(ClientForgeEventHandler::onHighlightBlockEvent);
        bus.addListener(ClientForgeEventHandler::onFogRender);
        bus.addListener(ClientForgeEventHandler::onHandRender);
        bus.addListener(ClientForgeEventHandler::onToast);
        bus.addListener(ClientForgeEventHandler::onEffectRender);
        bus.addListener(ClientForgeEventHandler::onRecipesUpdated);
        bus.addListener(IngameOverlays::checkGuiOverlays);
    }

    public static void onRenderGameOverlayText(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && TFCConfig.CLIENT.enableDebug.get().booleanValue()) {
            Entity camera = mc.getCameraEntity();
            assert (camera != null);
            BlockPos pos = BlockPos.containing((double)camera.getX(), (double)camera.getBoundingBox().minY, (double)camera.getZ());
            if (mc.level.hasChunk(pos.getX() >> 4, pos.getZ() >> 4)) {
                ChunkGenerator chunkGenerator;
                List tooltip = event.getLeft();
                tooltip.add("");
                tooltip.add(String.valueOf(ChatFormatting.AQUA) + "TerraFirmaCraft");
                tooltip.add("Date: %s Tick: %d Calendar: %d".formatted(Calendars.CLIENT.getTimeAndDate().getString(), Calendars.CLIENT.getTicks(), Calendars.CLIENT.getCalendarTicks()));
                tooltip.add("Temperature: Sea Level Avg: %.3f Avg: %.3f Now: %.3f".formatted(Float.valueOf(ClimateRenderCache.INSTANCE.getAverageSeaLevelTemperature()), Float.valueOf(ClimateRenderCache.INSTANCE.getAverageTemperature()), Float.valueOf(ClimateRenderCache.INSTANCE.getTemperature())));
                tooltip.add("Rain: Avg: %.3f Var: %.3f Now: %.3f".formatted(Float.valueOf(ClimateRenderCache.INSTANCE.getAverageRainfall()), Float.valueOf(ClimateRenderCache.INSTANCE.getRainVariance()), Float.valueOf(ClimateRenderCache.INSTANCE.getRainfall())));
                tooltip.add("Water: Avg: %.3f Base: %.3f Now: %.3f".formatted(Float.valueOf(ClimateRenderCache.INSTANCE.getAverageGroundwater()), Float.valueOf(ClimateRenderCache.INSTANCE.getBaseGroundwater()), Float.valueOf(ClimateRenderCache.INSTANCE.getGroundwater())));
                Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
                tooltip.add(Component.translatable((String)"tfc.tooltip.wind_speed", (Object[])new Object[]{Mth.floor((float)WeatherHelpers.windKMH(wind)), String.format("%.0f", Float.valueOf(Mth.abs((float)(wind.x * 100.0f)))), Helpers.translateEnum(wind.x > 0.0f ? Direction.EAST : Direction.WEST), String.format("%.0f", Float.valueOf(Mth.abs((float)(wind.y * 100.0f)))), Helpers.translateEnum(wind.y > 0.0f ? Direction.SOUTH : Direction.NORTH)}).getString());
                ChunkData data = ChunkData.get((LevelReader)mc.level, pos);
                if (data.status() == ChunkData.Status.CLIENT) {
                    tooltip.add("F: %s".formatted(data.getForestType().getSerializedName()));
                } else {
                    tooltip.add("[Waiting for chunk data]");
                }
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null && (chunkGenerator = server.overworld().getChunkSource().getGenerator()) instanceof ChunkGeneratorExtension) {
                    ChunkGeneratorExtension ex = (ChunkGeneratorExtension)chunkGenerator;
                    int approxSurfaceY = mc.level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
                    ex.chunkDataGenerator().displayDebugInfo(tooltip, pos, approxSurfaceY);
                }
            }
        }
    }

    public static void onRenderGameOverlayPost(RenderGuiLayerEvent.Post event) {
        GuiGraphics graphics = event.getGuiGraphics();
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null) {
            boolean holdingHoe;
            boolean bl = holdingHoe = Helpers.isItem(player.getMainHandItem().getItem(), (TagKey<Item>)ItemTags.HOES) || Helpers.isItem(player.getOffhandItem().getItem(), (TagKey<Item>)ItemTags.HOES);
            if (event.getName() == VanillaGuiLayers.CROSSHAIR && holdingHoe && (!TFCConfig.CLIENT.showHoeOverlaysOnlyWhenShifting.get().booleanValue() || player.isShiftKeyDown())) {
                HoeOverlays.render(minecraft, graphics);
            }
        }
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        if (!stack.isEmpty()) {
            HeatingRecipe recipe;
            Fertilizer fertilizer;
            MutableComponent heatTooltip;
            Fuel fuel;
            ItemSizeManager.addTooltipInfo(stack, tooltip);
            PhysicalDamageType.addTooltipInfo(stack, tooltip);
            ForgingBonusComponent.addTooltipInfo(stack, tooltip);
            ForgingCapability.addTooltipInfo(stack, tooltip);
            GlassWorking.addTooltipInfo(stack, tooltip);
            FoodCapability.addTooltipInfo(stack, tooltip::add);
            ((ItemListComponent)stack.getOrDefault(TFCComponents.INGREDIENTS, (Object)ItemListComponent.EMPTY)).addTooltipInfo(tooltip);
            ((EggComponent)stack.getOrDefault(TFCComponents.EGG, (Object)EggComponent.DEFAULT)).addTooltipInfo(tooltip::add);
            @Nullable IHeat heat = HeatCapability.get(stack);
            if (heat != null) {
                heat.addTooltipInfo(stack, tooltip::add);
            }
            if ((fuel = Fuel.get(stack)) != null && (heatTooltip = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(fuel.temperature())) != null) {
                tooltip.add(Component.translatable((String)"tfc.tooltip.fuel_burns_at", (Object[])new Object[]{heatTooltip, Calendars.CLIENT.getTimeDelta(fuel.duration())}));
            }
            if ((fertilizer = Fertilizer.get(stack)) != null) {
                float n = fertilizer.nitrogen();
                float p = fertilizer.phosphorus();
                float k = fertilizer.potassium();
                if (n != 0.0f) {
                    tooltip.add(Component.translatable((String)"tfc.tooltip.fertilizer.nitrogen", (Object[])new Object[]{String.format("%.1f", Float.valueOf(n * 100.0f))}));
                }
                if (p != 0.0f) {
                    tooltip.add(Component.translatable((String)"tfc.tooltip.fertilizer.phosphorus", (Object[])new Object[]{String.format("%.1f", Float.valueOf(p * 100.0f))}));
                }
                if (k != 0.0f) {
                    tooltip.add(Component.translatable((String)"tfc.tooltip.fertilizer.potassium", (Object[])new Object[]{String.format("%.1f", Float.valueOf(k * 100.0f))}));
                }
            }
            if ((recipe = HeatingRecipe.getRecipe(stack)) != null) {
                MutableComponent meltsInto;
                FluidStack fluid = recipe.assembleFluid(stack);
                fluid.setAmount(fluid.getAmount() * stack.getCount());
                if (!fluid.isEmpty() && (meltsInto = Tooltips.meltsInto(fluid, recipe.getTemperature())) != null) {
                    tooltip.add(meltsInto);
                }
            }
            if (Deposit.get(stack) != null) {
                tooltip.add(Component.translatable((String)"tfc.tooltip.usable_in_sluice_and_pan").withStyle(ChatFormatting.GRAY));
            }
            if (TFCConfig.CLIENT.enableDebug.get().booleanValue() && event.getFlags().isAdvanced()) {
                String blockTags;
                boolean first = true;
                for (TypedDataComponent component : stack.getComponents()) {
                    if (ClientForgeEventHandler.isIgnoredComponent(component)) continue;
                    if (first) {
                        tooltip.add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "[Debug] Components:")));
                        first = false;
                    }
                    tooltip.add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + ClientForgeEventHandler.typeOfComponent(stack.getComponentsPatch().get(component.type())) + String.valueOf(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)component.type())) + " = " + String.valueOf(component.value()))));
                }
                String itemTags = ClientForgeEventHandler.listOfTags(stack.getItem().builtInRegistryHolder());
                Item item = stack.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    v0 = ClientForgeEventHandler.listOfTags(blockItem.builtInRegistryHolder());
                } else {
                    v0 = blockTags = "";
                }
                if (!itemTags.isEmpty()) {
                    tooltip.add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "[Debug] Item Tags: " + itemTags)));
                }
                if (!blockTags.isEmpty()) {
                    tooltip.add(Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "[Debug] Block Tags: " + blockTags)));
                }
            }
        }
    }

    private static boolean isIgnoredComponent(TypedDataComponent<?> component) {
        return component.type() == DataComponents.REPAIR_COST && component.value().equals(0) || component.type() == DataComponents.ENCHANTMENTS || component.type() == DataComponents.ATTRIBUTE_MODIFIERS || component.type() == DataComponents.TOOL || component.type() == DataComponents.LORE || component.type() == DataComponents.RARITY;
    }

    private static String typeOfComponent(@Nullable Optional<?> optional) {
        return optional == null ? " " : (optional.isPresent() ? " ++ " : " -- ");
    }

    private static String listOfTags(Holder<?> holder) {
        return holder.tags().map(t1 -> "#" + String.valueOf(t1.location())).collect(Collectors.joining(", "));
    }

    public static void onInitGuiPost(ScreenEvent.Init.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (player != null && !player.isCreative()) {
                int guiLeft = screen2.getGuiLeft();
                int guiTop = screen2.getGuiTop();
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 173, 4, 23, 22, 148, 0, 1, 3, 0, 0, button -> {}).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 27, 20, 22, 128, 0, 1, 3, 32, 0, SwitchInventoryTabPacket.Tab.CALENDAR).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 50, 20, 22, 128, 0, 1, 3, 64, 0, SwitchInventoryTabPacket.Tab.NUTRITION).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 73, 20, 22, 128, 0, 1, 3, 96, 0, SwitchInventoryTabPacket.Tab.CLIMATE).setRecipeBookCallback(screen2));
                PatchouliIntegration.ifEnabled(() -> event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 96, 20, 22, 128, 0, 1, 3, 0, 32, SwitchInventoryTabPacket.Tab.BOOK).setRecipeBookCallback(screen2)));
            }
        }
    }

    public static void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        PacketDistributor.sendToServer((CustomPacketPayload)RequestClimateModelPacket.PACKET, (CustomPacketPayload[])new CustomPacketPayload[0]);
        LocalPlayer player = event.getPlayer();
        List<AmbientSoundHandler> handlers = ((LocalPlayerAccessor)player).accessor$getAmbientSoundHandlers();
        if (handlers.stream().noneMatch(handler -> handler instanceof TFCBubbleColumnAmbientSoundHandler)) {
            handlers.add(new TFCBubbleColumnAmbientSoundHandler(player));
        }
    }

    public static void onClientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() != null) {
            Calendars.CLIENT.resetToDefault();
            IndirectHashCollection.clearAllCaches();
        }
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        @Nullable ClientLevel level = Minecraft.getInstance().level;
        if (level != null && !Minecraft.getInstance().isPaused()) {
            Calendars.CLIENT.onClientTick();
            ClimateRenderCache.INSTANCE.onClientTick();
            ClientForgeEventHandler.tickWind();
        }
    }

    private static void tickWind() {
        if (!TFCConfig.CLIENT.enableWindParticles.get().booleanValue()) {
            return;
        }
        Level level = ClientHelpers.getLevel();
        Player player = ClientHelpers.getPlayer();
        if (player != null && level != null && level.getGameTime() % 2L == 0L) {
            double zBias;
            BlockPos pos = player.blockPosition();
            Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
            float windStrength = wind.length();
            int count = 0;
            if (windStrength > 0.07f) {
                count = (int)(windStrength * 8.0f);
            } else if (player.getVehicle() instanceof Boat) {
                count = 2;
            }
            if (count == 0) {
                return;
            }
            double xBias = wind.x > 0.0f ? 6.0 : -6.0;
            double d = zBias = wind.y > 0.0f ? 6.0 : -6.0;
            if (!(ClimateRenderCache.INSTANCE.getTemperature() > 0.0f) || !(level.getRainLevel(0.0f) > 0.0f)) {
                ParticleOptions particle = ClimateRenderCache.INSTANCE.getTemperature() < 0.0f && level.getRainLevel(0.0f) > 0.0f ? (ParticleOptions)TFCParticles.SNOWFLAKE.get() : (ParticleOptions)TFCParticles.WIND.get();
                for (int i = 0; i < count; ++i) {
                    double z;
                    double y;
                    double x = (double)pos.getX() + Mth.nextDouble((RandomSource)level.random, (double)(-12.0 - xBias), (double)(12.0 - xBias));
                    if (!level.canSeeSky(BlockPos.containing((double)x, (double)(y = (double)pos.getY() + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)6.0)), (double)(z = (double)pos.getZ() + Mth.nextDouble((RandomSource)level.random, (double)(-12.0 - zBias), (double)(12.0 - zBias)))))) continue;
                    level.addParticle(particle, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void onKeyEvent(InputEvent.Key event) {
        if (TFCKeyBindings.PLACE_BLOCK.isDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)PlaceBlockSpecialPacket.PACKET, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (TFCKeyBindings.CYCLE_CHISEL_MODE.isDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)CycleChiselModePacket.PACKET, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onScreenKey(ScreenEvent.KeyPressed.Pre event) {
        InventoryScreen inv;
        Slot slot;
        Screen screen;
        if (TFCKeyBindings.STACK_FOOD.isActiveAndMatches(InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode())) && (screen = event.getScreen()) instanceof InventoryScreen && (slot = (inv = (InventoryScreen)screen).getSlotUnderMouse()) != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new StackFoodPacket(slot.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onHighlightBlockEvent(RenderHighlightEvent.Block event) {
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        Entity entity = camera.getEntity();
        Level level = entity.level();
        BlockHitResult hit = event.getTarget();
        BlockPos pos = hit.getBlockPos();
        if (entity instanceof Player) {
            BlockEntity blockEntity;
            Player player = (Player)entity;
            BlockState stateAt = level.getBlockState(pos);
            Block blockAt = stateAt.getBlock();
            ChiselRecipe.computeResult(player, stateAt, hit, false).ifLeft(chiseled -> {
                IHighlightHandler.drawBox(poseStack, chiseled.getShape((BlockGetter)level, pos), event.getMultiBufferSource(), pos, camera.getPosition(), 1.0f, 0.0f, 0.0f, 0.4f);
                event.setCanceled(true);
            });
            if (blockAt instanceof IHighlightHandler) {
                IHighlightHandler handler = (IHighlightHandler)blockAt;
                if (handler.drawHighlight(level, pos, player, hit, poseStack, event.getMultiBufferSource(), camera.getPosition())) {
                    event.setCanceled(true);
                }
            } else if (blockAt instanceof IGhostBlockHandler) {
                IGhostBlockHandler handler = (IGhostBlockHandler)blockAt;
                if (handler.draw(level, player, stateAt, pos, hit.getLocation(), hit.getDirection(), event.getPoseStack(), event.getMultiBufferSource(), player.getMainHandItem())) {
                    event.setCanceled(true);
                }
            } else if (blockAt instanceof SluiceBlock && (blockEntity = level.getBlockEntity(pos)) instanceof SluiceBlockEntity) {
                BlockPos posAbove;
                BlockState stateAbove;
                SluiceBlockEntity sluice = (SluiceBlockEntity)blockEntity;
                BlockPos waterPos = sluice.getWaterOutputPos();
                if (!((Boolean)stateAt.getValue((Property)SluiceBlock.UPPER)).booleanValue()) {
                    waterPos = waterPos.relative(((Direction)stateAt.getValue((Property)SluiceBlock.FACING)).getOpposite());
                }
                if (!level.getBlockState(waterPos).canBeReplaced()) {
                    IHighlightHandler.drawBox(poseStack, Shapes.block(), event.getMultiBufferSource(), waterPos, camera.getPosition(), 0.0f, 0.0f, 1.0f, 0.4f);
                }
                if (!(stateAbove = level.getBlockState(posAbove = pos.above())).getFluidState().isEmpty()) {
                    IHighlightHandler.drawBox(poseStack, stateAbove.getFluidState().getShape((BlockGetter)level, posAbove), event.getMultiBufferSource(), posAbove, camera.getPosition(), 1.0f, 0.0f, 0.0f, 0.4f);
                }
            }
        }
    }

    public static void onFogRender(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && event.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            FogType fluid = event.getCamera().getFluidInCamera();
            BlockPos pos = event.getCamera().getBlockPosition();
            if (fluid == FogType.NONE) {
                float fog = Climate.get((Level)mc.level).getFog((LevelReader)mc.level, pos);
                if (fog != 0.0f) {
                    float renderDistance = mc.gameRenderer.getRenderDistance();
                    float density = renderDistance * (1.0f - Math.min(0.86f, fog));
                    event.setNearPlaneDistance(density - Mth.clamp((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f));
                    event.setFarPlaneDistance(density);
                    event.setCanceled(true);
                }
            } else if (fluid == FogType.WATER) {
                float fog;
                LocalPlayer player = mc.player;
                float f = fog = Helpers.isFluid(mc.level.getFluidState(pos), (Fluid)Fluids.WATER) ? Mth.clampedMap((float)mc.level.getRawBrightness(pos, 0), (float)0.0f, (float)15.0f, (float)0.6f, (float)1.0f) : 1.0f;
                if (fog != 1.0f) {
                    waterFogLevel = player != null && player.hasEffect(MobEffects.NIGHT_VISION) ? 1.0f : Mth.lerp((float)0.01f, (float)waterFogLevel, (float)fog);
                    event.scaleFarPlaneDistance(waterFogLevel);
                    event.setCanceled(true);
                } else {
                    waterFogLevel = 1.0f;
                }
            }
        }
    }

    public static void onHandRender(RenderHandEvent event) {
        Player player = ClientHelpers.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof PanItem || mainHand.getItem() instanceof EmptyPanItem) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                PoseStack poseStack = event.getPoseStack();
                poseStack.pushPose();
                RenderHelpers.renderTwoHandedItem(poseStack, event.getMultiBufferSource(), event.getPackedLight(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), mainHand);
                poseStack.popPose();
            }
            event.setCanceled(true);
        }
    }

    public static void onToast(ToastAddEvent event) {
        if (!TFCConfig.CLIENT.enableVanillaTutorialToasts.get().booleanValue() && event.getToast() instanceof TutorialToast) {
            event.setCanceled(true);
        }
    }

    public static void onEffectRender(ScreenEvent.RenderInventoryMobEffects event) {
        event.addHorizontalOffset(TFCConfig.CLIENT.effectHorizontalAdjustment.get().intValue());
    }

    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        Helpers.updateReloadableData(ClientHelpers.getLevelOrThrow().registryAccess(), event.getRecipeManager());
    }
}

