/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Objects;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.client.screen.PetCommandScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public final class ClientHelpers {
    public static final ResourceLocation GUI_ICONS = Helpers.identifier("textures/gui/icons.png");

    @Nullable
    public static RecipeManager tryGetSafeRecipeManager() {
        @Nullable Minecraft mc = Minecraft.getInstance();
        return mc != null && mc.level != null ? mc.level.getRecipeManager() : null;
    }

    @Nullable
    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static Level getLevelOrThrow() {
        return Objects.requireNonNull(ClientHelpers.getLevel());
    }

    @Nullable
    public static Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Player getPlayerOrThrow() {
        return Objects.requireNonNull(ClientHelpers.getPlayer());
    }

    public static boolean useFancyGraphics() {
        return Minecraft.useFancyGraphics();
    }

    @Nullable
    public static BlockPos getTargetedPos() {
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (hitResult = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult block = (BlockHitResult)hitResult;
            return block.getBlockPos();
        }
        return null;
    }

    public static boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    public static void openPetScreen(TamableMammal mammal) {
        Minecraft.getInstance().setScreen((Screen)new PetCommandScreen(mammal));
    }

    public static boolean inNorthernHemisphere() {
        Level level = ClientHelpers.getLevel();
        Player player = ClientHelpers.getPlayer();
        if (level != null && player != null) {
            BlockPos pos = player.blockPosition();
            return SolarCalculator.getInNorthernHemisphere(pos.getZ(), ClimateRenderCache.INSTANCE.getHemisphereScale());
        }
        return true;
    }

    @Nullable
    public static FogType getFluidInCamera(Camera camera) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        BlockPos pos = camera.getBlockPosition();
        FluidState state = level.getFluidState(pos);
        if (Helpers.isFluid(state, TFCTags.Fluids.ANY_INFINITE_WATER) && camera.getPosition().y < (double)((float)pos.getY() + state.getHeight((BlockGetter)level, pos))) {
            return FogType.WATER;
        }
        return null;
    }
}

