/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientInventoryTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = Helpers.identifier("textures/gui/device_image_tooltip.png");
    private final TooltipBlock.Instance tooltip;

    public ClientInventoryTooltip(TooltipBlock.Instance tooltip) {
        this.tooltip = tooltip;
    }

    public int getHeight() {
        return this.tooltip.height() * 18 + 6;
    }

    public int getWidth(Font font) {
        return this.tooltip.width() * 18 + 2;
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics graphics) {
        graphics.blit(TEXTURE_LOCATION, mouseX, mouseY + 2, 18 * this.tooltip.width() + 2, 18 * this.tooltip.width() + 2, 0.0f, 18.0f, 1, 1, 128, 128);
        for (int slot = 0; slot < this.tooltip.items().size(); ++slot) {
            int slotX = mouseX + slot % this.tooltip.width() * 18 + 1;
            int slotY = mouseY + slot / this.tooltip.width() * 18 + 3;
            ItemStack stack = this.tooltip.items().get(slot);
            graphics.blit(TEXTURE_LOCATION, slotX, slotY, 0, 0.0f, 0.0f, 18, 18, 128, 128);
            graphics.renderItem(stack, slotX + 1, slotY + 1, slot);
            graphics.renderItemDecorations(font, stack, slotX + 1, slotY + 1);
        }
    }
}

