/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.common.blocks.devices.ChannelBlock;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public final class RenderHelpers {
    public static final ResourceLocation BLOCKS_ATLAS = TextureAtlas.LOCATION_BLOCKS;
    public static final Button.CreateNarration NARRATION = Supplier::get;

    public static <K, V, S extends Supplier<? extends K>> Map<K, V> mapOf(Consumer<BiConsumer<S, V>> factory) {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        factory.accept((arg_0, arg_1) -> RenderHelpers.lambda$mapOf$0((Map)map, arg_0, arg_1));
        return map;
    }

    public static ModelResourceLocation modelId(String id) {
        return ModelResourceLocation.standalone((ResourceLocation)Helpers.identifier(id));
    }

    public static ModelResourceLocation modelId(ResourceLocation id) {
        return ModelResourceLocation.standalone((ResourceLocation)id);
    }

    public static ModelLayerLocation layerId(String name) {
        return RenderHelpers.layerId(name, "main");
    }

    public static ModelLayerLocation layerId(String name, String part) {
        return new ModelLayerLocation(Helpers.identifier(name), part);
    }

    public static TextureAtlasSprite missingTexture() {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(BLOCKS_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
    }

    public static TextureAtlasSprite blockTexture(ResourceLocation textureLocation) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(BLOCKS_ATLAS).apply(textureLocation);
    }

    public static ResourceLocation animalTexture(String name) {
        return Helpers.identifier("textures/entity/animal/" + name + ".png");
    }

    public static <T> ResourceLocation getGenderedTexture(GenderedRenderAnimal animal, String name) {
        return animal.displayMaleCharacteristics() ? RenderHelpers.animalTexture(name + "_male") : RenderHelpers.animalTexture(name + "_female");
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, AABB bounds) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, (float)bounds.minX, (float)bounds.minY, (float)bounds.minZ, (float)bounds.maxX, (float)bounds.maxY, (float)bounds.maxZ);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, AABB bounds, int color) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, (float)bounds.minX, (float)bounds.minY, (float)bounds.minZ, (float)bounds.maxX, (float)bounds.maxY, (float)bounds.maxZ, color);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ), true);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, boolean doShade) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ), doShade);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ), color);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float xPixels, float yPixels, float zPixels, boolean doShade) {
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getXVertices(minX, minY, minZ, maxX, maxY, maxZ), zPixels, yPixels, 1.0f, 0.0f, 0.0f, doShade);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getYVertices(minX, minY, minZ, maxX, maxY, maxZ), zPixels, xPixels, 0.0f, 1.0f, 0.0f, doShade);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getZVertices(minX, minY, minZ, maxX, maxY, maxZ), xPixels, yPixels, 0.0f, 0.0f, 1.0f, doShade);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float xPixels, float yPixels, float zPixels, int color) {
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getXVertices(minX, minY, minZ, maxX, maxY, maxZ), zPixels, yPixels, 1.0f, 0.0f, 0.0f, color);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getYVertices(minX, minY, minZ, maxX, maxY, maxZ), zPixels, xPixels, 0.0f, 1.0f, 0.0f, color);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getZVertices(minX, minY, minZ, maxX, maxY, maxZ), xPixels, yPixels, 0.0f, 0.0f, 1.0f, color);
    }

    public static void renderTexturedTrapezoidalCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY, float xPixels, float yPixels, float zPixels, boolean invertNormal) {
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidXVertices(pMinX, pMaxX, pMinZ, pMaxZ, qMinX, qMaxX, qMinZ, qMaxZ, minY, maxY), zPixels, yPixels, invertNormal ? 0.0f : 1.0f, 0.0f, invertNormal ? 1.0f : 0.0f, true);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidYVertices(pMinX, pMaxX, pMinZ, pMaxZ, qMinX, qMaxX, qMinZ, qMaxZ, minY, maxY), zPixels, xPixels, 0.0f, 1.0f, 0.0f, true);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidZVertices(pMinX, pMaxX, pMinZ, pMaxZ, qMinX, qMaxX, qMinZ, qMaxZ, minY, maxY), xPixels, yPixels, invertNormal ? 1.0f : 0.0f, 0.0f, invertNormal ? 0.0f : 1.0f, true);
    }

    public static void renderTexturedQuads(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float[][] vertices, float uSize, float vSize, float normalX, float normalY, float normalZ, boolean doShade) {
        for (float[] v : vertices) {
            RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.getU(v[3] * uSize * 1.0f / 16.0f), sprite.getV(v[4] * vSize * 1.0f / 16.0f), v[5] * normalX, v[5] * normalY, v[5] * normalZ, doShade);
        }
    }

    public static void renderTexturedQuads(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float[][] vertices, float uSize, float vSize, float normalX, float normalY, float normalZ, int color) {
        for (float[] v : vertices) {
            RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.getU(v[3] * uSize * 1.0f / 16.0f), sprite.getV(v[4] * vSize * 1.0f / 16.0f), v[5] * normalX, v[5] * normalY, v[5] * normalZ, color);
        }
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ) {
        RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, x, y, z, u, v, normalX, normalY, normalZ, true);
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, boolean doShade) {
        float shade = doShade ? RenderHelpers.getShade(normalX, normalY, normalZ) : 1.0f;
        int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)shade, (float)shade, (float)shade);
        RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, x, y, z, u, v, normalX, normalY, normalZ, color);
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int color) {
        buffer.addVertex(poseStack.last().pose(), x, y, z).setColor(color).setUv(u, v).setLight(packedLight).setOverlay(packedOverlay).setNormal(poseStack.last(), normalX, normalY, normalZ);
    }

    public static float getShade(float normalX, float normalY, float normalZ) {
        return RenderHelpers.getShadeForStep(Math.round(normalX), Math.round(normalY), Math.round(normalZ));
    }

    public static float getShadeForStep(int normalX, int normalY, int normalZ) {
        if (normalY == 1) {
            return 1.0f;
        }
        if (normalY == -1) {
            return 0.5f;
        }
        if (normalZ != 0) {
            return 0.8f;
        }
        if (normalX != 0) {
            return 0.6f;
        }
        return 1.0f;
    }

    public static float[][] getXVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{minX, minY, minZ, 0.0f, 1.0f, 1.0f}, {minX, minY, maxZ, 1.0f, 1.0f, 1.0f}, {minX, maxY, maxZ, 1.0f, 0.0f, 1.0f}, {minX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {maxX, minY, maxZ, 1.0f, 0.0f, -1.0f}, {maxX, minY, minZ, 0.0f, 0.0f, -1.0f}, {maxX, maxY, minZ, 0.0f, 1.0f, -1.0f}, {maxX, maxY, maxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getYVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{minX, maxY, minZ, 0.0f, 1.0f, 1.0f}, {minX, maxY, maxZ, 1.0f, 1.0f, 1.0f}, {maxX, maxY, maxZ, 1.0f, 0.0f, 1.0f}, {maxX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {minX, minY, maxZ, 1.0f, 0.0f, -1.0f}, {minX, minY, minZ, 0.0f, 0.0f, -1.0f}, {maxX, minY, minZ, 0.0f, 1.0f, -1.0f}, {maxX, minY, maxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getZVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{maxX, minY, minZ, 0.0f, 1.0f, 1.0f}, {minX, minY, minZ, 1.0f, 1.0f, 1.0f}, {minX, maxY, minZ, 1.0f, 0.0f, 1.0f}, {maxX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {minX, minY, maxZ, 1.0f, 0.0f, -1.0f}, {maxX, minY, maxZ, 0.0f, 0.0f, -1.0f}, {maxX, maxY, maxZ, 0.0f, 1.0f, -1.0f}, {minX, maxY, maxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getDiagonalPlaneVertices(float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2) {
        return new float[][]{{x1, y1, z1, u1, v1}, {x2, y1, z1, u2, v1}, {x2, y2, z2, u2, v2}, {x1, y2, z2, u1, v2}, {x2, y1, z1, u2, v1}, {x1, y1, z1, u1, v1}, {x1, y2, z2, u1, v2}, {x2, y2, z2, u2, v2}};
    }

    public static float[][] getTrapezoidalCuboidXVertices(float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY) {
        return new float[][]{{pMinX, minY, pMinZ, 0.0f, 1.0f, 1.0f}, {pMinX, minY, pMaxZ, 1.0f, 1.0f, 1.0f}, {qMinX, maxY, qMaxZ, 1.0f, 0.0f, 1.0f}, {qMinX, maxY, qMinZ, 0.0f, 0.0f, 1.0f}, {pMaxX, minY, pMaxZ, 1.0f, 0.0f, -1.0f}, {pMaxX, minY, pMinZ, 0.0f, 0.0f, -1.0f}, {qMaxX, maxY, qMinZ, 0.0f, 1.0f, -1.0f}, {qMaxX, maxY, qMaxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getTrapezoidalCuboidYVertices(float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY) {
        return new float[][]{{qMinX, maxY, qMinZ, 0.0f, 1.0f, 1.0f}, {qMinX, maxY, qMaxZ, 1.0f, 1.0f, 1.0f}, {qMaxX, maxY, qMaxZ, 1.0f, 0.0f, 1.0f}, {qMaxX, maxY, qMinZ, 0.0f, 0.0f, 1.0f}, {pMinX, minY, pMaxZ, 1.0f, 0.0f, -1.0f}, {pMinX, minY, pMinZ, 0.0f, 0.0f, -1.0f}, {pMaxX, minY, pMinZ, 0.0f, 1.0f, -1.0f}, {pMaxX, minY, pMaxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getTrapezoidalCuboidZVertices(float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY) {
        return new float[][]{{pMaxX, minY, pMinZ, 0.0f, 1.0f, 1.0f}, {pMinX, minY, pMinZ, 1.0f, 1.0f, 1.0f}, {qMinX, maxY, qMinZ, 1.0f, 0.0f, 1.0f}, {qMaxX, maxY, qMinZ, 0.0f, 0.0f, 1.0f}, {pMinX, minY, pMaxZ, 1.0f, 0.0f, -1.0f}, {pMaxX, minY, pMaxZ, 0.0f, 0.0f, -1.0f}, {qMaxX, maxY, qMaxZ, 0.0f, 1.0f, -1.0f}, {qMinX, maxY, qMaxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static void setShaderColor(int color) {
        RenderHelpers.setColor(RenderSystem::setShaderColor, color);
    }

    public static void setShaderColor(GuiGraphics graphics, int color) {
        RenderHelpers.setColor((arg_0, arg_1, arg_2, arg_3) -> ((GuiGraphics)graphics).setColor(arg_0, arg_1, arg_2, arg_3), color);
    }

    private static void setColor(ARGBColorProvider provider, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        provider.setColor(r, g, b, a);
    }

    public static void renderTwoHandedItem(PoseStack poseStack, MultiBufferSource source, int combinedLight, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        float swingSqrt = Mth.sqrt((float)swingProgress);
        float y = -0.2f * Mth.sin((float)(swingProgress * (float)Math.PI));
        float z = -0.4f * Mth.sin((float)(swingSqrt * (float)Math.PI));
        poseStack.translate(0.0, (double)(-y / 2.0f), (double)z);
        float tilt = RenderHelpers.calculateTilt(pitch);
        poseStack.translate(0.0, (double)(0.04f + equipProgress * -1.2f + tilt * -0.5f), (double)-0.72f);
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.clamp((float)tilt, (float)0.3f, (float)0.51f) * 85.0f));
        if (!mc.player.isInvisible()) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            RenderHelpers.renderMapHand(mc, poseStack, source, combinedLight, HumanoidArm.RIGHT);
            RenderHelpers.renderMapHand(mc, poseStack, source, combinedLight, HumanoidArm.LEFT);
            poseStack.popPose();
        }
        RenderHelpers.addSiftingMovement(mc.player, poseStack);
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(swingSqrt * (float)Math.PI)) * 20.0f));
        poseStack.scale(2.0f, 2.0f, 2.0f);
        boolean right = mc.player.getMainArm() == HumanoidArm.RIGHT;
        mc.getEntityRenderDispatcher().getItemInHandRenderer().renderItem((LivingEntity)mc.player, stack, right ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !right, poseStack, source, combinedLight);
    }

    public static void renderArmWithBlowpipe(PlayerItemInHandLayer<?, ?> layer, ItemInHandRenderer handRenderer, LivingEntity entity, ItemStack stack, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffers, int light) {
        poseStack.pushPose();
        ModelPart modelpart = ((HeadedModel)layer.getParentModel()).getHead();
        float f = modelpart.xRot;
        modelpart.xRot = Mth.clamp((float)modelpart.xRot, (float)-0.5235988f, (float)1.5707964f);
        modelpart.translateAndRotate(poseStack);
        modelpart.xRot = f;
        CustomHeadLayer.translateToHead((PoseStack)poseStack, (boolean)false);
        boolean lefty = arm == HumanoidArm.LEFT;
        poseStack.translate((lefty ? -2.3f : 2.3f) / 16.0f, -0.1625f, 0.0f);
        handRenderer.renderItem(entity, stack, ItemDisplayContext.HEAD, false, poseStack, buffers, light);
        poseStack.popPose();
    }

    public static ModelPart bakeSimple(EntityRendererProvider.Context context, String layerName) {
        return context.bakeLayer(RenderHelpers.layerId(layerName));
    }

    public static float itemTimeRotation() {
        return (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
    }

    public static int getHeatedBrightness(ItemStack stack, int combinedLight) {
        float heat = Math.min(HeatCapability.getTemperature(stack) / 400.0f, 1.0f);
        return Math.max(combinedLight, (int)(heat * 1.572888E7f));
    }

    public static int getFluidColor(FluidStack fluid) {
        return RenderHelpers.getFluidColor(fluid.getFluid());
    }

    public static int getFluidColor(Fluid fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }

    public static void renderFluidFace(PoseStack poseStack, FluidStack fluidStack, MultiBufferSource buffer, float minX, float minZ, float maxX, float maxZ, float y, int combinedOverlay, int combinedLight) {
        RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, RenderHelpers.getFluidColor(fluidStack), minX, minZ, maxX, maxZ, y, combinedOverlay, combinedLight);
    }

    public static void renderFluidFace(PoseStack poseStack, FluidStack fluidStack, MultiBufferSource buffers, int color, float minX, float minZ, float maxX, float maxZ, float y, int packedOverlay, int packedLight) {
        ResourceLocation texture = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(BLOCKS_ATLAS).apply(texture);
        VertexConsumer buffer = buffers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)BLOCKS_ATLAS));
        RenderHelpers.renderTexturedFace(poseStack.last(), buffer, color, minX, minZ, maxX, maxZ, y, packedOverlay, packedLight, sprite);
    }

    public static void renderTexturedFace(PoseStack poseStack, MultiBufferSource buffers, int color, float minX, float minZ, float maxX, float maxZ, float y, int packedOverlay, int packedLight, ResourceLocation texture) {
        VertexConsumer buffer = buffers.getBuffer(RenderType.solid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(BLOCKS_ATLAS).apply(texture);
        RenderHelpers.renderTexturedFace(poseStack.last(), buffer, color, minX, minZ, maxX, maxZ, y, packedOverlay, packedLight, sprite);
    }

    private static void renderTexturedFace(PoseStack.Pose pose, VertexConsumer buffer, int color, float minX, float minZ, float maxX, float maxZ, float y, int packedOverlay, int packedLight, TextureAtlasSprite sprite) {
        buffer.addVertex(pose, minX, y, minZ).setColor(color).setUv(sprite.getU(minX), sprite.getV(minZ)).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, minX, y, maxZ).setColor(color).setUv(sprite.getU(minX), sprite.getV(maxZ)).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, maxX, y, maxZ).setColor(color).setUv(sprite.getU(maxX), sprite.getV(maxZ)).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
        buffer.addVertex(pose, maxX, y, minZ).setColor(color).setUv(sprite.getU(maxX), sprite.getV(minX)).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public static boolean renderGhostBlock(Level level, BlockState state, BlockPos lookPos, PoseStack stack, MultiBufferSource buffer, boolean shouldGrowSlightly, int alpha) {
        Minecraft mc = Minecraft.getInstance();
        BlockModelShaper shaper = mc.getBlockRenderer().getBlockModelShaper();
        BakedModel model = shaper.getBlockModel(state);
        if (model == shaper.getModelManager().getMissingModel()) {
            return false;
        }
        RandomSource random = RandomSource.create();
        RenderType rt = Sheets.translucentCullBlockSheet();
        IGhostBlockHandler.ForcedAlphaVertexConsumer builder = new IGhostBlockHandler.ForcedAlphaVertexConsumer(buffer.getBuffer(rt), alpha);
        stack.pushPose();
        Vec3 camera = mc.gameRenderer.getMainCamera().getPosition();
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)lookPos).subtract(camera);
        stack.translate(offset.x, offset.y, offset.z);
        if (shouldGrowSlightly) {
            stack.translate(-0.005f, -0.005f, -0.005f);
            stack.scale(1.01f, 1.01f, 1.01f);
        }
        BlockRenderDispatcher br = Minecraft.getInstance().getBlockRenderer();
        for (RenderType type : model.getRenderTypes(state, random, ModelData.EMPTY)) {
            br.renderBatched(state, lookPos, (BlockAndTintGetter)level, stack, (VertexConsumer)builder, false, random, ModelData.EMPTY, type);
        }
        RenderSystem.enableCull();
        ((MultiBufferSource.BufferSource)buffer).endBatch(rt);
        stack.popPose();
        return true;
    }

    public static ResourceLocation getTextureForAge(TFCAnimal animal, ResourceLocation young, ResourceLocation old) {
        return animal.getAgeType() == Age.OLD ? old : young;
    }

    public static TextureAtlasSprite getAndBindFluidSprite(FluidStack fluid) {
        RenderHelpers.setShaderColor(RenderHelpers.getFluidColor(fluid));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid));
    }

    public static void fillAreaWithSprite(GuiGraphics stack, TextureAtlasSprite sprite, int x, int y, int regionWidth, int regionHeight, int spriteWidth, int spriteHeight) {
        int tileWidth = Helpers.ceilDiv(regionWidth, spriteWidth);
        int tileHeight = Helpers.ceilDiv(regionHeight, spriteHeight);
        for (int tileX = 0; tileX < tileWidth; ++tileX) {
            for (int tileY = 0; tileY < tileHeight; ++tileY) {
                int offsetX = tileX * spriteWidth;
                int offsetY = tileY * spriteHeight;
                int actualWidth = Math.min(spriteWidth, regionWidth - offsetX);
                int actualHeight = Math.min(spriteHeight, regionHeight - offsetY);
                float widthRatio = (float)actualWidth / (float)spriteWidth;
                float heightRatio = (float)actualHeight / (float)spriteHeight;
                RenderHelpers.blit(stack, x + offsetX, y + offsetY, actualWidth, actualHeight, sprite.getU0(), sprite.getU(widthRatio), sprite.getV0(), sprite.getV(heightRatio));
            }
        }
    }

    public static void blit(GuiGraphics stack, int x, int y, int width, int height, float minU, float maxU, float minV, float maxV) {
        RenderHelpers.blit(stack.pose().last().pose(), x, x + width, y, y + height, 0, minU, maxU, minV, maxV);
    }

    public static void blit(Matrix4f pose, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(pose, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        buffer.addVertex(pose, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        buffer.addVertex(pose, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        buffer.addVertex(pose, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static boolean isInside(int mouseX, int mouseY, int leftX, int topY, int width, int height) {
        return mouseX >= leftX && mouseX <= leftX + width && mouseY >= topY && mouseY <= topY + height;
    }

    private static float calculateTilt(float pitch) {
        float deg = Mth.clamp((float)(1.0f - pitch / 45.0f + 0.1f), (float)0.0f, (float)1.0f) * (float)Math.PI;
        return -Mth.cos((float)deg) * 0.5f + 0.5f;
    }

    private static void renderMapHand(Minecraft mc, PoseStack poseStack, MultiBufferSource source, int combinedLight, HumanoidArm arm) {
        assert (mc.player != null);
        PlayerRenderer playerRenderer = (PlayerRenderer)mc.getEntityRenderDispatcher().getRenderer((Entity)mc.player);
        poseStack.pushPose();
        float side = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(92.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        float degrees = side * -41.0f + RenderHelpers.calculateArmMovement(mc.player);
        poseStack.mulPose(Axis.ZP.rotationDegrees(degrees));
        poseStack.translate((double)side * 0.3, -1.1, 0.45);
        if (arm == HumanoidArm.RIGHT) {
            playerRenderer.renderRightHand(poseStack, source, combinedLight, (AbstractClientPlayer)mc.player);
        } else {
            playerRenderer.renderLeftHand(poseStack, source, combinedLight, (AbstractClientPlayer)mc.player);
        }
        poseStack.popPose();
    }

    private static void addSiftingMovement(LocalPlayer player, PoseStack stack) {
        float degrees = (float)player.getUseItemRemainingTicks() * (float)Math.PI / 10.0f;
        if (degrees > 0.0f) {
            float scale = 0.1f;
            stack.translate(0.1f * Mth.cos((float)degrees), 0.0f, 0.1f * Mth.sin((float)degrees));
        }
    }

    private static float calculateArmMovement(LocalPlayer player) {
        float degrees = (float)player.getUseItemRemainingTicks() * (float)Math.PI / 10.0f;
        if (degrees > 0.0f) {
            return 10.0f * Mth.cos((float)degrees);
        }
        return 0.0f;
    }

    public static void renderChannelFlow(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay, Pair<Direction, Byte> source, boolean renderFlowSource) {
        VoxelShape renderBox;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        Direction dir = (Direction)source.getLeft();
        switch (dir) {
            case UP: {
                renderBox = ChannelBlock.CHANNEL_FLOW_UP_SHAPE;
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            case EAST: {
                renderBox = renderFlowSource ? ChannelBlock.CHANNEL_FLOW_EAST_SHAPE_LONG : ChannelBlock.CHANNEL_FLOW_EAST_SHAPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot render source from direction DOWN");
            }
        }
        poseStack.translate(-0.5, 0.0, -0.5);
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, renderBox.bounds(), color);
        poseStack.popPose();
        poseStack.pushPose();
        block10: for (int offset = 1; offset < (Byte)source.getRight(); ++offset) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            switch (dir) {
                case UP: {
                    RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, ChannelBlock.CHANNEL_FLOW_LONG_FALL_SHAPE.bounds(), color);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Cannot render source from direction other than UP with source > 1 distance");
                }
            }
        }
        poseStack.popPose();
    }

    public static void renderChannelFlowCenter(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int color, int packedLight, int packedOverlay) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, ChannelBlock.CHANNEL_FLOW_CENTER_SHAPE.bounds(), color);
    }

    private static /* synthetic */ void lambda$mapOf$0(Map map, Supplier s, Object v) {
        map.put(s.get(), v);
    }

    static interface ARGBColorProvider {
        public void setColor(float var1, float var2, float var3, float var4);
    }
}

