/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public record ContainedFluidModel(Fluid fluid) implements IUnbakedGeometry<ContainedFluidModel>
{
    public static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    public static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    public static final ItemColor COLOR = (stack, tintIndex) -> {
        if (tintIndex != 1) {
            return -1;
        }
        FluidStack fluid = FluidHelpers.getContainedFluidInTank(stack);
        if (fluid.isEmpty()) {
            return -1;
        }
        return IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
    };

    public ContainedFluidModel withFluid(Fluid newFluid) {
        return new ContainedFluidModel(newFluid);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid") ? context.getMaterial("fluid") : null;
        Material coverLocation = context.hasMaterial("cover") ? context.getMaterial("cover") : null;
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.EMPTY ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && baseLocation != null ? spriteGetter.apply(coverLocation) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite == null ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, Helpers.identifier("block/empty"))) : fluidSprite;
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"dynamic_fluid_container"));
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseLocation != null) {
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)modelState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(FLUID_TRANSFORM), modelState.isUvLocked());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)templateSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState);
            boolean emissive = this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        if (coverSprite != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(COVER_TRANSFORM), modelState.isUvLocked());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (TextureAtlasSprite)coverSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)transformedState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<Fluid, BakedModel> cache = new Reference2ObjectOpenHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final ContainedFluidModel parent;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, ContainedFluidModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            FluidStack fluidStack = FluidHelpers.getContainedFluidInTank(stack);
            if (fluidStack.isEmpty()) {
                return originalModel;
            }
            Fluid fluid = fluidStack.getFluid();
            if (!this.cache.containsKey(fluid)) {
                ContainedFluidModel unbaked = this.parent.withFluid(fluid);
                BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                this.cache.put(fluid, bakedModel);
                return bakedModel;
            }
            return this.cache.get(fluid);
        }
    }

    public static class Loader
    implements IGeometryLoader<ContainedFluidModel> {
        public ContainedFluidModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new ContainedFluidModel(Fluids.EMPTY);
        }
    }
}

