/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import java.util.List;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IStaticBakedModel
extends IDynamicBakedModel {
    @NotNull
    default public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        StaticModelData property = (StaticModelData)data.get(StaticModelData.PROPERTY);
        if (property != null && side == null) {
            return property.quads();
        }
        return List.of();
    }

    default public TextureAtlasSprite getParticleIcon(ModelData data) {
        StaticModelData property = (StaticModelData)data.get(StaticModelData.PROPERTY);
        if (property != null) {
            return property.particleIcon();
        }
        return RenderHelpers.missingTexture();
    }

    default public TextureAtlasSprite getParticleIcon() {
        return RenderHelpers.missingTexture();
    }

    default public boolean useAmbientOcclusion() {
        return true;
    }

    default public boolean isGui3d() {
        return false;
    }

    default public boolean usesBlockLight() {
        return true;
    }

    default public boolean isCustomRenderer() {
        return false;
    }

    default public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public record StaticModelData(List<BakedQuad> quads, TextureAtlasSprite particleIcon) {
        public static final ModelProperty<StaticModelData> PROPERTY = new ModelProperty();
    }
}

