/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.overworld.ClientSolarCalculatorBridge;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.TopPlantBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class PlantBlockModel
implements IDynamicBakedModel,
IUnbakedGeometry<PlantBlockModel> {
    private final BlockModel dormant;
    private final BlockModel sprouting;
    private final BlockModel budding;
    private final BlockModel blooming;
    private final BlockModel seeding;
    private final BlockModel dying;
    @Nullable
    private BakedModel dormantBakedModel;
    @Nullable
    private BakedModel sproutingBakedModel;
    @Nullable
    private BakedModel buddingBakedModel;
    @Nullable
    private BakedModel bloomingBakedModel;
    @Nullable
    private BakedModel seedingBakedModel;
    @Nullable
    private BakedModel dyingBakedModel;

    public PlantBlockModel(BlockModel dormant, BlockModel sprouting, BlockModel budding, BlockModel blooming, BlockModel seeding, BlockModel dying) {
        this.dormant = dormant;
        this.sprouting = sprouting;
        this.budding = budding;
        this.blooming = blooming;
        this.seeding = seeding;
        this.dying = dying;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        return data.derive().with(BakedModelData.PROPERTY, (Object)new BakedModelData(this.getModelFromBlockState(state, pos))).build();
    }

    private BakedModel getModelFromBlockState(@Nullable BlockState state, @Nullable BlockPos pos) {
        float randomScale;
        RegistryPlant plant;
        if (pos == null) {
            pos = BlockPos.ZERO;
        }
        if (state == null) {
            return this.getModelFromCalendar();
        }
        Block block = state.getBlock();
        if (block instanceof PlantBlock) {
            plant = ((PlantBlock)block).getPlant();
        } else if (block instanceof BodyPlantBlock) {
            plant = ((BodyPlantBlock)block).getPlant();
        } else if (block instanceof TopPlantBlock) {
            plant = ((TopPlantBlock)block).getPlant();
        } else {
            return this.getModelFromCalendar();
        }
        float start = plant.getBloomOffset();
        Random random = new Random();
        Level level = ClientHelpers.getLevel();
        BlockPos posXZ = new BlockPos(pos.getX(), 0, pos.getZ());
        random.setSeed(Helpers.hash(836494186029734123L, posXZ));
        assert (level != null);
        if (plant.isWetSeasonBlooming()) {
            float rainVariance = Climate.getRainfallVariance(level, pos);
            randomScale = Mth.clampedMap((float)Math.abs(rainVariance), (float)0.0f, (float)0.3f, (float)0.5f, (float)0.03f);
            start += rainVariance < 0.0f ? 1.0f : 1.5f;
        } else {
            randomScale = Mth.clampedMap((float)Climate.getAverageTemperature(level, pos), (float)16.0f, (float)26.0f, (float)0.03f, (float)0.5f);
            start = ClientHelpers.inNorthernHemisphere() ? (start += 1.5f) : (start += 1.0f);
        }
        start = (start + random.nextFloat(-randomScale, randomScale)) % 1.0f;
        return this.getModelFromCalendar(start, start + plant.getBloomingEnd(), start + plant.getSeedingEnd(), start + plant.getDyingEnd(), start + plant.getDormantEnd(), start + plant.getSproutingEnd(), plant.getStartTime(), plant.getEndTime(), randomScale > 0.25f);
    }

    private BakedModel getModelFromCalendar() {
        return this.getModelFromCalendar(0.4f, 0.6f, 0.75f, 0.9f, 1.1f, 1.25f, 0, 0, false);
    }

    private BakedModel getModelFromCalendar(float bloomingStart, float bloomingEnd, float seedingEnd, float dyingEnd, float dormantEnd, float sproutingEnd, int startTime, int endTime, boolean nonDormant) {
        float adjustedTimeOfYear;
        float timeOfYear = Calendars.CLIENT.getCalendarFractionOfYear();
        float f = adjustedTimeOfYear = timeOfYear < bloomingStart ? timeOfYear + 1.0f : timeOfYear;
        if (adjustedTimeOfYear < bloomingEnd) {
            if (startTime != endTime) {
                return this.getModelByDayTime(startTime, endTime);
            }
            assert (this.bloomingBakedModel != null);
            return this.bloomingBakedModel;
        }
        if (adjustedTimeOfYear < seedingEnd) {
            assert (this.seedingBakedModel != null);
            return this.seedingBakedModel;
        }
        if (adjustedTimeOfYear < dyingEnd) {
            if (nonDormant) {
                assert (this.buddingBakedModel != null);
                return this.buddingBakedModel;
            }
            assert (this.dyingBakedModel != null);
            return this.dyingBakedModel;
        }
        if (adjustedTimeOfYear < dormantEnd) {
            if (nonDormant) {
                if (startTime != endTime) {
                    return this.getModelByDayTime(startTime, endTime);
                }
                assert (this.bloomingBakedModel != null);
                return this.bloomingBakedModel;
            }
            assert (this.dormantBakedModel != null);
            return this.dormantBakedModel;
        }
        if (adjustedTimeOfYear < sproutingEnd) {
            if (nonDormant) {
                assert (this.seedingBakedModel != null);
                return this.seedingBakedModel;
            }
            assert (this.sproutingBakedModel != null);
            return this.sproutingBakedModel;
        }
        assert (this.buddingBakedModel != null);
        return this.buddingBakedModel;
    }

    public BakedModel getModelByDayTime(int startTime, int endTime) {
        long dayTime;
        Level level = ClientHelpers.getLevel();
        if (level != null && ((long)endTime < (dayTime = ClientSolarCalculatorBridge.getDayTime((LevelAccessor)level)) && dayTime < (long)startTime || startTime < endTime && (dayTime < (long)startTime || (long)endTime < dayTime))) {
            assert (this.buddingBakedModel != null);
            return this.buddingBakedModel;
        }
        assert (this.bloomingBakedModel != null);
        return this.bloomingBakedModel;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> atlas, ModelState modelState, ItemOverrides overrides) {
        this.dormantBakedModel = this.dormant.bake(baker, atlas, modelState);
        this.sproutingBakedModel = this.sprouting.bake(baker, atlas, modelState);
        this.buddingBakedModel = this.budding.bake(baker, atlas, modelState);
        this.bloomingBakedModel = this.blooming.bake(baker, atlas, modelState);
        this.seedingBakedModel = this.seeding.bake(baker, atlas, modelState);
        this.dyingBakedModel = this.dying.bake(baker, atlas, modelState);
        return this;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData modelData, @Nullable RenderType renderType) {
        BakedModelData bakedData = (BakedModelData)modelData.get(BakedModelData.PROPERTY);
        if (bakedData != null) {
            return bakedData.toRender.getQuads(state, direction, random, modelData, renderType);
        }
        return this.getModelFromBlockState(state, null).getQuads(state, direction, random, modelData, renderType);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.dormant.resolveParents(modelGetter);
        this.sprouting.resolveParents(modelGetter);
        this.budding.resolveParents(modelGetter);
        this.blooming.resolveParents(modelGetter);
        this.seeding.resolveParents(modelGetter);
        this.dying.resolveParents(modelGetter);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.bloomingBakedModel != null ? this.bloomingBakedModel.getParticleIcon() : RenderHelpers.missingTexture();
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        BakedModelData bakedData = (BakedModelData)data.get(BakedModelData.PROPERTY);
        return bakedData != null ? bakedData.toRender.getParticleIcon(data) : RenderHelpers.missingTexture();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    record BakedModelData(BakedModel toRender) {
        public static final ModelProperty<BakedModelData> PROPERTY = new ModelProperty();
    }

    public static class Loader
    implements IGeometryLoader<PlantBlockModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public PlantBlockModel read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
            return new PlantBlockModel((BlockModel)context.deserialize(json.get("dormant"), BlockModel.class), (BlockModel)context.deserialize(json.get("sprouting"), BlockModel.class), (BlockModel)context.deserialize(json.get("budding"), BlockModel.class), (BlockModel)context.deserialize(json.get("blooming"), BlockModel.class), (BlockModel)context.deserialize(json.get("seeding"), BlockModel.class), (BlockModel)context.deserialize(json.get("dying"), BlockModel.class));
        }
    }
}

