/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;

public class AquaticCritterModel
extends HierarchicalAnimatedModel<AquaticCritter> {
    private final AnimationDefinition crawl;
    private final AnimationDefinition calm;
    private final AnimationDefinition swim;
    private final AnimationDefinition damage;

    public AquaticCritterModel(ModelPart root, AnimationDefinition crawl, AnimationDefinition calm, AnimationDefinition swim, AnimationDefinition damage) {
        super(root);
        this.crawl = crawl;
        this.calm = calm;
        this.swim = swim;
        this.damage = damage;
    }

    @Override
    public void setupAnim(AquaticCritter entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.hurtAnimation.isStarted()) {
            this.animate(entity.hurtAnimation, this.damage, ageInTicks);
        } else if (!entity.onGround()) {
            this.animateWalk(this.swim, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else if (entity.idleAnimation.isStarted()) {
            this.animate(entity.idleAnimation, this.calm, ageInTicks);
        } else {
            this.animateWalk(this.crawl, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        }
    }
}

