/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.client.model.entity.MooseModel;
import net.dries007.tfc.common.entities.prey.Prey;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class CaribouModel
extends HierarchicalAnimatedModel<Prey> {
    private final ModelPart head;

    public CaribouModel(ModelPart root) {
        super(root);
        this.head = root.getChild("caribou").getChild("body").getChild("neck").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition caribou = partdefinition.addOrReplaceChild("caribou", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)47.0f, (float)17.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition body = caribou.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -1.04f, 5.832f, 8.0f, 13.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-48.0f, (float)-2.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(21, 56).addBox(-1.0f, -38.4515f, 0.5567f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)35.0f, (float)-9.0f, (float)-0.3578f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 31).addBox(-5.0f, -48.0f, -1.0f, 10.0f, 15.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)46.0f, (float)26.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(34, 60).addBox(-3.0f, 2.7643f, 8.1755f, 5.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-4.7643f, (float)21.8245f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(30, 16).addBox(-0.4926f, 2.923f, -8.4288f, 0.0f, 9.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0074f, (float)6.5199f, (float)17.5063f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(10, 12).addBox(-2.6981f, -0.3506f, -5.9845f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.8535f, (float)-5.0215f, (float)4.8818f, (float)0.0243f, (float)-0.0913f, (float)-0.8601f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(29, 62).addBox(-0.3019f, -0.3506f, -5.9845f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8683f, (float)-5.0215f, (float)4.8818f, (float)0.0243f, (float)0.0913f, (float)0.8601f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -57.0f, 49.0f, 4.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(64, 60).addBox(-3.0f, -59.0f, 41.0f, 6.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4926f, (float)35.923f, (float)-60.4288f, (float)-0.3578f, (float)0.0f, (float)0.0f));
        PartDefinition rightAntler = head.addOrReplaceChild("rightAntler", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0148f, (float)-4.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = rightAntler.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(62, 60).addBox(-0.25f, -9.0f, 1.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 63).addBox(-0.25f, -8.0f, 0.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(5, 64).addBox(-0.25f, -7.0f, 2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(64, 44).addBox(-0.25f, -5.0f, 2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 31).addBox(-0.25f, -7.0f, -1.5f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3982f, (float)-0.2517f, (float)0.1407f));
        PartDefinition cube_r7 = rightAntler.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(59, 64).addBox(4.75f, -5.0f, -20.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(21, 65).addBox(4.75f, -8.0f, -20.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(4.75f, -12.0f, -18.75f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(4.75f, -13.0f, -16.75f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 60).addBox(4.75f, -10.0f, -17.75f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-1.75f, (float)-0.7091f, (float)-0.1449f, (float)-0.1313f));
        PartDefinition cube_r8 = rightAntler.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(52, 20).addBox(-0.25f, -16.25f, -11.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-1.75f, (float)-0.0651f, (float)-0.1608f, (float)0.1889f));
        PartDefinition cube_r9 = rightAntler.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(40, 40).addBox(-2.0f, -15.25f, 1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.9873f, (float)-0.19f, (float)0.4085f));
        PartDefinition cube_r10 = rightAntler.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(73, 0).addBox(0.0f, -5.0f, 3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(42, 13).addBox(0.0f, -4.0f, 1.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(34, 15).addBox(0.0f, -3.0f, 4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(0.0f, -1.0f, 4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(66, 25).addBox(0.0f, -3.0f, 2.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(0.0f, -3.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(60, 20).addBox(-1.0f, -5.0f, -4.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0426f, (float)-0.0094f, (float)0.3056f));
        PartDefinition leftAntler = head.addOrReplaceChild("leftAntler", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = leftAntler.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(0, 75).addBox(-0.75f, -9.0f, 1.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(17, 75).addBox(-0.75f, -8.0f, 0.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(25, 75).addBox(-0.75f, -7.0f, 2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(73, 77).addBox(-0.75f, -5.0f, 2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 56).addBox(-0.75f, -7.0f, -1.5f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3982f, (float)0.2517f, (float)-0.1407f));
        PartDefinition cube_r12 = leftAntler.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(74, 53).addBox(-5.75f, -5.0f, -20.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(73, 8).addBox(-5.75f, -8.0f, -20.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(6, 12).addBox(-5.75f, -12.0f, -18.75f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(13, 0).addBox(-5.75f, -13.0f, -16.75f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(61, 39).addBox(-5.75f, -10.0f, -17.75f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-1.75f, (float)-0.7091f, (float)0.1449f, (float)0.1313f));
        PartDefinition cube_r13 = leftAntler.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(54, 0).addBox(-1.75f, -16.25f, -11.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-1.75f, (float)-0.0651f, (float)0.1608f, (float)-0.1889f));
        PartDefinition cube_r14 = leftAntler.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, -15.25f, 1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.9873f, (float)0.19f, (float)-0.4085f));
        PartDefinition cube_r15 = leftAntler.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(73, 4).addBox(-1.0f, -5.0f, 3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(60, 27).addBox(-1.0f, -4.0f, 1.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(6, 56).addBox(-1.0f, -3.0f, 4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(64, 64).addBox(-1.0f, -1.0f, 4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(78, 39).addBox(-1.0f, -3.0f, 2.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(29, 56).addBox(-1.0f, -3.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(54, 60).addBox(-1.0f, -5.0f, -4.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0426f, (float)0.0094f, (float)-0.3056f));
        PartDefinition left_hind_leg = caribou.addOrReplaceChild("left_hind_leg", CubeListBuilder.create(), PartPose.offset((float)-7.0f, (float)-42.9634f, (float)9.8335f));
        PartDefinition cube_r16 = left_hind_leg.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(61, 77).addBox(-5.25f, -39.0f, -20.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)46.9634f, (float)17.1665f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = left_hind_leg.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(52, 0).addBox(-6.0f, -8.9699f, -7.5488f, 4.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)2.9634f, (float)-6.8335f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = caribou.addOrReplaceChild("left_front_leg", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-42.9128f, (float)24.7086f));
        PartDefinition bone3 = left_front_leg.addOrReplaceChild("bone3", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-2.0872f, (float)6.2914f));
        PartDefinition cube_r18 = bone3.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(60, 20).addBox(-6.0f, 26.9933f, -52.3053f, 4.0f, 6.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.0f, (float)49.0f, (float)26.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition bone5 = left_front_leg.addOrReplaceChild("bone5", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)46.9128f, (float)34.2914f));
        PartDefinition cube_r19 = bone5.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(0, 75).addBox(-5.0f, 32.0f, -38.0f, 3.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_leg = caribou.addOrReplaceChild("right_front_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-42.9128f, (float)24.7086f));
        PartDefinition bone4 = right_front_leg.addOrReplaceChild("bone4", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)-2.0872f, (float)5.2914f));
        PartDefinition cube_r20 = bone4.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(0, 56).addBox(-11.0f, 25.9933f, -52.3053f, 4.0f, 6.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)49.0f, (float)26.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition bone6 = right_front_leg.addOrReplaceChild("bone6", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)34.9128f, (float)6.2914f));
        PartDefinition cube_r21 = bone6.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(61, 39).addBox(2.0f, 32.0f, -38.0f, 3.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)12.0f, (float)28.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_back_leg = caribou.addOrReplaceChild("right_back_leg", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)-42.9634f, (float)9.8335f));
        PartDefinition cube_r22 = right_back_leg.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(34, 0).addBox(-9.75f, -39.0f, -20.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)46.9634f, (float)17.1665f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r23 = right_back_leg.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(40, 40).addBox(3.0f, -8.9699f, -7.5488f, 4.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)2.9634f, (float)-6.8335f, (float)-1.8326f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public void setupAnim(Prey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        float speed = this.getAdjustedLandSpeed(entity);
        if (speed > 1.1f) {
            this.animateWalk(MooseModel.MOOSE_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.animateWalk(MooseModel.MOOSE_WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        }
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
    }
}

