/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import java.util.stream.Stream;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.Prey;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DeerModel
extends HierarchicalAnimatedModel<Prey> {
    public static final AnimationDefinition DEER_RUN = AnimationDefinition.Builder.withLength((float)0.5f).looping().addAnimation("body", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.125f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.posVec((float)0.0f, (float)1.5f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.2083f, KeyframeAnimations.degreeVec((float)60.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("tail1", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167f, KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.0833f, KeyframeAnimations.degreeVec((float)-7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.3333f, KeyframeAnimations.degreeVec((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legFR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.0833f, KeyframeAnimations.degreeVec((float)-40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.2083f, KeyframeAnimations.degreeVec((float)-40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.degreeVec((float)25.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167f, KeyframeAnimations.degreeVec((float)25.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legFL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.0833f, KeyframeAnimations.degreeVec((float)-40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.2083f, KeyframeAnimations.degreeVec((float)-40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.degreeVec((float)25.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167f, KeyframeAnimations.degreeVec((float)25.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.0833f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.2083f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.degreeVec((float)-30.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.0833f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.2083f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.375f, KeyframeAnimations.degreeVec((float)-30.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.0833f, KeyframeAnimations.degreeVec((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.3333f, KeyframeAnimations.degreeVec((float)-7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    public static final AnimationDefinition DEER_WALK = AnimationDefinition.Builder.withLength((float)1.0f).looping().addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.2917f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.8333f, KeyframeAnimations.degreeVec((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.3333f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.8333f, KeyframeAnimations.degreeVec((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.3333f, KeyframeAnimations.degreeVec((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.625f, KeyframeAnimations.degreeVec((float)3.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167f, KeyframeAnimations.degreeVec((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)-27.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.1667f, KeyframeAnimations.degreeVec((float)-27.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.8333f, KeyframeAnimations.degreeVec((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legFR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.1667f, KeyframeAnimations.degreeVec((float)-27.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.7917f, KeyframeAnimations.degreeVec((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legFL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.4167f, KeyframeAnimations.degreeVec((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)-27.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    private final ModelPart head;
    private final ModelPart antler1;
    private final ModelPart antler2;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -18.0f, -9.0f, 6.0f, 8.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-15.0f, (float)-6.0f));
        PartDefinition neck0_r1 = neck.addOrReplaceChild("neck0_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5872f, -9.4021f, -1.1846f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0872f, (float)0.0038f, (float)-1.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0872f, -4.0038f, -4.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(29, 11).addBox(-1.5872f, -2.0038f, -7.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0872f, (float)-6.9962f, (float)-5.0f));
        PartDefinition earL = head.addOrReplaceChild("earL", CubeListBuilder.create().texOffs(41, 4).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)0.0f, (float)-0.0873f, (float)0.0175f, (float)0.1396f));
        PartDefinition earR = head.addOrReplaceChild("earR", CubeListBuilder.create().texOffs(10, 0).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-4.0f, (float)0.0f, (float)-0.0873f, (float)0.0175f, (float)-0.1396f));
        PartDefinition antlerL = head.addOrReplaceChild("antlerL", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)-4.0f, (float)-1.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition antler3_r1 = antlerL.addOrReplaceChild("antler3_r1", CubeListBuilder.create().texOffs(13, 14).addBox(-0.75f, -1.5f, -0.25f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-1.5f, (float)-2.5f, (float)0.2835f, (float)0.1153f, (float)-0.3762f));
        PartDefinition antler2_r1 = antlerL.addOrReplaceChild("antler2_r1", CubeListBuilder.create().texOffs(37, 0).addBox(-0.3645f, -0.3459f, -2.5216f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-1.0f, (float)-2.0f, (float)0.0303f, (float)-0.1698f, (float)-0.3406f));
        PartDefinition antler1_r1 = antlerL.addOrReplaceChild("antler1_r1", CubeListBuilder.create().texOffs(36, 25).addBox(-4.5f, -2.25f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0458f, (float)-0.6063f, (float)-0.241f));
        PartDefinition antler0_r1 = antlerL.addOrReplaceChild("antler0_r1", CubeListBuilder.create().texOffs(34, 41).addBox(-1.0f, -4.5f, 0.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3155f, (float)0.1624f, (float)-0.4068f));
        PartDefinition antlerL2 = head.addOrReplaceChild("antlerL2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.8257f, (float)-4.0f, (float)-1.5f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition antler3_r2 = antlerL2.addOrReplaceChild("antler3_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-0.25f, -1.5f, -0.25f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-1.5f, (float)-2.5f, (float)0.2835f, (float)-0.1153f, (float)0.3762f));
        PartDefinition antler2_r2 = antlerL2.addOrReplaceChild("antler2_r2", CubeListBuilder.create().texOffs(13, 25).addBox(-0.6355f, -0.3459f, -2.5216f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-1.0f, (float)-2.0f, (float)0.0303f, (float)0.1698f, (float)0.3406f));
        PartDefinition antler1_r2 = antlerL2.addOrReplaceChild("antler1_r2", CubeListBuilder.create().texOffs(0, 15).addBox(0.5f, -2.25f, 0.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0458f, (float)0.6063f, (float)0.241f));
        PartDefinition antler0_r2 = antlerL2.addOrReplaceChild("antler0_r2", CubeListBuilder.create().texOffs(38, 27).addBox(0.0f, -4.5f, 0.0f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3155f, (float)-0.1624f, (float)0.4068f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(38, 8).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.0f, (float)8.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition legBR = body.addOrReplaceChild("legBR", CubeListBuilder.create().texOffs(29, 0).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 36).addBox(-1.0f, 5.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)5.0f));
        PartDefinition legBL = body.addOrReplaceChild("legBL", CubeListBuilder.create().texOffs(18, 25).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(8, 35).addBox(-1.0f, 5.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)5.0f));
        PartDefinition legFR = body.addOrReplaceChild("legFR", CubeListBuilder.create().texOffs(35, 34).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(30, 25).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)-6.0f));
        PartDefinition legFL = body.addOrReplaceChild("legFL", CubeListBuilder.create().texOffs(0, 35).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 37).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public DeerModel(ModelPart root) {
        super(root);
        this.head = root.getChild("body").getChild("neck").getChild("head");
        this.antler1 = this.head.getChild("antlerL");
        this.antler2 = this.head.getChild("antlerL2");
    }

    @Override
    public void setupAnim(Prey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        boolean antlers = entity.displayMaleCharacteristics();
        Stream.concat(this.antler1.getAllParts(), this.antler2.getAllParts()).forEach(p -> {
            p.visible = antlers;
        });
        float speed = this.getAdjustedLandSpeed(entity);
        if (speed > 1.1f) {
            this.animateWalk(DEER_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.animateWalk(DEER_WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        }
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
    }
}

