/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DuckModel
extends AgeableListModel<OviparousAnimal> {
    private final ModelPart body;
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart wingR;
    private final ModelPart wingL;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -9.0f, -5.0f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(9, 15).addBox(-2.0f, -9.0f, 4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition legR = body.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, 3.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-3.0f, (float)0.0f));
        PartDefinition legL = body.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-1.0f, 3.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-3.0f, (float)0.0f));
        PartDefinition wingR = body.addOrReplaceChild("wingR", CubeListBuilder.create().texOffs(0, 15).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-9.0f, (float)-2.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 27).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-7.0f, (float)-4.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(21, 0).addBox(-1.5f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(25, 15).addBox(-1.0f, -2.0f, -5.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.75f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = body.addOrReplaceChild("wingL", CubeListBuilder.create().texOffs(16, 15).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-9.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public DuckModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 18.0f);
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.legL = this.body.getChild("legL");
        this.legR = this.body.getChild("legR");
        this.wingL = this.body.getChild("wingL");
        this.wingR = this.body.getChild("wingR");
    }

    public void setupAnim(OviparousAnimal duck, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.head.xRot = headPitch * 0.01308997f;
        this.neck.xRot = headPitch * 0.004363323f;
        this.head.yRot = headYaw * ((float)Math.PI / 360);
        this.neck.yRot = headYaw * ((float)Math.PI / 360);
        this.legR.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legL.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.wingR.zRot = 0.0f;
        this.wingL.zRot = 0.0f;
        if (!duck.isInWater()) {
            this.body.zRot = Mth.cos((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.3f * limbSwingAmount;
            this.neck.zRot = Mth.cos((float)(limbSwing * 0.6662f + 1.5707964f)) * -0.25f * limbSwingAmount;
            if (!duck.onGround()) {
                this.wingR.zRot = ageInTicks;
                this.wingL.zRot = -ageInTicks;
            }
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

