/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.DirewolfModel;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class HyenaModel
extends HierarchicalAnimatedModel<PackPredator> {
    private final ModelPart head;
    private final ModelPart neck;
    public static final AnimationDefinition HYENA_SLEEP = AnimationDefinition.Builder.withLength((float)4.68f).looping().addAnimation("body", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)-6.25f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.32f, KeyframeAnimations.degreeVec((float)10.35f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.44f, KeyframeAnimations.degreeVec((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(4.68f, KeyframeAnimations.degreeVec((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)9.97f, (float)2.05f, (float)-1.43f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.44f, KeyframeAnimations.degreeVec((float)9.97f, (float)-2.05f, (float)1.43f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("tail1", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)20.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(2.44f, KeyframeAnimations.degreeVec((float)0.0f, (float)-25.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(4.68f, KeyframeAnimations.degreeVec((float)0.0f, (float)20.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legFR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-77.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legFL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-80.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBL", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)-5.25f, (float)6.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBR", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)-6.25f, (float)5.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legBR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();

    public HyenaModel(ModelPart root) {
        super(root);
        this.head = root.getChild("body").getChild("neck").getChild("head");
        this.neck = root.getChild("body").getChild("neck");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, -14.0f, 2.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)26.0f, (float)-2.0f));
        PartDefinition frillC_r1 = body.addOrReplaceChild("frillC_r1", CubeListBuilder.create().texOffs(0, 35).addBox(-0.01f, -17.25f, -6.75f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(10, 35).addBox(0.49f, -16.25f, -6.75f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(36, 7).addBox(-0.49f, -16.25f, -6.75f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -0.25f, -7.0f, 7.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)2.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(36, 21).addBox(-1.5f, -1.0086f, -2.8695f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(36, 36).addBox(-0.5f, -3.0f, -4.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(9, 22).addBox(0.0f, -4.0f, -5.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 34).addBox(0.5f, -3.0f, -4.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.75f, (float)-5.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(22, 24).addBox(-2.0f, -3.0f, -3.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 0).addBox(-1.5f, -1.0f, -5.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.2414f, (float)-3.3695f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(22, 0).addBox(-1.5f, -0.2462f, -1.9052f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)1.0f, (float)-3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition earL = head.addOrReplaceChild("earL", CubeListBuilder.create().texOffs(0, 3).addBox(-1.0f, -1.75f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-2.5f, (float)-0.5f, (float)0.0f, (float)-0.1745f, (float)-0.1745f));
        PartDefinition earR = head.addOrReplaceChild("earR", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.25f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.1745f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(39, 14).addBox(-1.0f, -0.6005f, 0.058f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)8.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = tail.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(38, 5).addBox(-1.01f, 0.0358f, -0.3156f, 2.02f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.6005f, (float)3.058f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition legFR = body.addOrReplaceChild("legFR", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, 1.0f, -1.0f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-12.0f, (float)-3.0f));
        PartDefinition legFL = body.addOrReplaceChild("legFL", CubeListBuilder.create().texOffs(27, 12).addBox(-3.0f, 1.0f, -1.0f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-12.0f, (float)-3.0f));
        PartDefinition legBL = body.addOrReplaceChild("legBL", CubeListBuilder.create().texOffs(36, 30).addBox(-2.0f, 7.0f, -1.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 33).addBox(-1.0f, 2.0f, -2.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-15.0f, (float)6.0f));
        PartDefinition legBR = body.addOrReplaceChild("legBR", CubeListBuilder.create().texOffs(12, 31).addBox(0.0f, 7.0f, -2.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(30, 0).addBox(0.0f, 2.0f, -3.0f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-15.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(PackPredator predator, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch) {
        super.setupAnim(predator, limbSwing, limbSwingAmount, ageInTicks, yaw, pitch);
        if (predator.sleepingAnimation.isStarted()) {
            this.animate(predator.sleepingAnimation, HYENA_SLEEP, ageInTicks);
        } else {
            if (predator.isInWaterOrBubble()) {
                this.animateWalk(DirewolfModel.DIREWOLF_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
            } else {
                if (predator.isAggressive() && EntityHelpers.isMovingOnLand((Entity)predator)) {
                    this.animateWalk(DirewolfModel.DIREWOLF_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
                } else {
                    this.animateWalk(DirewolfModel.DIREWOLF_WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
                }
                this.animate(predator.attackingAnimation, DirewolfModel.DIREWOLF_ATTACK, ageInTicks);
            }
            this.head.xRot = pitch * (float)Math.PI / 180.0f;
            this.head.yRot = yaw * (float)Math.PI / 360.0f;
            this.neck.yRot = yaw * (float)Math.PI / 360.0f;
        }
    }
}

