/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.common.entities.aquatic.Manatee;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ManateeModel
extends EntityModel<Manatee> {
    private final ModelPart head;
    private final ModelPart finright;
    private final ModelPart finleft;
    private final ModelPart mainPart;
    private final ModelPart back;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 69).addBox(-7.0f, -8.2468f, -5.4432f, 14.0f, 14.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)-18.0f, (float)-0.0873f, (float)3.1416f, (float)0.0f));
        PartDefinition nosefront = head.addOrReplaceChild("nosefront", CubeListBuilder.create().texOffs(0, 98).addBox(-4.0f, -5.4475f, -2.3259f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.7532f, (float)18.5568f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition noseback = nosefront.addOrReplaceChild("noseback", CubeListBuilder.create().texOffs(64, 0).addBox(-5.0f, -13.0152f, -15.8264f, 10.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition finright = partdefinition.addOrReplaceChild("finright", CubeListBuilder.create().texOffs(0, 6).addBox(-1.1639f, 0.0844f, -2.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(96, 13).addBox(3.8361f, 0.0844f, -3.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition finleft = partdefinition.addOrReplaceChild("finleft", CubeListBuilder.create().texOffs(93, 0).addBox(-11.1654f, -1.3769f, -3.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.1654f, -1.3769f, -2.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.0f, (float)16.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition mainPart = partdefinition.addOrReplaceChild("mainPart", CubeListBuilder.create().texOffs(58, 71).addBox(-9.0f, -9.0f, -4.0f, 18.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-11.0f, -12.0f, -24.0f, 22.0f, 21.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-12.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition back = partdefinition.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 41).addBox(-9.0f, -5.993f, -9.7425f, 18.0f, 13.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)16.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition butt = back.addOrReplaceChild("butt", CubeListBuilder.create().texOffs(69, 26).addBox(-6.0f, -5.7778f, -9.0194f, 12.0f, 9.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.9734f, (float)-9.6101f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = butt.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(49, 52).addBox(-9.0f, 3.4086f, -15.1552f, 18.0f, 2.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-6.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ManateeModel(ModelPart root) {
        this.head = root.getChild("head");
        this.finright = root.getChild("finright");
        this.finleft = root.getChild("finleft");
        this.mainPart = root.getChild("mainPart");
        this.back = root.getChild("back");
    }

    public void setupAnim(Manatee entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float swingRate = entity.isInWater() ? 1.0f : 1.5f;
        float oscillation = -1.0f * swingRate * 0.2f * Mth.sin((float)(0.06f * ageInTicks));
        this.finright.zRot = oscillation * -2.0f;
        this.finleft.zRot = oscillation * 2.0f;
        this.head.xRot = oscillation * 0.5f;
        this.back.xRot = oscillation * 0.5f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.finright.render(poseStack, buffer, packedLight, packedOverlay);
        this.finleft.render(poseStack, buffer, packedLight, packedOverlay);
        this.mainPart.render(poseStack, buffer, packedLight, packedOverlay);
        this.back.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

