/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MuskOxModel
extends AgeableListModel<WoolyAnimal> {
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart hornL1;
    private final ModelPart hornL2;
    private final ModelPart hornR1;
    private final ModelPart hornR2;
    private final ModelPart snout;
    private final ModelPart beard;
    private final ModelPart quiviut;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(62, 21).addBox(-5.0f, -22.0f, -6.0f, 10.0f, 16.0f, 22.0f, new CubeDeformation(0.0f)).texOffs(56, 61).addBox(-6.0f, -19.0f, -11.0f, 12.0f, 16.0f, 24.0f, new CubeDeformation(0.0f)).texOffs(71, 102).addBox(-7.0f, -23.0f, -13.0f, 14.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-19.0f, (float)-13.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(56, 0).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-2.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition hornL1 = head.addOrReplaceChild("hornL1", CubeListBuilder.create().texOffs(13, 59).addBox(-2.6f, 0.3521f, -1.9674f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition hornL2 = hornL1.addOrReplaceChild("hornL2", CubeListBuilder.create().texOffs(0, 23).addBox(-1.608f, -0.2903f, -0.5f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.092f, (float)1.2903f, (float)-1.1233f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition hornLCube3_r1 = hornL2.addOrReplaceChild("hornLCube3_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.75f, -0.75f, 0.75f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.7014f, (float)1.2758f, (float)0.1107f, (float)0.0f, (float)-1.1781f, (float)0.9163f));
        PartDefinition hornR1 = head.addOrReplaceChild("hornR1", CubeListBuilder.create().texOffs(14, 39).addBox(-0.4f, 0.3521f, -1.9674f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition hornR2 = hornR1.addOrReplaceChild("hornR2", CubeListBuilder.create().texOffs(10, 23).addBox(-2.5934f, -1.0661f, -0.4874f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7934f, (float)2.5661f, (float)-1.0126f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition hornRCube3_r1 = hornR2.addOrReplaceChild("hornRCube3_r1", CubeListBuilder.create().texOffs(17, 0).addBox(-0.25f, -0.75f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f, (float)-0.9163f));
        PartDefinition snout = head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(0, 117).addBox(-3.0f, -4.7102f, -3.799f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.3499f, (float)-4.0589f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition beard = head.addOrReplaceChild("beard", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.0442f, -5.8944f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0442f, (float)-0.6163f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = body.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(0, 38).addBox(-1.5f, -7.0f, -2.5f, 4.0f, 17.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.25f, (float)-8.0f, (float)-7.5f));
        PartDefinition rightFrontLeg = body.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(86, 0).addBox(-2.25f, -7.0f, -2.5f, 4.0f, 17.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-8.0f, (float)-7.5f));
        PartDefinition leftHindLeg = body.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(102, 0).addBox(-1.75f, -2.0f, -1.5f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-9.0f, (float)9.5f));
        PartDefinition rightHindLeg = body.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(55, 103).addBox(-2.25f, -2.0f, -1.5f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-9.0f, (float)9.5f));
        PartDefinition quiviut = body.addOrReplaceChild("quiviut", CubeListBuilder.create().texOffs(0, 88).addBox(-8.0f, -24.0f, -13.5f, 16.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-6.5f, -22.5f, -10.5f, 13.0f, 15.0f, 27.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.5f, -20.0f, -11.5f, 15.0f, 13.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public MuskOxModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 19.0f);
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.hornL1 = this.head.getChild("hornL1");
        this.hornL2 = this.hornL1.getChild("hornL2");
        this.hornR1 = this.head.getChild("hornR1");
        this.hornR2 = this.hornR1.getChild("hornR2");
        this.beard = this.head.getChild("beard");
        this.snout = this.head.getChild("snout");
        this.leftHindLeg = this.body.getChild("leftHindLeg");
        this.rightHindLeg = this.body.getChild("rightHindLeg");
        this.leftFrontLeg = this.body.getChild("leftFrontLeg");
        this.rightFrontLeg = this.body.getChild("rightFrontLeg");
        this.quiviut = this.body.getChild("quiviut");
    }

    public void setupAnim(WoolyAnimal animal, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.hornL1.visible = this.hornR1.visible = animal.displayMaleCharacteristics();
        this.quiviut.visible = animal.hasProduct();
        this.head.xRot = headPitch * 0.006544985f + 0.873f;
        this.neck.xRot = headPitch * 0.004363323f;
        this.head.yRot = headYaw * ((float)Math.PI / 360);
        this.neck.yRot = headYaw * ((float)Math.PI / 360);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

