/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.WingedPrey;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PheasantModel
extends HierarchicalAnimatedModel<WingedPrey> {
    public static final AnimationDefinition PHEASANT_WALK = AnimationDefinition.Builder.withLength((float)1.0417f).looping().addAnimation("body", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)-0.3f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0416766f, KeyframeAnimations.posVec((float)0.0f, (float)-0.3f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)15.0f, (float)0.0f, (float)-1.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)20.0f, (float)0.0f, (float)1.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)25.0f, (float)0.0f, (float)0.11547f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, KeyframeAnimations.degreeVec((float)15.0f, (float)0.0f, (float)-1.5f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)-60.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, KeyframeAnimations.degreeVec((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("legL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-60.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, KeyframeAnimations.degreeVec((float)-15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)1.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)12.476381f, (float)-1.2497025f, (float)2.165407f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)9.910628f, (float)2.3064368f, (float)-4.4374533f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)1.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)-15.0f, (float)0.0f, (float)0.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)-17.5f, (float)0.0f, (float)-0.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)-32.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0416766f, KeyframeAnimations.degreeVec((float)-15.0f, (float)0.0f, (float)0.5f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0416766f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    private final ModelPart neck;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart wingR;
    private final ModelPart wingL;
    private final ModelPart tail;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -6.0f, -6.0f, 5.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legR = body.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 15).addBox(-1.5f, 5.0f, -2.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition haunch_r1 = legR.addOrReplaceChild("haunch_r1", CubeListBuilder.create().texOffs(13, 29).addBox(-1.0f, -2.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition legL = body.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(4, 0).addBox(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 15).addBox(-1.5f, 5.0f, -2.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition haunch_r2 = legL.addOrReplaceChild("haunch_r2", CubeListBuilder.create().texOffs(0, 31).addBox(-1.0f, -2.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition wingR = body.addOrReplaceChild("wingR", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-5.0f, (float)-1.0f));
        PartDefinition main_r1 = wingR.addOrReplaceChild("main_r1", CubeListBuilder.create().texOffs(13, 17).addBox(-1.0f, -1.0f, -2.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.5f, (float)-4.0f, (float)-4.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube1_r1 = neck.addOrReplaceChild("cube1_r1", CubeListBuilder.create().texOffs(31, 18).addBox(-2.0f, -2.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = neck.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(21, 0).addBox(-2.5028f, -3.7661f, -1.1073f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.9166f, (float)-0.909f, (float)0.6981f, (float)0.0044f, (float)0.0028f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 12).addBox(-1.51f, -2.0436f, -1.001f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-3.8334f, (float)-4.909f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition beak_r1 = head.addOrReplaceChild("beak_r1", CubeListBuilder.create().texOffs(0, 5).addBox(-0.5f, 2.5f, -2.25f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0436f, (float)-1.001f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = body.addOrReplaceChild("wingL", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-6.0f, (float)-1.0f));
        PartDefinition main_r2 = wingL.addOrReplaceChild("main_r2", CubeListBuilder.create().texOffs(22, 21).addBox(0.0f, -1.0f, -2.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, -2.0f, -1.25f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.25f, (float)3.25f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition end_r1 = tail.addOrReplaceChild("end_r1", CubeListBuilder.create().texOffs(0, 15).addBox(-1.0f, -1.5f, 0.75f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public PheasantModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.legR = this.body.getChild("legR");
        this.legL = this.body.getChild("legL");
        this.wingR = this.body.getChild("wingR");
        this.wingL = this.body.getChild("wingL");
        this.tail = this.body.getChild("tail");
    }

    @Override
    public void setupAnim(WingedPrey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        this.animateWalk(PHEASANT_WALK, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        if (!entity.onGround()) {
            this.wingR.zRot = ageInTicks;
            this.wingL.zRot = -ageInTicks;
        }
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
        this.neck.yRot = headYaw * ((float)Math.PI / 180);
    }
}

