/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class QuailModel
extends AgeableListModel<OviparousAnimal> {
    private final ModelPart body;
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart wingR;
    private final ModelPart wingL;
    private final ModelPart tail;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -6.0f, -4.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)21.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition legR = body.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(14, 0).addBox(-1.0f, 1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-2.0f, 3.0f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-1.0f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition legL = body.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(0.0f, 1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(23, 4).addBox(-1.0f, 3.0f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition wingR = body.addOrReplaceChild("wingR", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition main_r1 = wingR.addOrReplaceChild("main_r1", CubeListBuilder.create().texOffs(26, 22).addBox(-1.0f, -1.0f, 0.0f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = neck.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 4).addBox(-2.5028f, -3.7661f, -1.1073f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.9166f, (float)-0.909f, (float)0.6981f, (float)0.0044f, (float)0.0028f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(19, 11).addBox(-1.5f, -4.0436f, -1.001f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, -3).addBox(0.5f, -7.0436f, -2.001f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.3334f, (float)-2.909f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition beak_r1 = head.addOrReplaceChild("beak_r1", CubeListBuilder.create().texOffs(6, 0).addBox(-0.5f, 0.75f, -1.75f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0436f, (float)-1.001f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = body.addOrReplaceChild("wingL", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition main_r2 = wingL.addOrReplaceChild("main_r2", CubeListBuilder.create().texOffs(14, 25).addBox(0.0f, -1.0f, 0.0f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.0f, -1.25f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.25f, (float)3.25f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition end_r1 = tail.addOrReplaceChild("end_r1", CubeListBuilder.create().texOffs(14, 2).addBox(-1.0f, -1.5f, -0.25f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public QuailModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 18.0f);
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.legL = this.body.getChild("legL");
        this.legR = this.body.getChild("legR");
        this.wingL = this.body.getChild("wingL");
        this.wingR = this.body.getChild("wingR");
        this.tail = this.body.getChild("tail");
    }

    public void setupAnim(OviparousAnimal quail, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.head.xRot = headPitch * 0.01308997f;
        this.neck.xRot = headPitch * 0.004363323f;
        this.head.yRot = headYaw * ((float)Math.PI / 360);
        this.neck.yRot = headYaw * ((float)Math.PI / 360);
        this.legR.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legL.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (!quail.isInWater()) {
            this.body.zRot = Mth.cos((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.3f * limbSwingAmount;
            this.neck.zRot = Mth.cos((float)(limbSwing * 0.6662f + 1.5707964f)) * -0.25f * limbSwingAmount;
        }
        this.wingR.zRot = 0.0f;
        this.wingL.zRot = 0.0f;
        if (!quail.onGround()) {
            this.wingR.zRot = ageInTicks;
            this.wingL.zRot = -ageInTicks;
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

