/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TFCChickenModel
extends AgeableListModel<OviparousAnimal> {
    private final ModelPart body;
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart head;
    private final ModelPart wingR;
    private final ModelPart wingL;
    private final ModelPart neck;
    private final ModelPart tail;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition legR = body.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(6, 0).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(17, 4).addBox(-2.0f, 3.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition legL = body.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(23, 4).addBox(-1.0f, 3.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingR = body.addOrReplaceChild("wingR", CubeListBuilder.create().texOffs(0, 23).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)-5.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -5.9924f, -2.1743f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-1.5f, -3.9924f, -4.1743f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.5f, -9.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.5f, -2.0f, -3.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = body.addOrReplaceChild("wingL", CubeListBuilder.create().texOffs(10, 23).addBox(0.0f, 0.0f, -3.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(20, 13).addBox(0.0f, -11.0f, 0.0f, 0.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)1.25f));
        PartDefinition left_r1 = tail.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(33, 16).addBox(-0.5f, -9.0f, 0.0f, 0.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition right_r1 = tail.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(33, 3).addBox(0.5f, -9.0f, 0.0f, 0.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public TFCChickenModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 18.0f);
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.legL = this.body.getChild("legL");
        this.legR = this.body.getChild("legR");
        this.wingL = this.body.getChild("wingL");
        this.wingR = this.body.getChild("wingR");
        this.tail = this.body.getChild("tail");
    }

    public void setupAnim(OviparousAnimal chicken, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float xPose = 0.0f;
        if (chicken.displayMaleCharacteristics()) {
            xPose = -0.71f;
        }
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.legR.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - xPose;
        this.legL.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - xPose;
        this.wingR.zRot = 0.0f;
        this.wingL.zRot = 0.0f;
        if (!chicken.isInWater()) {
            this.body.xRot = Mth.cos((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.25f * limbSwingAmount + xPose;
            this.neck.xRot = Mth.cos((float)(limbSwing * 0.6662f + 1.5707964f)) * -0.23f * limbSwingAmount - xPose;
        } else {
            this.body.xRot = xPose;
            this.neck.xRot = -xPose;
        }
        if (!chicken.onGround()) {
            this.wingR.zRot = ageInTicks;
            this.wingL.zRot = -ageInTicks;
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

