/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;

public class TFCPigModel<T extends Mob>
extends PigModel<T> {
    private final ModelPart tusk1;
    private final ModelPart tusk2;

    public static LayerDefinition createTFCBodyLayer(CubeDeformation def) {
        MeshDefinition meshdefinition = QuadrupedModel.createBodyMesh((int)6, (CubeDeformation)def);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, def).texOffs(16, 16).addBox(-2.0f, 0.0f, -9.0f, 4.0f, 3.0f, 1.0f, def), PartPose.offset((float)0.0f, (float)12.0f, (float)-6.0f));
        head.addOrReplaceChild("tusk1", CubeListBuilder.create().texOffs(32, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-3.0f, (float)0.5f, (float)-9.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("tusk2", CubeListBuilder.create().texOffs(32, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)-9.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public TFCPigModel(ModelPart root) {
        super(root);
        this.tusk1 = root.getChild("head").getChild("tusk1");
        this.tusk2 = root.getChild("head").getChild("tusk2");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.tusk1.visible = this.tusk2.visible = ((GenderedRenderAnimal)entity).displayMaleCharacteristics();
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }
}

