/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TFCSheepModel
extends AgeableListModel<WoolyAnimal> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart woolBody;
    private final ModelPart woolHead;
    private final ModelPart woolLeftFrontLeg;
    private final ModelPart woolLeftHindLeg;
    private final ModelPart woolRightFrontLeg;
    private final ModelPart woolRightHindLeg;
    private final ModelPart leftHorn;
    private final ModelPart rightHorn;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 29).addBox(-4.0f, -5.0f, -8.0f, 8.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition woolBody = body.addOrReplaceChild("woolBody", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -7.0f, -9.0f, 11.0f, 11.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftFrontLeg = body.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(78, 0).addBox(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition woolLeftFrontLeg = leftFrontLeg.addOrReplaceChild("woolLeftFrontLeg", CubeListBuilder.create().texOffs(0, 53).addBox(8.0f, 1.0f, -8.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = body.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(66, 0).addBox(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)0.0f, (float)0.0f));
        PartDefinition woolRightFrontLeg = rightFrontLeg.addOrReplaceChild("woolRightFrontLeg", CubeListBuilder.create().texOffs(53, 24).addBox(1.0f, 1.0f, -8.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = body.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(0, 29).addBox(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)12.25f));
        PartDefinition woolLeftHindLeg = leftHindLeg.addOrReplaceChild("woolLeftHindLeg", CubeListBuilder.create().texOffs(20, 53).addBox(8.0f, 1.0f, 4.25f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)0.0f, (float)-12.25f));
        PartDefinition rightHindLeg = body.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(0, 0).addBox(2.0f, 1.0f, -7.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)0.0f, (float)12.25f));
        PartDefinition woolRightHindLeg = rightHindLeg.addOrReplaceChild("woolRightHindLeg", CubeListBuilder.create().texOffs(43, 48).addBox(1.0f, 1.0f, 4.25f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-12.25f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(40, 0).addBox(-3.0f, -6.0f, -5.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-9.0f));
        PartDefinition woolHead = head.addOrReplaceChild("woolHead", CubeListBuilder.create().texOffs(32, 29).addBox(-3.5f, -6.5f, -3.75f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn = head.addOrReplaceChild("leftHorn", CubeListBuilder.create().texOffs(90, 0).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        PartDefinition cube_r1 = leftHorn.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(90, 8).addBox(-1.5039f, -1.0643f, -4.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r2 = leftHorn.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(90, 4).addBox(1.5f, 0.5f, -3.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition cube_r3 = leftHorn.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(90, 10).addBox(0.75f, -0.75f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition rightHorn = head.addOrReplaceChild("rightHorn", CubeListBuilder.create().texOffs(90, 0).mirror().addBox(-2.0f, -2.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition cube_r4 = rightHorn.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(90, 8).mirror().addBox(-0.4961f, -1.0643f, -4.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r5 = rightHorn.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(90, 4).mirror().addBox(-3.5f, 0.5f, -3.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition cube_r6 = rightHorn.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(90, 10).mirror().addBox(-2.75f, -0.75f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public TFCSheepModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 18.0f);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.woolBody = this.body.getChild("woolBody");
        this.woolHead = this.head.getChild("woolHead");
        this.rightHorn = this.head.getChild("rightHorn");
        this.leftHorn = this.head.getChild("leftHorn");
        this.leftHindLeg = this.body.getChild("leftHindLeg");
        this.rightHindLeg = this.body.getChild("rightHindLeg");
        this.leftFrontLeg = this.body.getChild("leftFrontLeg");
        this.rightFrontLeg = this.body.getChild("rightFrontLeg");
        this.woolLeftHindLeg = this.leftHindLeg.getChild("woolLeftHindLeg");
        this.woolLeftFrontLeg = this.leftFrontLeg.getChild("woolLeftFrontLeg");
        this.woolRightHindLeg = this.rightHindLeg.getChild("woolRightHindLeg");
        this.woolRightFrontLeg = this.rightFrontLeg.getChild("woolRightFrontLeg");
    }

    public void setupAnim(WoolyAnimal sheep, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.rightHorn.visible = this.leftHorn.visible = sheep.displayMaleCharacteristics();
        this.woolRightFrontLeg.visible = this.woolRightHindLeg.visible = sheep.hasProduct();
        this.woolLeftHindLeg.visible = this.woolRightHindLeg.visible;
        this.woolLeftFrontLeg.visible = this.woolRightHindLeg.visible;
        this.woolHead.visible = this.woolRightHindLeg.visible;
        this.woolBody.visible = this.woolRightHindLeg.visible;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.9f)) * 0.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.9f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.9f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.9f)) * 0.4f * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

