/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.common.blockentities.VaneBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class VaneModel
extends Model {
    private final ModelPart base;
    private final ModelPart static_parts;
    private final ModelPart spinny;

    public VaneModel(ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.base = root.getChild("base");
        this.static_parts = root.getChild("static");
        this.spinny = root.getChild("spinny");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = base.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(48, 58).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition static_parts = partdefinition.addOrReplaceChild("static", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r2 = static_parts.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 1).addBox(0.0f, -7.0f, -8.0f, 1.0f, 7.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-8.0f, -7.0f, 0.0f, 16.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition spinny = partdefinition.addOrReplaceChild("spinny", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition cube_r3 = spinny.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 48).addBox(-8.0f, -18.0f, 0.0f, 16.0f, 15.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(1, 0).addBox(0.0f, -18.0f, -1.0f, 1.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.static_parts.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.spinny.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void renderBase(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.base.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(VaneBlockEntity vane, float partialTick) {
        this.spinny.yRot = (float)((double)vane.getAngle(partialTick) + 1.5707963267948966);
    }
}

