/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class AnimatedParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public AnimatedParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.xd = Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f);
        this.yd = Mth.nextFloat((RandomSource)this.random, (float)-0.05f, (float)0.1f);
        this.zd = Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f);
        this.lifetime = 40 + this.random.nextInt(60);
        this.scale(0.5f + this.random.nextFloat());
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.setSprite(this.sprites.get(this.age % 4, 4));
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new AnimatedParticle(level, x, y, z, this.sprites);
        }
    }
}

