/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.world.Codecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;

public class FluidParticleOption
implements ParticleOptions {
    private final ParticleType<FluidParticleOption> type;
    private final Fluid fluid;

    public static MapCodec<FluidParticleOption> codec(ParticleType<FluidParticleOption> type) {
        return Codecs.FLUID.xmap(fluid -> new FluidParticleOption(type, (Fluid)fluid), option -> option.fluid).fieldOf("fluid");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, FluidParticleOption> streamCodec(ParticleType<FluidParticleOption> type) {
        return ByteBufCodecs.registry((ResourceKey)Registries.FLUID).map(fluid -> new FluidParticleOption(type, (Fluid)fluid), option -> option.fluid);
    }

    public FluidParticleOption(ParticleType<FluidParticleOption> type, Fluid fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public ParticleType<?> getType() {
        return this.type;
    }
}

