/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.client.particle.Butterfly;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"tfc");
    public static final Id<SimpleParticleType> BUBBLE = TFCParticles.register("bubble");
    public static final Id<SimpleParticleType> WATER_FLOW = TFCParticles.register("water_flow");
    public static final Id<SimpleParticleType> STEAM = TFCParticles.register("steam");
    public static final Id<SimpleParticleType> NITROGEN = TFCParticles.register("nitrogen");
    public static final Id<SimpleParticleType> PHOSPHORUS = TFCParticles.register("phosphorus");
    public static final Id<SimpleParticleType> POTASSIUM = TFCParticles.register("potassium");
    public static final Id<SimpleParticleType> COMPOST_READY = TFCParticles.register("compost_ready");
    public static final Id<SimpleParticleType> COMPOST_ROTTEN = TFCParticles.register("compost_rotten");
    public static final Id<SimpleParticleType> SLEEP = TFCParticles.register("sleep");
    public static final Id<SimpleParticleType> LEAF = TFCParticles.register("leaf");
    public static final Id<SimpleParticleType> WIND = TFCParticles.register("wind");
    public static final Id<SimpleParticleType> SNOWFLAKE = TFCParticles.register("snowflake");
    public static final Id<SimpleParticleType> FLYING_SNOWFLAKE = TFCParticles.register("flying_snowflake");
    public static final Id<ParticleType<BlockParticleOption>> FALLING_LEAF = TFCParticles.register("falling_leaf", BlockParticleOption::codec, BlockParticleOption::streamCodec);
    public static final Id<SimpleParticleType> FEATHER = TFCParticles.register("feather");
    public static final Id<SimpleParticleType> SPARK = TFCParticles.register("spark");
    public static final Map<Butterfly, Id<SimpleParticleType>> BUTTERFLIES = Helpers.mapOf(Butterfly.class, b -> TFCParticles.register(b.name().toLowerCase(Locale.ROOT)));
    public static final Id<SimpleParticleType> SMOKE_0 = TFCParticles.register("smoke_0");
    public static final Id<SimpleParticleType> SMOKE_1 = TFCParticles.register("smoke_1");
    public static final Id<SimpleParticleType> SMOKE_2 = TFCParticles.register("smoke_2");
    public static final Id<SimpleParticleType> SMOKE_3 = TFCParticles.register("smoke_3");
    public static final Id<SimpleParticleType> SMOKE_4 = TFCParticles.register("smoke_4");
    public static final Id<ParticleType<FluidParticleOption>> FLUID_DRIP = TFCParticles.register("fluid_drip", FluidParticleOption::codec, FluidParticleOption::streamCodec);
    public static final Id<ParticleType<FluidParticleOption>> FLUID_FALL = TFCParticles.register("fluid_fall", FluidParticleOption::codec, FluidParticleOption::streamCodec);
    public static final Id<ParticleType<FluidParticleOption>> FLUID_LAND = TFCParticles.register("fluid_land", FluidParticleOption::codec, FluidParticleOption::streamCodec);
    public static final Id<ParticleType<FluidParticleOption>> BARREL_DRIP = TFCParticles.register("barrel_drip", FluidParticleOption::codec, FluidParticleOption::streamCodec);
    public static final List<Id<SimpleParticleType>> SMOKES = List.of(SMOKE_0, SMOKE_1, SMOKE_2, SMOKE_3, SMOKE_4);

    private static <O extends ParticleOptions> Id<ParticleType<O>> register(String name, final Function<ParticleType<O>, MapCodec<O>> codec, final Function<ParticleType<O>, StreamCodec<? super RegistryFriendlyByteBuf, O>> streamCodec) {
        return new Id<ParticleType<O>>(PARTICLE_TYPES.register(name, () -> new ParticleType<O>(false){

            public MapCodec<O> codec() {
                return (MapCodec)codec.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, O> streamCodec() {
                return (StreamCodec)streamCodec.apply(this);
            }
        }));
    }

    private static Id<SimpleParticleType> register(String name) {
        return new Id<SimpleParticleType>(PARTICLE_TYPES.register(name, () -> new SimpleParticleType(false)));
    }

    public record Id<T extends ParticleType<?>>(DeferredHolder<ParticleType<?>, T> holder) implements RegistryHolder<ParticleType<?>, T>
    {
    }
}

